/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.particle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import padej.soup.base.util.particle.AbstractParticle;
import padej.soup.base.util.spatial.BlockCollisionGrid;

public class ParticleUpdateExecutor {
    private static final int THREAD_COUNT = Math.max(2, Runtime.getRuntime().availableProcessors() / 2);
    private static final ExecutorService executor = Executors.newFixedThreadPool(THREAD_COUNT, r -> {
        Thread thread = new Thread(r);
        thread.setName("ParticleUpdate-" + thread.getId());
        thread.setDaemon(true);
        return thread;
    });

    public static <T extends AbstractParticle> List<T> updateParticles(List<T> particles, long currentTime, Predicate<T> isVisible) {
        return ParticleUpdateExecutor.updateParticles(particles, currentTime, isVisible, null);
    }

    public static <T extends AbstractParticle> List<T> updateParticles(List<T> particles, long currentTime, Predicate<T> isVisible, BlockCollisionGrid collisionGrid) {
        if (particles.isEmpty()) {
            return new ArrayList();
        }
        if (particles.size() < 50) {
            ArrayList<AbstractParticle> toRemove = new ArrayList<AbstractParticle>();
            for (AbstractParticle particle : particles) {
                if (!particle.update(currentTime, isVisible.test(particle), collisionGrid)) continue;
                toRemove.add(particle);
            }
            return toRemove;
        }
        int chunkSize = Math.max(1, particles.size() / THREAD_COUNT);
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
        for (int i = 0; i < particles.size(); i += chunkSize) {
            int start = i;
            int n = Math.min(i + chunkSize, particles.size());
            futures.add(executor.submit(() -> {
                ArrayList<AbstractParticle> toRemove = new ArrayList<AbstractParticle>();
                for (int j = start; j < end; ++j) {
                    AbstractParticle particle = (AbstractParticle)particles.get(j);
                    if (!particle.update(currentTime, isVisible.test(particle), collisionGrid)) continue;
                    toRemove.add(particle);
                }
                return toRemove;
            }));
        }
        ArrayList toRemove = new ArrayList();
        for (Future future : futures) {
            try {
                toRemove.addAll((Collection)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return toRemove;
    }

    public static void shutdown() {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
        }
    }
}

