/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.render.Render3DUtil;

public class ChinaHatBatchRenderer
implements QuickImports {
    private static final ConcurrentLinkedQueue<HatRenderData> HAT_QUEUE = new ConcurrentLinkedQueue();
    private static final ConcurrentLinkedQueue<OutlineLineData> OUTLINE_QUEUE = new ConcurrentLinkedQueue();
    private static final Map<Long, Integer> COLOR_INTERPOLATION_CACHE = new HashMap<Long, Integer>();
    public static final class_1921 HAT_LAYER = class_1921.method_24048((String)"china_hat_batch", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27379, (int)1536, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_4668.field_29442).method_23615(class_4668.field_21370).method_23617(false));

    public static void queueHat(class_4587 matrices, class_4597 vertexConsumers, int step, float centerY, float brimY, float radius, float centerAlpha, float edgeAlpha, int[] gradientColors) {
        Matrix4f positionMatrix = new Matrix4f((Matrix4fc)matrices.method_23760().method_23761());
        HAT_QUEUE.add(new HatRenderData(positionMatrix, vertexConsumers, step, centerY, brimY, radius, centerAlpha, edgeAlpha, gradientColors));
    }

    public static void renderBatches() {
        if (HAT_QUEUE.isEmpty()) {
            return;
        }
        while (!HAT_QUEUE.isEmpty()) {
            HatRenderData data = HAT_QUEUE.poll();
            ChinaHatBatchRenderer.renderSingleHat(data);
        }
        ChinaHatBatchRenderer.renderBatchedOutlines();
    }

    private static void renderSingleHat(HatRenderData data) {
        int alphaCenterColor;
        int alphaColor2;
        int alphaColor1;
        int centerColor;
        int color2;
        int color1;
        float z2;
        float x2;
        float z1;
        float x1;
        float angle2;
        float angle1;
        int i;
        Matrix4f matrix = data.positionMatrix;
        class_4588 vertexConsumer = data.vertexConsumers.getBuffer(HAT_LAYER);
        for (i = 0; i < 360; i += data.step) {
            angle1 = (float)i * ((float)Math.PI / 180);
            angle2 = (float)(i + data.step) * ((float)Math.PI / 180);
            x1 = class_3532.method_15374((float)angle1) * data.radius;
            z1 = -class_3532.method_15362((float)angle1) * data.radius;
            x2 = class_3532.method_15374((float)angle2) * data.radius;
            z2 = -class_3532.method_15362((float)angle2) * data.radius;
            color1 = ChinaHatBatchRenderer.getGradientColor(i, data.gradientColors);
            color2 = ChinaHatBatchRenderer.getGradientColor(i + data.step, data.gradientColors);
            centerColor = ChinaHatBatchRenderer.getGradientColor(i, data.gradientColors);
            alphaColor1 = color1 & 0xFFFFFF | (int)(data.edgeAlpha * 255.0f) << 24;
            alphaColor2 = color2 & 0xFFFFFF | (int)(data.edgeAlpha * 255.0f) << 24;
            alphaCenterColor = centerColor & 0xFFFFFF | (int)(data.centerAlpha * 255.0f) << 24;
            vertexConsumer.method_22918(matrix, 0.0f, data.centerY, 0.0f).method_39415(alphaCenterColor);
            vertexConsumer.method_22918(matrix, x1, data.brimY, z1).method_39415(alphaColor1);
            vertexConsumer.method_22918(matrix, x2, data.brimY, z2).method_39415(alphaColor2);
        }
        for (i = 0; i < 360; i += data.step) {
            angle1 = (float)i * ((float)Math.PI / 180);
            angle2 = (float)(i + data.step) * ((float)Math.PI / 180);
            x1 = class_3532.method_15374((float)angle1) * data.radius;
            z1 = -class_3532.method_15362((float)angle1) * data.radius;
            x2 = class_3532.method_15374((float)angle2) * data.radius;
            z2 = -class_3532.method_15362((float)angle2) * data.radius;
            color1 = ColorUtil.darker(ChinaHatBatchRenderer.getGradientColor(i, data.gradientColors), 4);
            color2 = ColorUtil.darker(ChinaHatBatchRenderer.getGradientColor(i + data.step, data.gradientColors), 4);
            centerColor = ColorUtil.darker(ChinaHatBatchRenderer.getGradientColor(i, data.gradientColors));
            alphaColor1 = color1 & 0xFFFFFF | (int)(data.edgeAlpha * 255.0f) << 24;
            alphaColor2 = color2 & 0xFFFFFF | (int)(data.edgeAlpha * 255.0f) << 24;
            alphaCenterColor = centerColor & 0xFFFFFF | (int)(data.centerAlpha * 255.0f) << 24;
            vertexConsumer.method_22918(matrix, x2, data.brimY, z2).method_39415(alphaColor2);
            vertexConsumer.method_22918(matrix, x1, data.brimY, z1).method_39415(alphaColor1);
            vertexConsumer.method_22918(matrix, 0.0f, data.centerY, 0.0f).method_39415(alphaCenterColor);
        }
        ChinaHatBatchRenderer.queueOutlineLines(data);
    }

    private static void queueOutlineLines(HatRenderData data) {
        if (ChinaHatBatchRenderer.mc.field_1755 instanceof class_481 || ChinaHatBatchRenderer.mc.field_1755 instanceof class_490) {
            return;
        }
        for (int i = 0; i < 360; i += data.step) {
            float x1 = class_3532.method_15374((float)((float)i * ((float)Math.PI / 180))) * data.radius;
            float z1 = -class_3532.method_15362((float)((float)i * ((float)Math.PI / 180))) * data.radius;
            float x2 = class_3532.method_15374((float)((float)(i + data.step) * ((float)Math.PI / 180))) * data.radius;
            float z2 = -class_3532.method_15362((float)((float)(i + data.step) * ((float)Math.PI / 180))) * data.radius;
            Vector3f start = new Vector3f(x1, data.brimY, z1);
            Vector3f end = new Vector3f(x2, data.brimY, z2);
            int color1 = ChinaHatBatchRenderer.getGradientColor(i, data.gradientColors);
            int color2 = ChinaHatBatchRenderer.getGradientColor(i + data.step, data.gradientColors);
            int darkerColor1 = ColorUtil.darker(color1) | 0xFF000000;
            int darkerColor2 = ColorUtil.darker(color2) | 0xFF000000;
            OUTLINE_QUEUE.add(new OutlineLineData(data.positionMatrix, start, end, darkerColor1, darkerColor2));
        }
    }

    private static void renderBatchedOutlines() {
        if (OUTLINE_QUEUE.isEmpty()) {
            return;
        }
        GL11.glHint((int)3154, (int)4354);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader((class_10156)class_10142.field_53864);
        RenderSystem.lineWidth((float)4.0f);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27377, class_290.field_29337);
        while (!OUTLINE_QUEUE.isEmpty()) {
            OutlineLineData lineData = OUTLINE_QUEUE.poll();
            class_4587 tempStack = new class_4587();
            tempStack.method_23760().method_23761().set((Matrix4fc)lineData.positionMatrix);
            class_4587.class_4665 entry = tempStack.method_23760();
            Render3DUtil.vertexLine(entry, (class_4588)buffer, lineData.start, lineData.end, lineData.colorStart, lineData.colorEnd);
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private static int getGradientColor(float angle, int[] customColors) {
        if (customColors != null && customColors.length > 0) {
            float normalizedAngle = angle % 360.0f;
            if (normalizedAngle < 0.0f) {
                normalizedAngle += 360.0f;
            }
            float degreesPerColor = 360.0f / (float)customColors.length;
            int colorIndex1 = (int)(normalizedAngle / degreesPerColor) % customColors.length;
            int colorIndex2 = (colorIndex1 + 1) % customColors.length;
            float factor = normalizedAngle % degreesPerColor / degreesPerColor;
            int color1 = customColors[colorIndex1];
            int color2 = customColors[colorIndex2];
            return ChinaHatBatchRenderer.interpolateColor(color1, color2, factor);
        }
        return ColorUtil.getClientColor();
    }

    private static int interpolateColor(int color1, int color2, float factor) {
        int quantizedFactor = (int)(factor * 100.0f);
        long key = (long)color1 << 32 | (long)color2 & 0xFFFFFFFFL | (long)quantizedFactor << 48;
        Integer cached = COLOR_INTERPOLATION_CACHE.get(key);
        if (cached != null) {
            return cached;
        }
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * factor);
        int r = (int)((float)r1 + (float)(r2 - r1) * factor);
        int g = (int)((float)g1 + (float)(g2 - g1) * factor);
        int b = (int)((float)b1 + (float)(b2 - b1) * factor);
        int result = a << 24 | r << 16 | g << 8 | b;
        if (COLOR_INTERPOLATION_CACHE.size() < 10000) {
            COLOR_INTERPOLATION_CACHE.put(key, result);
        }
        return result;
    }

    private record HatRenderData(Matrix4f positionMatrix, class_4597 vertexConsumers, int step, float centerY, float brimY, float radius, float centerAlpha, float edgeAlpha, int[] gradientColors) {
    }

    private record OutlineLineData(Matrix4f positionMatrix, Vector3f start, Vector3f end, int colorStart, int colorEnd) {
    }
}

