/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import org.joml.Matrix4f;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.QuickImports;
import padej.soup.base.util.animation.Interpolation;
import padej.soup.base.util.animation.Interpolations;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.render.Render2DUtil;
import padej.soup.implement.features.modules.hud.CrossHair;

public final class CrosshairRenderer
implements QuickImports {
    private static final class_1921 CROSSHAIR_INVERT_LAYER = class_1921.method_24048((String)"crosshair_invert", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27382, (int)1536, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_4668.field_29442).method_23615(new class_4668.class_4685("crosshair_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    })).method_23617(false));
    private static final class_1921 CROSSHAIR_INVERT_TRIANGLES = class_1921.method_24048((String)"crosshair_invert_triangles", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27379, (int)1536, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_4668.field_29442).method_23615(new class_4668.class_4685("crosshair_transparency_tri", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    })).method_23617(false));
    private static float colorAnimation = 0.0f;
    private static float hitAnimation = 0.0f;
    private static float lastAttackProgress = 1.0f;

    public static void render(CrossHair module) {
        float colorSpeed = module.getStyleSetting().getSelected().equals("Blob") ? module.getColorAnimationSpeedSetting().getValue() : 2.0f;
        colorAnimation = MathUtil.interpolateSmooth((double)colorSpeed, colorAnimation, CrosshairRenderer.mc.field_1765 instanceof class_3966 ? 1.0f : 0.0f);
        int mainColor = CrosshairRenderer.getCrosshairColor(module);
        float centerX = (float)window.method_4486() / 2.0f;
        float centerY = (float)window.method_4502() / 2.0f;
        if (module.getDynamicSetting().isValue()) {
            CrosshairRenderer.updateDynamicPosition(module, centerX, centerY);
            centerX = module.xAnim;
            centerY = module.yAnim;
        } else {
            module.xAnim = centerX;
            module.yAnim = centerY;
        }
        float cooldown = (float)module.getAttackSetting().getInt() - (float)module.getAttackSetting().getInt() * CrosshairRenderer.mc.field_1724.method_7261(tickCounter.method_60637(false));
        String style = module.getStyleSetting().getSelected();
        if ("Cross".equals(style)) {
            CrosshairRenderer.renderCross(module, centerX, centerY, cooldown, mainColor);
        } else if ("Blob".equals(style)) {
            CrosshairRenderer.renderBlob(module, centerX, centerY, mainColor);
        } else if ("Ring".equals(style)) {
            CrosshairRenderer.renderRing(module, centerX, centerY, mainColor);
        }
    }

    private static void updateDynamicPosition(CrossHair module, float midX, float midY) {
        float yawDelta = CrosshairRenderer.mc.field_1724.field_6259 - CrosshairRenderer.mc.field_1724.method_5791();
        float pitchDelta = module.prevPitch - CrosshairRenderer.mc.field_1724.method_36455();
        module.prevPitch = CrosshairRenderer.mc.field_1724.method_36455();
        float invertMultiplier = module.getDynamicInvertSetting().isValue() ? -1.0f : 1.0f;
        float speed = module.getDynamicSpeedSetting().getValue() * 0.05f;
        module.xAnim += yawDelta * speed * invertMultiplier;
        module.yAnim += pitchDelta * speed * invertMultiplier;
        float offsetX = module.xAnim - midX;
        float offsetY = module.yAnim - midY;
        double distance = Math.sqrt(offsetX * offsetX + offsetY * offsetY);
        float range = module.getDynamicRangeSetting().getInt();
        double attractionFactor = Math.min(distance / (double)range, 1.0);
        float maxSmoothingFactor = module.getDynamicBackSpeedSetting().getValue() * 0.1f;
        float smoothingFactor = (float)((double)maxSmoothingFactor * attractionFactor);
        smoothingFactor = Math.min(smoothingFactor, 0.8f);
        module.xAnim += (midX - module.xAnim) * smoothingFactor;
        module.yAnim += (midY - module.yAnim) * smoothingFactor;
    }

    private static void renderCross(CrossHair module, float centerX, float centerY, float cooldown, int mainColor) {
        float width = module.getSize1Setting().getValue();
        float height = module.getSize2Setting().getValue();
        float offset = height / 2.0f;
        float indent = (float)module.getIndentSetting().getInt() + cooldown;
        if (module.getInvertColorSetting().isValue()) {
            class_4587 matrices = new class_4587();
            Matrix4f matrix = matrices.method_23760().method_23761();
            class_4597.class_4598 immediate = mc.method_22940().method_23000();
            class_4588 vertexConsumer = immediate.getBuffer(CROSSHAIR_INVERT_LAYER);
            int white = -1;
            CrosshairRenderer.renderQuad(vertexConsumer, matrix, centerX - offset, centerY - width - indent, height, width, white);
            CrosshairRenderer.renderQuad(vertexConsumer, matrix, centerX - offset, centerY + indent, height, width, white);
            CrosshairRenderer.renderQuad(vertexConsumer, matrix, centerX - width - indent, centerY - offset, width, height, white);
            CrosshairRenderer.renderQuad(vertexConsumer, matrix, centerX + indent, centerY - offset, width, height, white);
            immediate.method_22993();
        } else {
            int outlineColor = ColorUtil.BLACK;
            CrosshairRenderer.renderCrosshairLines(centerX, centerY, width, height, 1.0f, indent, offset, outlineColor);
            CrosshairRenderer.renderCrosshairLines(centerX, centerY, width, height, 0.0f, indent, offset, mainColor);
        }
    }

    private static void renderQuad(class_4588 buffer, Matrix4f matrix, float x, float y, float width, float height, int color) {
        buffer.method_22918(matrix, x, y, 0.0f).method_39415(color);
        buffer.method_22918(matrix, x, y + height, 0.0f).method_39415(color);
        buffer.method_22918(matrix, x + width, y + height, 0.0f).method_39415(color);
        buffer.method_22918(matrix, x + width, y, 0.0f).method_39415(color);
    }

    private static void renderBlob(CrossHair module, float centerX, float centerY, int mainColor) {
        class_332 context = new class_332(mc, mc.method_22940().method_23000());
        class_4587 matrix = context.method_51448();
        float attackSizeMultiplier = module.getAttackSizeMultiplierSetting().getValue();
        float entityWidthMultiplier = module.getEntityWidthMultiplierSetting().getValue();
        float entityHeightMultiplier = module.getEntityHeightMultiplierSetting().getValue();
        float hitStretchMultiplier = module.getHitStretchMultiplierSetting().getValue();
        float hitDetectionThreshold = 0.9f;
        float hitResetThreshold = 0.1f;
        float outlineThickness = module.getOutlineThicknessSetting().getValue();
        float fillMaxAlpha = module.getFillMaxAlphaSetting().getValue();
        boolean enableFill = module.getEnableFillSetting().isValue();
        float baseSize = module.getBlobSizeSetting().getValue();
        float thickness = module.getBlobThicknessSetting().getValue();
        float attackProgress = 1.0f - CrosshairRenderer.mc.field_1724.method_7261(tickCounter.method_60637(false));
        if (lastAttackProgress > hitDetectionThreshold && attackProgress < hitResetThreshold && CrosshairRenderer.mc.field_1765 instanceof class_3966) {
            hitAnimation = 1.0f;
        }
        lastAttackProgress = attackProgress;
        float hitSpeed = module.getHitAnimationSpeedSetting().getValue();
        hitAnimation = MathUtil.interpolateSmooth((double)hitSpeed, hitAnimation, 0.0f);
        Interpolation interpolation = Interpolations.getByName(module.getAnimationTypeSetting().getSelected());
        float easedProgress = (float)interpolation.interpolate(attackProgress);
        float animatedSize = baseSize + baseSize * attackSizeMultiplier * easedProgress;
        float width = animatedSize * (1.0f + colorAnimation * entityWidthMultiplier);
        float height = baseSize * (1.0f - colorAnimation * entityHeightMultiplier);
        float rounded = baseSize / 2.0f * (1.0f - colorAnimation * entityHeightMultiplier);
        float hitMultiplier = 1.0f + hitAnimation * hitStretchMultiplier;
        int fillColor = enableFill ? ColorUtil.replAlpha(mainColor, easedProgress * fillMaxAlpha) : ColorUtil.replAlpha(mainColor, 0);
        rectangle.render(ShapeProperties.create(matrix, centerX - (width *= hitMultiplier) / 2.0f, centerY - (height /= hitMultiplier) / 2.0f, width, height).round(rounded).thickness(outlineThickness).outlineColor(mainColor).color(fillColor).build());
    }

    private static void renderEllipse(class_4588 buffer, Matrix4f matrix, float x, float y, float width, float height, int color) {
        int segments = 64;
        float centerX = x + width / 2.0f;
        float centerY = y + height / 2.0f;
        float radiusX = width / 2.0f;
        float radiusY = height / 2.0f;
        for (int i = 0; i < segments; ++i) {
            float angle1 = (float)(Math.PI * 2 * (double)i / (double)segments);
            float angle2 = (float)(Math.PI * 2 * (double)(i + 1) / (double)segments);
            float x1 = centerX + (float)Math.cos(angle1) * radiusX;
            float y1 = centerY + (float)Math.sin(angle1) * radiusY;
            float x2 = centerX + (float)Math.cos(angle2) * radiusX;
            float y2 = centerY + (float)Math.sin(angle2) * radiusY;
            buffer.method_22918(matrix, centerX, centerY, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x1, y1, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x2, y2, 0.0f).method_39415(color);
        }
    }

    private static void renderRoundedRect(class_4588 buffer, Matrix4f matrix, float x, float y, float width, float height, float radius, int color) {
        float maxRadius = Math.min(width, height) / 2.0f;
        if ((radius = Math.min(radius, maxRadius)) <= 0.0f) {
            CrosshairRenderer.renderQuad(buffer, matrix, x, y, width, height, color);
            return;
        }
        float innerX = x + radius;
        float innerY = y + radius;
        float innerWidth = width - radius * 2.0f;
        float innerHeight = height - radius * 2.0f;
        if (innerWidth > 0.0f) {
            CrosshairRenderer.renderQuad(buffer, matrix, innerX, y, innerWidth, height, color);
        }
        if (innerHeight > 0.0f) {
            CrosshairRenderer.renderQuad(buffer, matrix, x, innerY, radius, innerHeight, color);
            CrosshairRenderer.renderQuad(buffer, matrix, innerX + innerWidth, innerY, radius, innerHeight, color);
        }
        int cornerSegments = 16;
        CrosshairRenderer.renderCorner(buffer, matrix, innerX, innerY, radius, 180.0f, 270.0f, cornerSegments, color);
        CrosshairRenderer.renderCorner(buffer, matrix, innerX + innerWidth, innerY, radius, 270.0f, 360.0f, cornerSegments, color);
        CrosshairRenderer.renderCorner(buffer, matrix, innerX + innerWidth, innerY + innerHeight, radius, 0.0f, 90.0f, cornerSegments, color);
        CrosshairRenderer.renderCorner(buffer, matrix, innerX, innerY + innerHeight, radius, 90.0f, 180.0f, cornerSegments, color);
    }

    private static void renderCorner(class_4588 buffer, Matrix4f matrix, float centerX, float centerY, float radius, float startAngle, float endAngle, int segments, int color) {
        float angleStep = (endAngle - startAngle) / (float)segments;
        for (int i = 0; i < segments; ++i) {
            float angle1 = (float)Math.toRadians(startAngle + (float)i * angleStep);
            float angle2 = (float)Math.toRadians(startAngle + (float)(i + 1) * angleStep);
            float x1 = centerX + (float)Math.cos(angle1) * radius;
            float y1 = centerY + (float)Math.sin(angle1) * radius;
            float x2 = centerX + (float)Math.cos(angle2) * radius;
            float y2 = centerY + (float)Math.sin(angle2) * radius;
            buffer.method_22918(matrix, centerX, centerY, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x1, y1, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x2, y2, 0.0f).method_39415(color);
            buffer.method_22918(matrix, centerX, centerY, 0.0f).method_39415(color);
        }
    }

    private static void renderCrosshairLines(float x, float y, float width, float height, float padding, float indent, float offset, int color) {
        Render2DUtil.drawQuad(x - offset - padding / 2.0f, y - width - indent - padding / 2.0f, height + padding, width + padding, color);
        Render2DUtil.drawQuad(x - offset - padding / 2.0f, y + indent - padding / 2.0f, height + padding, width + padding, color);
        Render2DUtil.drawQuad(x - width - indent - padding / 2.0f, y - offset - padding / 2.0f, width + padding, height + padding, color);
        Render2DUtil.drawQuad(x + indent - padding / 2.0f, y - offset - padding / 2.0f, width + padding, height + padding, color);
    }

    private static void renderRing(CrossHair module, float centerX, float centerY, int mainColor) {
        class_332 context = new class_332(mc, mc.method_22940().method_23000());
        class_4587 matrix = context.method_51448();
        float ringSize = module.getRingSizeSetting().getValue();
        float thickness = module.getRingThicknessSetting().getValue();
        float roundness = module.getRingRoundnessSetting().getValue();
        float attackProgress = CrosshairRenderer.mc.field_1724.method_7261(tickCounter.method_60637(false)) * 360.0f;
        int color1 = CrosshairRenderer.getRingVertexColor(module, 0);
        int color2 = CrosshairRenderer.getRingVertexColor(module, 90);
        int color3 = CrosshairRenderer.getRingVertexColor(module, 180);
        int color4 = CrosshairRenderer.getRingVertexColor(module, 270);
        arc.render(ShapeProperties.create(matrix, centerX - ringSize / 2.0f, centerY - ringSize / 2.0f, ringSize, ringSize).round(roundness).thickness(thickness).end(attackProgress).color(color1, color2, color3, color4).build());
    }

    private static void renderArcTriangles(class_4588 buffer, Matrix4f matrix, float x, float y, float width, float height, float startAngle, float endAngle, float thickness, int color) {
        int segments = 64;
        float centerX = x + width / 2.0f;
        float centerY = y + height / 2.0f;
        float outerRadiusX = width / 2.0f;
        float outerRadiusY = height / 2.0f;
        float actualThickness = thickness;
        if (thickness < 1.0f) {
            actualThickness = outerRadiusX * thickness;
        }
        float innerRadiusX = Math.max(0.1f, outerRadiusX - actualThickness);
        float innerRadiusY = Math.max(0.1f, outerRadiusY - actualThickness);
        if (endAngle <= 0.0f) {
            return;
        }
        int actualSegments = Math.max(4, (int)((float)segments * endAngle / 360.0f));
        float angleStep = endAngle / (float)actualSegments;
        for (int i = 0; i < actualSegments; ++i) {
            float angle1 = (float)Math.toRadians(startAngle + (float)i * angleStep);
            float angle2 = (float)Math.toRadians(startAngle + (float)(i + 1) * angleStep);
            float cos1 = (float)Math.cos(angle1);
            float sin1 = (float)Math.sin(angle1);
            float cos2 = (float)Math.cos(angle2);
            float sin2 = (float)Math.sin(angle2);
            float x1Outer = centerX + cos1 * outerRadiusX;
            float y1Outer = centerY + sin1 * outerRadiusY;
            float x2Outer = centerX + cos2 * outerRadiusX;
            float y2Outer = centerY + sin2 * outerRadiusY;
            float x1Inner = centerX + cos1 * innerRadiusX;
            float y1Inner = centerY + sin1 * innerRadiusY;
            float x2Inner = centerX + cos2 * innerRadiusX;
            float y2Inner = centerY + sin2 * innerRadiusY;
            buffer.method_22918(matrix, x1Inner, y1Inner, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x1Outer, y1Outer, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x2Outer, y2Outer, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x1Inner, y1Inner, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x2Outer, y2Outer, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x2Inner, y2Inner, 0.0f).method_39415(color);
        }
    }

    private static void renderArc(class_4588 buffer, Matrix4f matrix, float x, float y, float width, float height, float startAngle, float endAngle, float thickness, int color) {
        int segments = 64;
        float centerX = x + width / 2.0f;
        float centerY = y + height / 2.0f;
        float outerRadiusX = width / 2.0f;
        float outerRadiusY = height / 2.0f;
        float actualThickness = thickness;
        if (thickness < 1.0f) {
            actualThickness = outerRadiusX * thickness;
        }
        float innerRadiusX = Math.max(0.1f, outerRadiusX - actualThickness);
        float innerRadiusY = Math.max(0.1f, outerRadiusY - actualThickness);
        if (endAngle <= 0.0f) {
            return;
        }
        int actualSegments = Math.max(4, (int)((float)segments * endAngle / 360.0f));
        float angleStep = endAngle / (float)actualSegments;
        for (int i = 0; i < actualSegments; ++i) {
            float angle1 = (float)Math.toRadians(startAngle + (float)i * angleStep);
            float angle2 = (float)Math.toRadians(startAngle + (float)(i + 1) * angleStep);
            float cos1 = (float)Math.cos(angle1);
            float sin1 = (float)Math.sin(angle1);
            float cos2 = (float)Math.cos(angle2);
            float sin2 = (float)Math.sin(angle2);
            float x1Outer = centerX + cos1 * outerRadiusX;
            float y1Outer = centerY + sin1 * outerRadiusY;
            float x2Outer = centerX + cos2 * outerRadiusX;
            float y2Outer = centerY + sin2 * outerRadiusY;
            float x1Inner = centerX + cos1 * innerRadiusX;
            float y1Inner = centerY + sin1 * innerRadiusY;
            float x2Inner = centerX + cos2 * innerRadiusX;
            float y2Inner = centerY + sin2 * innerRadiusY;
            buffer.method_22918(matrix, x1Inner, y1Inner, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x1Outer, y1Outer, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x2Outer, y2Outer, 0.0f).method_39415(color);
            buffer.method_22918(matrix, x2Inner, y2Inner, 0.0f).method_39415(color);
        }
    }

    private static int getRingVertexColor(CrossHair module, int vertexAngle) {
        int baseColor = CrosshairRenderer.getBaseColorAtAngle(module, vertexAngle);
        int targetColor = ColorUtil.multAlpha(module.getTargetColorSetting().getColor(), 1.0f);
        return ColorUtil.overCol(baseColor, targetColor, colorAnimation);
    }

    private static int getBaseColorAtAngle(CrossHair module, int angle) {
        int[] colors;
        if (module.getColorMode().isSelected("Custom") && (colors = module.getCustomColors()) != null && colors.length > 0) {
            String animType = module.getColorAnimation().getSelected();
            if ("Wave".equals(animType)) {
                return CrosshairRenderer.getWaveColorAtAngle(colors, angle);
            }
            return ColorUtil.multAlpha(colors[0], 1.0f);
        }
        return ColorUtil.multAlpha(ColorUtil.getClientColor(), 1.0f);
    }

    private static int getWaveColorAtAngle(int[] colors, int angle) {
        if (colors.length == 1) {
            return ColorUtil.multAlpha(colors[0], 1.0f);
        }
        long time = System.currentTimeMillis() / 10L;
        float totalAngle = ((long)angle + time) % 360L;
        float anglePerColor = 360.0f / (float)colors.length;
        float colorProgress = totalAngle / anglePerColor;
        int index1 = (int)Math.floor(colorProgress) % colors.length;
        int index2 = (index1 + 1) % colors.length;
        float lerp = colorProgress - (float)((int)Math.floor(colorProgress));
        return ColorUtil.multAlpha(ColorUtil.overCol(colors[index1], colors[index2], lerp), 1.0f);
    }

    private static int getCrosshairColor(CrossHair module) {
        int defaultColor = CrosshairRenderer.getBaseColor(module);
        int targetColor = ColorUtil.multAlpha(module.getTargetColorSetting().getColor(), 1.0f);
        return ColorUtil.overCol(defaultColor, targetColor, colorAnimation);
    }

    private static int getBaseColor(CrossHair module) {
        int[] colors;
        if (module.getColorMode().isSelected("Custom") && (colors = module.getCustomColors()) != null && colors.length > 0) {
            String animType = module.getColorAnimation().getSelected();
            if ("Wave".equals(animType)) {
                return CrosshairRenderer.getWaveColor(colors);
            }
            return ColorUtil.multAlpha(colors[0], 1.0f);
        }
        return ColorUtil.multAlpha(ColorUtil.getClientColor(), 1.0f);
    }

    private static int getWaveColor(int[] colors) {
        if (colors.length == 1) {
            return ColorUtil.multAlpha(colors[0], 1.0f);
        }
        if (colors.length == 2) {
            int angle = (int)(System.currentTimeMillis() / 8L % 360L);
            angle = angle >= 180 ? 360 - angle : angle;
            return ColorUtil.multAlpha(ColorUtil.overCol(colors[0], colors[1], (float)angle / 180.0f), 1.0f);
        }
        float timeProgress = (float)(System.currentTimeMillis() / 10L % ((long)colors.length * 360L)) / 360.0f;
        int index1 = (int)Math.floor(timeProgress) % colors.length;
        int index2 = (index1 + 1) % colors.length;
        float lerp = timeProgress - (float)((int)Math.floor(timeProgress));
        return ColorUtil.multAlpha(ColorUtil.overCol(colors[index1], colors[index2], lerp), 1.0f);
    }

    private CrosshairRenderer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

