/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_10014;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;
import net.minecraft.class_9946;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.particle.ParticleColorUtil;
import padej.soup.implement.features.modules.other.EndCrystal;
import padej.soup.mixins.accessor.EndCrystalEntityModelAccessor;

public final class EndCrystalRenderer
implements QuickImports {
    public static void drawCrystals(WorldRenderContext context, EndCrystal module) {
        if (!module.isEnabled() || EndCrystalRenderer.mc.field_1687 == null) {
            return;
        }
        class_4587 matrixStack = context.matrixStack();
        class_4597.class_4598 vertexConsumers = mc.method_22940().method_23000();
        EndCrystalRenderer.renderPhantomCrystals(matrixStack, (class_4597)vertexConsumers, 0xF000F0, null, module);
        vertexConsumers.method_22993();
    }

    public static void renderCrystal(class_10014 state, class_4587 matrixStack, int light, class_9946 model, class_4597 vertexConsumerProvider, EndCrystal module) {
        if (module.getCrystalModel() == null) {
            module.setCrystalModel(model);
        }
        matrixStack.method_22903();
        float baseYOffset = -0.5f + module.getYOffset();
        matrixStack.method_46416(0.0f, baseYOffset, 0.0f);
        matrixStack.method_46416(0.0f, 0.5f, 0.0f);
        float scale = module.getSize();
        matrixStack.method_22905(scale, scale, scale);
        matrixStack.method_46416(0.0f, -0.5f, 0.0f);
        EndCrystalEntityModelAccessor accessor = (EndCrystalEntityModelAccessor)model;
        class_630 outerGlass = accessor.getOuterGlass();
        float originalAge = state.field_53328;
        state.field_53328 *= module.getAnimationSpeed();
        model.method_62083(state);
        state.field_53328 = originalAge;
        class_243 crystalPos = new class_243(state.field_53325, state.field_53326, state.field_53327);
        module.trackCrystal(crystalPos, outerGlass.field_3675, outerGlass.field_3656);
        class_1921 renderLayer = class_1921.method_23592((class_2960)class_2960.method_60656((String)"textures/entity/alt_crystal.png"), (boolean)true);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(renderLayer);
        class_630 base = accessor.getBase();
        class_630 innerGlass = accessor.getInnerGlass();
        class_630 cube = accessor.getCube();
        int baseOffset = (int)((state.field_53325 + state.field_53326 + state.field_53327) * 100.0) % 360;
        if (module.isVertexMode()) {
            int color = EndCrystalRenderer.getColor(baseOffset, module);
            base.method_22699(matrixStack, vertexConsumer, light, class_4608.field_21444, color);
            if (module.isOuterGlassVisible()) {
                color = EndCrystalRenderer.getColor(baseOffset + 90, module);
                matrixStack.method_22903();
                outerGlass.method_22703(matrixStack);
                outerGlass.method_22702(matrixStack.method_23760(), vertexConsumer, light, class_4608.field_21444, color);
                matrixStack.method_22909();
            }
            if (module.isInnerGlassVisible()) {
                color = EndCrystalRenderer.getColor(baseOffset + 180, module);
                matrixStack.method_22903();
                outerGlass.method_22703(matrixStack);
                innerGlass.method_22703(matrixStack);
                innerGlass.method_22702(matrixStack.method_23760(), vertexConsumer, light, class_4608.field_21444, color);
                matrixStack.method_22909();
            }
            if (module.isCubeVisible()) {
                color = EndCrystalRenderer.getColor(baseOffset + 270, module);
                matrixStack.method_22903();
                outerGlass.method_22703(matrixStack);
                innerGlass.method_22703(matrixStack);
                cube.method_22703(matrixStack);
                cube.method_22702(matrixStack.method_23760(), vertexConsumer, light, class_4608.field_21444, color);
                matrixStack.method_22909();
            }
        } else {
            int color = EndCrystalRenderer.getColor(baseOffset, module);
            base.field_3665 = true;
            outerGlass.field_3665 = module.isOuterGlassVisible();
            innerGlass.field_3665 = module.isInnerGlassVisible();
            cube.field_3665 = module.isCubeVisible();
            model.method_62100(matrixStack, vertexConsumer, light, class_4608.field_21444, color);
            outerGlass.field_3665 = true;
            innerGlass.field_3665 = true;
            cube.field_3665 = true;
        }
        matrixStack.method_22909();
    }

    public static void renderPhantomCrystals(class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, class_9946 model, EndCrystal module) {
        class_9946 renderModel;
        List<EndCrystal.PhantomCrystal> phantomCrystals = module.getPhantomCrystals();
        phantomCrystals.removeIf(EndCrystal.PhantomCrystal::isFinished);
        class_9946 class_99462 = renderModel = model != null ? model : module.getCrystalModel();
        if (renderModel == null) {
            return;
        }
        for (EndCrystal.PhantomCrystal phantom : phantomCrystals) {
            EndCrystalRenderer.renderPhantomCrystal(phantom, matrixStack, vertexConsumerProvider, light, renderModel, module);
        }
    }

    private static void renderPhantomCrystal(EndCrystal.PhantomCrystal phantom, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, class_9946 model, EndCrystal module) {
        if (phantom.isFinished()) {
            return;
        }
        matrixStack.method_22903();
        class_243 cameraPos = EndCrystalRenderer.mc.field_1773.method_19418().method_19326();
        matrixStack.method_22904(phantom.pos.field_1352 - cameraPos.field_1352, phantom.pos.field_1351 - cameraPos.field_1351, phantom.pos.field_1350 - cameraPos.field_1350);
        double animationProgress = phantom.animation.getOutput();
        float alphaFade = 1.0f - (float)animationProgress;
        float scaleMultiplier = module.getBreakScaleMultiplier();
        float baseScale = module.getSize();
        float totalScale = baseScale * (1.0f + scaleMultiplier * (float)animationProgress);
        float baseYOffset = -0.5f + module.getYOffset();
        matrixStack.method_46416(0.0f, baseYOffset, 0.0f);
        matrixStack.method_46416(0.0f, 0.5f, 0.0f);
        matrixStack.method_22905(totalScale, totalScale, totalScale);
        matrixStack.method_46416(0.0f, -0.5f, 0.0f);
        EndCrystalEntityModelAccessor accessor = (EndCrystalEntityModelAccessor)model;
        class_630 outerGlass = accessor.getOuterGlass();
        outerGlass.field_3656 = phantom.outerGlassPivotY;
        outerGlass.field_3675 = phantom.outerGlassYaw;
        class_1921 renderLayer = class_1921.method_23592((class_2960)class_2960.method_60656((String)"textures/entity/alt_crystal.png"), (boolean)true);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(renderLayer);
        class_630 base = accessor.getBase();
        class_630 innerGlass = accessor.getInnerGlass();
        class_630 cube = accessor.getCube();
        int baseOffset = (int)((phantom.pos.field_1352 + phantom.pos.field_1351 + phantom.pos.field_1350) * 100.0) % 360;
        if (module.isVertexMode()) {
            int color = EndCrystalRenderer.applyAlphaFade(EndCrystalRenderer.getColor(baseOffset, module), alphaFade);
            base.method_22699(matrixStack, vertexConsumer, light, class_4608.field_21444, color);
            if (module.isOuterGlassVisible()) {
                color = EndCrystalRenderer.applyAlphaFade(EndCrystalRenderer.getColor(baseOffset + 90, module), alphaFade);
                matrixStack.method_22903();
                outerGlass.method_22703(matrixStack);
                outerGlass.method_22702(matrixStack.method_23760(), vertexConsumer, light, class_4608.field_21444, color);
                matrixStack.method_22909();
            }
            if (module.isInnerGlassVisible()) {
                color = EndCrystalRenderer.applyAlphaFade(EndCrystalRenderer.getColor(baseOffset + 180, module), alphaFade);
                matrixStack.method_22903();
                outerGlass.method_22703(matrixStack);
                innerGlass.method_22703(matrixStack);
                innerGlass.method_22702(matrixStack.method_23760(), vertexConsumer, light, class_4608.field_21444, color);
                matrixStack.method_22909();
            }
            if (module.isCubeVisible()) {
                color = EndCrystalRenderer.applyAlphaFade(EndCrystalRenderer.getColor(baseOffset + 270, module), alphaFade);
                matrixStack.method_22903();
                outerGlass.method_22703(matrixStack);
                innerGlass.method_22703(matrixStack);
                cube.method_22703(matrixStack);
                cube.method_22702(matrixStack.method_23760(), vertexConsumer, light, class_4608.field_21444, color);
                matrixStack.method_22909();
            }
        } else {
            int color = EndCrystalRenderer.applyAlphaFade(EndCrystalRenderer.getColor(baseOffset, module), alphaFade);
            base.field_3665 = true;
            outerGlass.field_3665 = module.isOuterGlassVisible();
            innerGlass.field_3665 = module.isInnerGlassVisible();
            cube.field_3665 = module.isCubeVisible();
            model.method_62100(matrixStack, vertexConsumer, light, class_4608.field_21444, color);
            outerGlass.field_3665 = true;
            innerGlass.field_3665 = true;
            cube.field_3665 = true;
        }
        matrixStack.method_22909();
    }

    private static int getColor(int angleOffset, EndCrystal module) {
        if (module.isSyncMode()) {
            return ColorUtil.getClientColor();
        }
        int[] colors = module.getCustomColors();
        if (colors == null || colors.length == 0) {
            return -1;
        }
        if (module.isWaveMode()) {
            return ParticleColorUtil.getWaveColor(colors, 1.0f);
        }
        if (module.isVertexMode()) {
            return ParticleColorUtil.getVertexGradientColor(angleOffset, colors, 1.0f);
        }
        return colors[0];
    }

    private static int applyAlphaFade(int color, float fade) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int newAlpha = (int)((float)alpha * Math.max(0.0f, Math.min(1.0f, fade)));
        return newAlpha << 24 | red << 16 | green << 8 | blue;
    }

    private EndCrystalRenderer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

