/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.implement.features.modules.hud.ItemOverlay;

public final class ItemOverlayRenderer
implements QuickImports {
    public static boolean renderItemBar(class_332 context, class_1799 stack, int x, int y) {
        ItemOverlay itemOverlay = ItemOverlay.getInstance();
        if (!itemOverlay.isEnabled() || !itemOverlay.getCustomDurabilityBar().isValue()) {
            return false;
        }
        if (!stack.method_31578()) {
            return false;
        }
        int barX = x + 2;
        int barY = y + 13;
        int barWidth = stack.method_31579();
        boolean drawShadow = itemOverlay.getDurabilityBarShadow().isValue();
        int barColor = ItemOverlayRenderer.getBarColor(itemOverlay);
        if (drawShadow) {
            context.method_48196(class_1921.method_51784(), barX, barY, barX + 13, barY + 2, 200, -16777216);
        }
        context.method_48196(class_1921.method_51784(), barX, barY, barX + barWidth, barY + 1, 200, barColor);
        return true;
    }

    private static int getBarColor(ItemOverlay itemOverlay) {
        int[] colors = itemOverlay.getCustomBarColors();
        if (colors == null) {
            return ColorUtil.multAlpha(ColorUtil.getClientColor(), 1.0f);
        }
        String animation = itemOverlay.getBarColorAnimation().getSelected();
        if ("Wave".equals(animation)) {
            return ItemOverlayRenderer.getWaveColor(colors);
        }
        return ColorUtil.multAlpha(colors[0], 1.0f);
    }

    private static int getWaveColor(int[] colors) {
        if (colors.length == 1) {
            return ColorUtil.multAlpha(colors[0], 1.0f);
        }
        if (colors.length == 2) {
            int angle = (int)(System.currentTimeMillis() / 8L % 360L);
            angle = angle >= 180 ? 360 - angle : angle;
            return ColorUtil.multAlpha(ColorUtil.overCol(colors[0], colors[1], (float)angle / 180.0f), 1.0f);
        }
        float timeProgress = (float)(System.currentTimeMillis() / 10L % ((long)colors.length * 360L)) / 360.0f;
        int index1 = (int)Math.floor(timeProgress) % colors.length;
        int index2 = (index1 + 1) % colors.length;
        float lerp = timeProgress - (float)((int)Math.floor(timeProgress));
        return ColorUtil.multAlpha(ColorUtil.overCol(colors[index1], colors[index2], lerp), 1.0f);
    }

    public static boolean renderStackCount(class_332 context, class_327 textRenderer, class_1799 stack, int x, int y, @Nullable String stackCountText) {
        int color;
        Object string;
        ItemOverlay itemOverlay = ItemOverlay.getInstance();
        if (!itemOverlay.isEnabled() || !itemOverlay.getCustomStackCount().isValue()) {
            return false;
        }
        if (stack.method_7947() == 1 && stackCountText == null) {
            return false;
        }
        Object object = string = stackCountText == null ? String.valueOf(stack.method_7947()) : stackCountText;
        if (itemOverlay.getAddPrefix().isValue() && stackCountText == null) {
            string = "x" + (String)string;
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 200.0f);
        int n = color = itemOverlay.getEnableCustomColor().isValue() ? itemOverlay.getStackCountColor().getColor() : ColorUtil.getText();
        if (itemOverlay.getUseCustomFont().isValue()) {
            FontRenderer font = Fonts.getSize(18, Fonts.Type.SF_BOLD);
            int textX = x + 19 - 2 - (int)font.getStringWidth((String)string);
            int textY = y + 6 + 4;
            font.drawString(matrices, (String)string, textX, textY, color);
        } else {
            int textX = x + 19 - 2 - textRenderer.method_1727((String)string);
            int textY = y + 6 + 3;
            context.method_51433(textRenderer, (String)string, textX, textY, color, true);
        }
        matrices.method_22909();
        return true;
    }

    public static boolean renderCooldownProgress(class_332 context, int x, int y, float cooldownProgress) {
        ItemOverlay itemOverlay = ItemOverlay.getInstance();
        if (!itemOverlay.isEnabled() || !itemOverlay.getCustomCooldown().isValue()) {
            return false;
        }
        if (cooldownProgress <= 0.0f) {
            return false;
        }
        String cooldownStyle = itemOverlay.getCooldownStyle().getSelected();
        if ("Ring".equals(cooldownStyle)) {
            ItemOverlayRenderer.renderCooldownRing(context, x, y, cooldownProgress, itemOverlay);
        } else {
            ItemOverlayRenderer.renderCooldownBar(context, x, y, cooldownProgress, itemOverlay);
        }
        if (itemOverlay.getShowCooldownNumber().isValue()) {
            ItemOverlayRenderer.renderCooldownNumber(context, x, y, cooldownProgress);
        }
        return true;
    }

    private static void renderCooldownRing(class_332 context, int x, int y, float cooldownProgress, ItemOverlay itemOverlay) {
        if (cooldownProgress < 0.01f) {
            return;
        }
        int color = ItemOverlayRenderer.getCooldownColor(itemOverlay);
        arc.render(ShapeProperties.create(context.method_51448(), x - 2, y - 2, 20.0, 20.0).round(0.27f).thickness(0.25f).end(cooldownProgress * 360.0f).color(color).build());
    }

    private static void renderCooldownBar(class_332 context, int x, int y, float cooldownProgress, ItemOverlay itemOverlay) {
        if (cooldownProgress < 0.01f) {
            return;
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)x, (float)y, 0.0f);
        matrices.method_46416(0.0f, 16.0f * (1.0f - cooldownProgress), 0.0f);
        matrices.method_22905(1.0f, cooldownProgress, 1.0f);
        int color = ItemOverlayRenderer.getCooldownColor(itemOverlay);
        context.method_48196(class_1921.method_51784(), 0, 0, 16, 16, 200, color);
        matrices.method_22909();
    }

    private static void renderCooldownNumber(class_332 context, int x, int y, float remainingSeconds) {
        String text = String.format("%.1f", Float.valueOf(remainingSeconds));
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 250.0f);
        FontRenderer font = Fonts.getSize(14, Fonts.Type.SF_BOLD);
        float textWidth = font.getStringWidth(text);
        float textX = (float)x + 8.0f - textWidth / 2.0f;
        float textY = (float)y + 8.0f;
        font.drawString(matrices, text, textX, textY, ColorUtil.getText());
        matrices.method_22909();
    }

    private static int getCooldownColor(ItemOverlay itemOverlay) {
        int baseColor = itemOverlay.getCooldownColorMode().isSelected("Custom") ? itemOverlay.getCooldownColor().getColor() : ColorUtil.getClientColor();
        float alpha = itemOverlay.getCooldownAlpha().getValue();
        return ColorUtil.replAlpha(baseColor, alpha);
    }

    private ItemOverlayRenderer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

