/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4i;
import org.lwjgl.opengl.GL11;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.ProjectionUtil;
import padej.soup.implement.features.modules.particles.render.ParticleBatchRenderer;

public final class Render3DUtil
implements QuickImports {
    private static final Map<class_265, class_3545<List<class_238>, List<Line>>> SHAPE_OUTLINES = new HashMap<class_265, class_3545<List<class_238>, List<Line>>>();
    public static final List<Texture> TEXTURE_DEPTH = new ArrayList<Texture>();
    public static final List<Texture> TEXTURE = new ArrayList<Texture>();
    public static final List<Line> LINE_DEPTH = new ArrayList<Line>();
    public static final List<Line> LINE = new ArrayList<Line>();
    public static final List<Quad> QUAD_DEPTH = new ArrayList<Quad>();
    public static final List<Quad> QUAD = new ArrayList<Quad>();
    public static final List<GhostTexture> GHOST_TEXTURE_DEPTH = new ArrayList<GhostTexture>();
    public static final List<GhostTexture> GHOST_TEXTURE = new ArrayList<GhostTexture>();
    public static Matrix4f lastProjMat = new Matrix4f();
    public static class_4587.class_4665 lastWorldSpaceMatrix = new class_4587().method_23760();

    public static void onWorldRender() {
        class_287 buffer;
        Set widths;
        Set identifiers;
        ParticleBatchRenderer.renderBatches();
        if (!TEXTURE.isEmpty()) {
            identifiers = TEXTURE.stream().map(texture -> texture.id).collect(Collectors.toCollection(LinkedHashSet::new));
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_CONSTANT_ALPHA);
            identifiers.forEach(id -> {
                RenderSystem.setShaderTexture((int)0, (class_2960)id);
                RenderSystem.setShader((class_10156)class_10142.field_53880);
                class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
                TEXTURE.stream().filter(texture -> texture.id.equals(id)).forEach(tex -> Render3DUtil.quadTexture(tex.entry, buffer, tex.x, tex.y, tex.width, tex.height, tex.color));
                class_286.method_43433((class_9801)buffer.method_60800());
            });
            RenderSystem.disableBlend();
            TEXTURE.clear();
        }
        if (!TEXTURE_DEPTH.isEmpty()) {
            identifiers = TEXTURE_DEPTH.stream().map(texture -> texture.id).collect(Collectors.toCollection(LinkedHashSet::new));
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_CONSTANT_ALPHA);
            identifiers.forEach(id -> {
                RenderSystem.setShaderTexture((int)0, (class_2960)id);
                RenderSystem.setShader((class_10156)class_10142.field_53880);
                class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
                TEXTURE_DEPTH.stream().filter(texture -> texture.id.equals(id)).forEach(tex -> Render3DUtil.quadTexture(tex.entry, buffer, tex.x, tex.y, tex.width, tex.height, tex.color));
                class_286.method_43433((class_9801)buffer.method_60800());
            });
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
            TEXTURE_DEPTH.clear();
        }
        if (!LINE.isEmpty()) {
            GL11.glEnable((int)2881);
            widths = LINE.stream().map(line -> Float.valueOf(line.width)).collect(Collectors.toCollection(LinkedHashSet::new));
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShader((class_10156)class_10142.field_53864);
            widths.forEach(width -> {
                RenderSystem.lineWidth((float)width.floatValue());
                class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
                LINE.stream().filter(line -> line.width == width.floatValue()).forEach(line -> Render3DUtil.vertexLine(line.entry, (class_4588)buffer, line.start.method_46409(), line.end.method_46409(), line.colorStart, line.colorEnd));
                class_286.method_43433((class_9801)buffer.method_60800());
            });
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            LINE.clear();
            GL11.glDisable((int)2881);
        }
        if (!QUAD.isEmpty()) {
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            QUAD.forEach(quad -> Render3DUtil.vertexQuad(quad.entry, (class_4588)buffer, quad.x, quad.y, quad.w, quad.z, quad.color));
            class_286.method_43433((class_9801)buffer.method_60800());
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            QUAD.clear();
        }
        if (!LINE_DEPTH.isEmpty()) {
            GL11.glEnable((int)2881);
            widths = LINE_DEPTH.stream().map(line -> Float.valueOf(line.width)).collect(Collectors.toCollection(LinkedHashSet::new));
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShader((class_10156)class_10142.field_53864);
            widths.forEach(width -> {
                RenderSystem.lineWidth((float)width.floatValue());
                class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
                LINE_DEPTH.stream().filter(line -> line.width == width.floatValue()).forEach(line -> Render3DUtil.vertexLine(line.entry, (class_4588)buffer, line.start.method_46409(), line.end.method_46409(), line.colorStart, line.colorEnd));
                class_286.method_43433((class_9801)buffer.method_60800());
            });
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            LINE_DEPTH.clear();
            GL11.glDisable((int)2881);
        }
        if (!QUAD_DEPTH.isEmpty()) {
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            QUAD_DEPTH.forEach(quad -> Render3DUtil.vertexQuad(quad.entry, (class_4588)buffer, quad.x, quad.y, quad.w, quad.z, quad.color));
            class_286.method_43433((class_9801)buffer.method_60800());
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            QUAD_DEPTH.clear();
        }
        if (!GHOST_TEXTURE.isEmpty()) {
            identifiers = GHOST_TEXTURE.stream().map(texture -> texture.id).collect(Collectors.toCollection(LinkedHashSet::new));
            RenderSystem.enableBlend();
            identifiers.forEach(id -> {
                RenderSystem.setShaderTexture((int)0, (class_2960)id);
                RenderSystem.setShader((class_10156)class_10142.field_53880);
                Map<Runnable, List<GhostTexture>> blendGroups = GHOST_TEXTURE.stream().filter(texture -> texture.id.equals(id)).collect(Collectors.groupingBy(tex -> tex.setupBlendFunc));
                blendGroups.forEach((blendFunc, textures) -> {
                    blendFunc.run();
                    class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
                    textures.forEach(tex -> Render3DUtil.quadTexture(tex.entry, buffer, tex.x, tex.y, tex.width, tex.height, tex.color));
                    class_286.method_43433((class_9801)buffer.method_60800());
                });
            });
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            GHOST_TEXTURE.clear();
        }
        if (!GHOST_TEXTURE_DEPTH.isEmpty()) {
            identifiers = GHOST_TEXTURE_DEPTH.stream().map(texture -> texture.id).collect(Collectors.toCollection(LinkedHashSet::new));
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            identifiers.forEach(id -> {
                RenderSystem.setShaderTexture((int)0, (class_2960)id);
                RenderSystem.setShader((class_10156)class_10142.field_53880);
                Map<Runnable, List<GhostTexture>> blendGroups = GHOST_TEXTURE_DEPTH.stream().filter(texture -> texture.id.equals(id)).collect(Collectors.groupingBy(tex -> tex.setupBlendFunc));
                blendGroups.forEach((blendFunc, textures) -> {
                    blendFunc.run();
                    class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
                    textures.forEach(tex -> Render3DUtil.quadTexture(tex.entry, buffer, tex.x, tex.y, tex.width, tex.height, tex.color));
                    class_286.method_43433((class_9801)buffer.method_60800());
                });
            });
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
            GHOST_TEXTURE_DEPTH.clear();
        }
    }

    public static void drawShapeAlternative(class_2338 blockPos, class_265 voxelShape, int color, float width, boolean fill, boolean depth) {
        class_243 vec3d = class_243.method_24954((class_2382)blockPos);
        if (ProjectionUtil.canSee(new class_238(blockPos))) {
            if (SHAPE_OUTLINES.containsKey(voxelShape)) {
                class_3545<List<class_238>, List<Line>> pair = SHAPE_OUTLINES.get(voxelShape);
                if (fill) {
                    ((List)pair.method_15442()).forEach(box -> Render3DUtil.drawBox(box.method_997(vec3d), color, width, false, true, depth));
                }
                ((List)pair.method_15441()).forEach(line -> Render3DUtil.drawLine(line.start.method_1019(vec3d), line.end.method_1019(vec3d), color, width, depth));
                return;
            }
            ArrayList lines = new ArrayList();
            voxelShape.method_1104((minX, minY, minZ, maxX, maxY, maxZ) -> lines.add(new Line(null, new class_243(minX, minY, minZ), new class_243(maxX, maxY, maxZ), 0, 0, 0.0f)));
            SHAPE_OUTLINES.put(voxelShape, (class_3545<List<class_238>, List<Line>>)new class_3545((Object)voxelShape.method_1090(), lines));
        }
    }

    public static void drawBox(class_238 box, int color, float width, boolean line, boolean fill, boolean depth) {
        Render3DUtil.drawBox(null, box, color, width, line, fill, depth);
    }

    public static void drawBox(class_4587.class_4665 entry, class_238 box, int color, float width, boolean line, boolean fill, boolean depth) {
        box = box.method_1014(0.001);
        double x1 = box.field_1323;
        double y1 = box.field_1322;
        double z1 = box.field_1321;
        double x2 = box.field_1320;
        double y2 = box.field_1325;
        double z2 = box.field_1324;
        if (fill) {
            int fillColor = ColorUtil.multAlpha(color, 0.1f);
            Render3DUtil.drawQuad(entry, new class_243(x1, y1, z1), new class_243(x2, y1, z1), new class_243(x2, y1, z2), new class_243(x1, y1, z2), fillColor, depth);
            Render3DUtil.drawQuad(entry, new class_243(x1, y1, z1), new class_243(x1, y2, z1), new class_243(x2, y2, z1), new class_243(x2, y1, z1), fillColor, depth);
            Render3DUtil.drawQuad(entry, new class_243(x2, y1, z1), new class_243(x2, y2, z1), new class_243(x2, y2, z2), new class_243(x2, y1, z2), fillColor, depth);
            Render3DUtil.drawQuad(entry, new class_243(x1, y1, z2), new class_243(x2, y1, z2), new class_243(x2, y2, z2), new class_243(x1, y2, z2), fillColor, depth);
            Render3DUtil.drawQuad(entry, new class_243(x1, y1, z1), new class_243(x1, y1, z2), new class_243(x1, y2, z2), new class_243(x1, y2, z1), fillColor, depth);
            Render3DUtil.drawQuad(entry, new class_243(x1, y2, z1), new class_243(x1, y2, z2), new class_243(x2, y2, z2), new class_243(x2, y2, z1), fillColor, depth);
        }
        if (line) {
            Render3DUtil.drawLine(entry, x1, y1, z1, x2, y1, z1, color, width, depth);
            Render3DUtil.drawLine(entry, x2, y1, z1, x2, y1, z2, color, width, depth);
            Render3DUtil.drawLine(entry, x2, y1, z2, x1, y1, z2, color, width, depth);
            Render3DUtil.drawLine(entry, x1, y1, z2, x1, y1, z1, color, width, depth);
            Render3DUtil.drawLine(entry, x1, y1, z2, x1, y2, z2, color, width, depth);
            Render3DUtil.drawLine(entry, x1, y1, z1, x1, y2, z1, color, width, depth);
            Render3DUtil.drawLine(entry, x2, y1, z2, x2, y2, z2, color, width, depth);
            Render3DUtil.drawLine(entry, x2, y1, z1, x2, y2, z1, color, width, depth);
            Render3DUtil.drawLine(entry, x1, y2, z1, x2, y2, z1, color, width, depth);
            Render3DUtil.drawLine(entry, x2, y2, z1, x2, y2, z2, color, width, depth);
            Render3DUtil.drawLine(entry, x2, y2, z2, x1, y2, z2, color, width, depth);
            Render3DUtil.drawLine(entry, x1, y2, z2, x1, y2, z1, color, width, depth);
        }
    }

    public static void vertexLine(class_4587 matrices, class_4588 buffer, class_243 start, class_243 end, int startColor, int endColor) {
        Render3DUtil.vertexLine(matrices.method_23760(), buffer, start.method_46409(), end.method_46409(), startColor, endColor);
    }

    public static void vertexLine(class_4587.class_4665 entry, class_4588 buffer, Vector3f start, Vector3f end, int startColor, int endColor) {
        if (entry == null) {
            entry = lastWorldSpaceMatrix;
        }
        Vector3f vec = Render3DUtil.getNormal(start, end);
        buffer.method_61032(entry, start).method_39415(startColor).method_61959(entry, vec);
        buffer.method_61032(entry, end).method_39415(endColor).method_61959(entry, vec);
    }

    public static void vertexQuad(class_4587.class_4665 entry, class_4588 buffer, class_243 vec1, class_243 vec2, class_243 vec3, class_243 vec4, int color) {
        Render3DUtil.vertexQuad(entry, buffer, vec1.method_46409(), vec2.method_46409(), vec3.method_46409(), vec4.method_46409(), color);
    }

    public static void vertexQuad(class_4587.class_4665 entry, class_4588 buffer, Vector3f vec1, Vector3f vec2, Vector3f vec3, Vector3f vec4, int color) {
        if (entry == null) {
            entry = lastWorldSpaceMatrix;
        }
        buffer.method_61032(entry, vec1).method_39415(color);
        buffer.method_61032(entry, vec2).method_39415(color);
        buffer.method_61032(entry, vec3).method_39415(color);
        buffer.method_61032(entry, vec4).method_39415(color);
    }

    public static void quadTexture(class_4587.class_4665 entry, class_287 buffer, float x, float y, float width, float height, Vector4i color) {
        buffer.method_56824(entry, x, y + height, 0.0f).method_22913(0.0f, 0.0f).method_39415(color.x);
        buffer.method_56824(entry, x + width, y + height, 0.0f).method_22913(0.0f, 1.0f).method_39415(color.y);
        buffer.method_56824(entry, x + width, y, 0.0f).method_22913(1.0f, 1.0f).method_39415(color.w);
        buffer.method_56824(entry, x, y, 0.0f).method_22913(1.0f, 0.0f).method_39415(color.z);
    }

    @NotNull
    public static Vector3f getNormal(Vector3f start, Vector3f end) {
        Vector3f normal = new Vector3f((Vector3fc)start).sub((Vector3fc)end);
        float sqrt = class_3532.method_15355((float)normal.lengthSquared());
        return normal.div(sqrt);
    }

    public static void drawLine(class_4587.class_4665 entry, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int color, float width, boolean depth) {
        Render3DUtil.drawLine(entry, new class_243(minX, minY, minZ), new class_243(maxX, maxY, maxZ), color, color, width, depth);
    }

    public static void drawLine(class_243 start, class_243 end, int color, float width, boolean depth) {
        Render3DUtil.drawLine(null, start, end, color, color, width, depth);
    }

    public static void drawLine(class_4587.class_4665 entry, class_243 start, class_243 end, int colorStart, int colorEnd, float width, boolean depth) {
        Line line = new Line(entry, start, end, colorStart, colorEnd, width);
        if (depth) {
            LINE_DEPTH.add(line);
        } else {
            LINE.add(line);
        }
    }

    public static void drawQuad(class_4587.class_4665 entry, class_243 x, class_243 y, class_243 w, class_243 z, int color, boolean depth) {
        Quad quad = new Quad(entry, x, y, w, z, color);
        if (depth) {
            QUAD_DEPTH.add(quad);
        } else {
            QUAD.add(quad);
        }
    }

    public static void drawTexture(class_4587.class_4665 entry, class_2960 id, float x, float y, float width, float height, Vector4i color, boolean depth) {
        Texture texture = new Texture(entry, id, x, y, width, height, color);
        if (depth) {
            TEXTURE_DEPTH.add(texture);
        } else {
            TEXTURE.add(texture);
        }
    }

    public static void drawGhostTexture(class_4587.class_4665 entry, class_2960 id, float x, float y, float width, float height, Vector4i color, boolean depth, Runnable setupBlendFunc) {
        GhostTexture texture = new GhostTexture(entry, id, x, y, width, height, color, setupBlendFunc);
        if (depth) {
            GHOST_TEXTURE_DEPTH.add(texture);
        } else {
            GHOST_TEXTURE.add(texture);
        }
    }

    private Render3DUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void setLastProjMat(Matrix4f lastProjMat) {
        Render3DUtil.lastProjMat = lastProjMat;
    }

    public static void setLastWorldSpaceMatrix(class_4587.class_4665 lastWorldSpaceMatrix) {
        Render3DUtil.lastWorldSpaceMatrix = lastWorldSpaceMatrix;
    }

    public record Line(class_4587.class_4665 entry, class_243 start, class_243 end, int colorStart, int colorEnd, float width) {
    }

    public record Quad(class_4587.class_4665 entry, class_243 x, class_243 y, class_243 w, class_243 z, int color) {
    }

    public record Texture(class_4587.class_4665 entry, class_2960 id, float x, float y, float width, float height, Vector4i color) {
    }

    public record GhostTexture(class_4587.class_4665 entry, class_2960 id, float x, float y, float width, float height, Vector4i color, Runnable setupBlendFunc) {
    }
}

