/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector4i;
import org.lwjgl.opengl.GL11;
import padej.soup.api.feature.module.ITargetRenderModule;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.render.Render3DUtil;
import padej.soup.implement.features.modules.particles.render.ParticleBatchRenderer;

public final class TargetRenderer
implements QuickImports {
    private static float espValue = 1.0f;
    private static float espSpeed = 1.0f;
    private static float prevEspValue;
    private static float circleStep;
    private static float prevCircleStep;
    private static boolean flipSpeed;
    private static long lastUpdateTick;
    public static Color topLeft;
    public static Color topRight;
    public static Color bottomRight;
    public static Color bottomLeft;

    private static int getGradientColor(int index, float red, ITargetRenderModule module) {
        int[] customColors = module.getCustomColors();
        if (customColors != null && customColors.length > 0) {
            int colorIndex = index % customColors.length;
            return ColorUtil.gradientToRed(customColors[colorIndex], red);
        }
        return ColorUtil.gradientToRed(ColorUtil.fade(index * 4), red);
    }

    private static int interpolateColor(int color1, int color2, float factor) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * factor);
        int r = (int)((float)r1 + (float)(r2 - r1) * factor);
        int g = (int)((float)g1 + (float)(g2 - g1) * factor);
        int b = (int)((float)b1 + (float)(b2 - b1) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int getGhostGradientColor(float ghostPosition, float red, ITargetRenderModule module) {
        int[] customColors = module.getCustomColors();
        if (customColors != null && customColors.length > 0) {
            if (customColors.length == 1) {
                return ColorUtil.gradientToRed(customColors[0], red);
            }
            float normalizedPosition = Math.max(0.0f, Math.min(1.0f, ghostPosition));
            float totalSegments = customColors.length - 1;
            float scaledPosition = normalizedPosition * totalSegments;
            int segmentIndex = Math.min((int)Math.floor(scaledPosition), customColors.length - 2);
            float localPosition = scaledPosition - (float)segmentIndex;
            int color1 = customColors[segmentIndex];
            int color2 = customColors[segmentIndex + 1];
            int interpolated = TargetRenderer.interpolateColor(color1, color2, localPosition);
            return ColorUtil.gradientToRed(interpolated, red);
        }
        float colorIndex = ghostPosition * 180.0f;
        return ColorUtil.gradientToRed(ColorUtil.fade((int)colorIndex), red);
    }

    private static int getCircleGradientColor(int segmentIndex, int totalSegments, float red, ITargetRenderModule module) {
        int[] customColors = module.getCustomColors();
        if (customColors != null && customColors.length > 0) {
            float degreesPerColor = 360.0f / (float)customColors.length;
            float currentDegree = (float)segmentIndex * 360.0f / (float)totalSegments;
            int colorIndex1 = (int)(currentDegree / degreesPerColor) % customColors.length;
            int colorIndex2 = (colorIndex1 + 1) % customColors.length;
            float factor = currentDegree % degreesPerColor / degreesPerColor;
            int color1 = customColors[colorIndex1];
            int color2 = customColors[colorIndex2];
            int interpolated = TargetRenderer.interpolateColor(color1, color2, factor);
            return ColorUtil.gradientToRed(interpolated, red);
        }
        return ColorUtil.gradientToRed(ColorUtil.fade(segmentIndex * 4), red);
    }

    public static void drawLegacy(class_1309 target, float animation, float red, ITargetRenderModule module) {
        class_243 targetPos;
        float size = (2.2f - animation) * module.getLegacySize();
        class_4184 camera = TargetRenderer.mc.method_1561().field_4686;
        if (module.isOptimalAim()) {
            class_243 closestPoint = MathUtil.closestPointToBox(target.method_5829());
            targetPos = closestPoint.method_1020(camera.method_19326());
        } else {
            targetPos = MathUtil.interpolate((class_1297)target).method_1020(camera.method_19326());
        }
        class_4587 matrix = new class_4587();
        matrix.method_22903();
        matrix.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrix.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        if (module.isOptimalAim()) {
            matrix.method_22904(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);
        } else {
            matrix.method_22904(targetPos.field_1352, targetPos.field_1351 + target.method_5829().method_17940() / 2.0, targetPos.field_1350);
        }
        matrix.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
        matrix.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        if (!module.isStaticMode()) {
            matrix.method_22907(class_7833.field_40718.rotationDegrees(MathUtil.interpolate(prevEspValue, espValue)));
        } else {
            matrix.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
        }
        class_4587.class_4665 entry = matrix.method_23760().method_56822();
        Render3DUtil.drawTexture(entry, module.getLegacyTexture(), -size / 2.0f, -size / 2.0f, size, size, new Vector4i(ColorUtil.multAlpha(TargetRenderer.getGradientColor(22, red, module), animation), ColorUtil.multAlpha(TargetRenderer.getGradientColor(0, red, module), animation), ColorUtil.multAlpha(TargetRenderer.getGradientColor(45, red, module), animation), ColorUtil.multAlpha(TargetRenderer.getGradientColor(67, red, module), animation)), !Objects.requireNonNull(TargetRenderer.mc.field_1724).method_6057((class_1297)target));
        matrix.method_22909();
    }

    public static void drawCircle(class_4587 matrix, class_1309 target, float animation, float red, ITargetRenderModule module) {
        double cs = MathUtil.interpolate(prevCircleStep, circleStep);
        class_243 targetPos = MathUtil.interpolate((class_1297)target);
        GL11.glEnable((int)2881);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_CONSTANT_ALPHA);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        int size = 90;
        for (int i = 0; i <= size; ++i) {
            float width = target.method_17681() * 0.9f;
            float height = target.method_17682();
            double yAnim = MathUtil.absSinAnimation(cs) * (double)height;
            double yAnim2 = MathUtil.absSinAnimation(cs - 0.45) * (double)height;
            class_243 cosSin = MathUtil.cosSin(i, size, width);
            class_243 nextCosSin = MathUtil.cosSin(i + 1, size, width);
            int color = TargetRenderer.getCircleGradientColor(i, size, red, module);
            Render3DUtil.vertexLine(matrix, (class_4588)buffer, targetPos.method_1031(cosSin.field_1352, cosSin.field_1351 + yAnim, cosSin.field_1350), targetPos.method_1031(cosSin.field_1352, cosSin.field_1351 + yAnim2, cosSin.field_1350), ColorUtil.multAlpha(color, 0.6f * animation), ColorUtil.multAlpha(color, 0.0f));
            Render3DUtil.drawLine(targetPos.method_1031(cosSin.field_1352, cosSin.field_1351 + yAnim, cosSin.field_1350), targetPos.method_1031(nextCosSin.field_1352, nextCosSin.field_1351 + yAnim, nextCosSin.field_1350), ColorUtil.multAlpha(color, animation), 3.0f, true);
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableDepthTest();
        GL11.glDisable((int)2881);
    }

    public static void drawGhosts(class_1309 target, float animation, float red, float speed, float length, float radiusModifier, float endSize, float startSize, float subdivisions, ITargetRenderModule module) {
        class_4184 camera = TargetRenderer.mc.method_1561().field_4686;
        class_243 vec = MathUtil.interpolate((class_1297)target).method_1020(camera.method_19326());
        double interpolate = MathUtil.interpolate(TargetRenderer.mc.field_1724.field_6012 - 1, TargetRenderer.mc.field_1724.field_6012);
        float halfHeight = target.method_17682() / 2.0f + 0.1f;
        float width = target.method_17681();
        boolean isSpiral = module.getGhostsTrajectory().isSelected("Spiral");
        boolean isDefault = module.getGhostsTrajectory().isSelected("Standard");
        int ghostsCount = (int)module.getGhostsCount().getValue();
        int baseGhostLength = Math.round(10.0f * length);
        int subdivisionsInt = Math.round(subdivisions);
        double phaseShiftStep = Math.toRadians(360.0 / (double)ghostsCount);
        for (int j = 0; j < ghostsCount; ++j) {
            double phaseShift = phaseShiftStep * (double)j;
            double cosX = 0.0;
            double sinX = 0.0;
            double cosY = 0.0;
            double sinY = 0.0;
            double cosZ = 0.0;
            double sinZ = 0.0;
            if (!isSpiral && !isDefault) {
                double angleX = phaseShiftStep * (double)j + interpolate * 0.02;
                double angleY = phaseShiftStep * (double)j * 1.618 + interpolate * 0.024;
                double angleZ = phaseShiftStep * (double)j * 2.618 + interpolate * 0.016;
                cosX = Math.cos(angleX);
                sinX = Math.sin(angleX);
                cosY = Math.cos(angleY);
                sinY = Math.sin(angleY);
                cosZ = Math.cos(angleZ);
                sinZ = Math.sin(angleZ);
            }
            for (int i = 0; i < baseGhostLength; ++i) {
                for (int sub = 0; sub < subdivisionsInt; ++sub) {
                    double sinQuad;
                    double radians;
                    float t = (float)sub / (float)subdivisionsInt;
                    float currentStep = (float)i + t;
                    float ghostPosition = 1.0f - currentStep / (float)baseGhostLength;
                    if (isSpiral) {
                        radians = (((double)(currentStep / 2.0f) + interpolate * (double)speed) * (double)baseGhostLength + Math.toDegrees(phaseShift)) * Math.PI / 180.0;
                        sinQuad = Math.sin((interpolate * 2.5 * (double)speed + (double)(currentStep * ((float)j + halfHeight))) * 2.0 * Math.PI / 180.0) / 2.0;
                    } else if (isDefault) {
                        int ghostIndexOnOrbit = j / 3;
                        int ghostsPerOrbit = (ghostsCount + 2) / 3;
                        double orbitPhaseShift = (double)ghostIndexOnOrbit * Math.PI * 2.0 / (double)ghostsPerOrbit;
                        radians = (interpolate * (double)speed + (double)currentStep * 0.5) * 0.3 + orbitPhaseShift;
                        sinQuad = 0.0;
                    } else {
                        double baseAngle = (interpolate * (double)speed + (double)currentStep * 0.5) * 0.15;
                        radians = baseAngle + phaseShift;
                        sinQuad = 0.0;
                    }
                    class_4587 matrices = new class_4587();
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
                    if (isSpiral) {
                        matrices.method_22904(vec.field_1352 + Math.cos(radians) * (double)width * (double)radiusModifier, vec.field_1351 + (double)halfHeight + sinQuad, vec.field_1350 + Math.sin(radians) * (double)width * (double)radiusModifier);
                    } else if (isDefault) {
                        double radius = (double)(width * radiusModifier) * 0.7;
                        double s = Math.sin(radians) * radius;
                        double c = Math.cos(radians) * radius;
                        double offsetX = 0.0;
                        double offsetY = 0.0;
                        double offsetZ = 0.0;
                        switch (j % 3) {
                            case 0: {
                                offsetX = s;
                                offsetY = c;
                                offsetZ = -c;
                                break;
                            }
                            case 1: {
                                offsetX = -s;
                                offsetY = s;
                                offsetZ = -c;
                                break;
                            }
                            case 2: {
                                offsetX = s;
                                offsetY = -c;
                                offsetZ = -c;
                            }
                        }
                        matrices.method_22904(vec.field_1352 + offsetX, vec.field_1351 + (double)halfHeight + offsetY, vec.field_1350 + offsetZ);
                    } else {
                        double orbitRadius = width * radiusModifier;
                        double orbitAngle = radians * 2.0 + (double)j * 1.0;
                        double baseX = Math.cos(orbitAngle) * orbitRadius;
                        double baseY = Math.sin(orbitAngle) * orbitRadius;
                        double baseZ = 0.0;
                        double tempY = baseY * cosX - baseZ * sinX;
                        double tempZ = baseY * sinX + baseZ * cosX;
                        baseY = tempY;
                        baseZ = tempZ;
                        double tempX = baseX * cosY + baseZ * sinY;
                        tempZ = -baseX * sinY + baseZ * cosY;
                        baseX = tempX;
                        tempX = baseX * cosZ - baseY * sinZ;
                        tempY = baseX * sinZ + baseY * cosZ;
                        double orbitX = tempX;
                        double orbitY = tempY;
                        double orbitZ = tempZ;
                        matrices.method_22904(vec.field_1352 + orbitX, vec.field_1351 + (double)halfHeight + orbitY, vec.field_1350 + orbitZ);
                    }
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
                    float trailGradient = 1.0f - currentStep / (float)baseGhostLength;
                    int color = ColorUtil.multAlpha(TargetRenderer.getGhostGradientColor(ghostPosition, red, module), trailGradient * animation);
                    float baseScale = endSize + (startSize - endSize) * ghostPosition;
                    float scale = baseScale * animation;
                    ParticleBatchRenderer.queueGhost(matrices.method_23760().method_23761().get(new Matrix4f()), module.getGhostTexture(), scale, color, module.getGhostsBlend().getSelected());
                }
            }
        }
    }

    public static void updateAnimations(float speedModifier) {
        long currentTick;
        long l = currentTick = TargetRenderer.mc.field_1687 != null ? TargetRenderer.mc.field_1687.method_8510() : 0L;
        if (lastUpdateTick == currentTick) {
            return;
        }
        lastUpdateTick = currentTick;
        prevEspValue = espValue;
        espValue += espSpeed * speedModifier;
        if (espSpeed > 25.0f) {
            flipSpeed = true;
        }
        if (espSpeed < -25.0f) {
            flipSpeed = false;
        }
        espSpeed = flipSpeed ? espSpeed - 0.5f * speedModifier : espSpeed + 0.5f * speedModifier;
        prevCircleStep = circleStep;
        circleStep += 0.15f * speedModifier;
    }

    private TargetRenderer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        lastUpdateTick = -1L;
        topLeft = null;
        topRight = null;
        bottomRight = null;
        bottomLeft = null;
    }
}

