/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.world;

import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_2761;
import net.minecraft.class_3532;
import net.minecraft.class_8646;
import net.minecraft.class_9011;
import org.apache.commons.lang3.StringUtils;
import padej.soup.base.QuickImports;
import padej.soup.base.util.entity.PlayerIntersectionUtil;
import padej.soup.base.util.other.StopWatch;
import padej.soup.implement.events.packet.PacketEvent;

public final class ServerUtil
implements QuickImports {
    private static final StopWatch pvpWatch = new StopWatch();
    public static String server = "Vanilla";
    public static float TPS = 20.0f;
    public static long timestamp;
    public static int anarchy;
    public static boolean pvpEnd;

    public static void tick() {
        anarchy = ServerUtil.getAnarchyMode();
        server = ServerUtil.getServer();
        pvpEnd = ServerUtil.inPvpEnd();
        if (ServerUtil.inPvp()) {
            pvpWatch.reset();
        }
    }

    public static void packet(PacketEvent e) {
        if (Objects.requireNonNull(e.getPacket()) instanceof class_2761) {
            long nanoTime = System.nanoTime();
            float maxTPS = 20.0f;
            float rawTPS = maxTPS * (1.0E9f / (float)(nanoTime - timestamp));
            TPS = class_3532.method_15363((float)rawTPS, (float)0.0f, (float)maxTPS);
            timestamp = nanoTime;
        }
    }

    private static String getServer() {
        if (PlayerIntersectionUtil.nullCheck() || mc.method_1562() == null || mc.method_1562().method_45734() == null || mc.method_1562().method_52790() == null) {
            return "Vanilla";
        }
        String serverIp = ServerUtil.mc.method_1562().method_45734().field_3761.toLowerCase();
        String brand = mc.method_1562().method_52790().toLowerCase();
        if (brand.contains("botfilter")) {
            return "FunTime";
        }
        if (brand.contains("\u00a76spooky\u00a7ccore")) {
            return "SpookyTime";
        }
        if (serverIp.contains("funtime") || serverIp.contains("skytime") || serverIp.contains("space-times") || serverIp.contains("funsky")) {
            return "CopyTime";
        }
        if (brand.contains("holyworld") || brand.contains("vk.com/idwok")) {
            return "HolyWorld";
        }
        if (serverIp.contains("reallyworld")) {
            return "ReallyWorld";
        }
        return "Vanilla";
    }

    private static int getAnarchyMode() {
        class_269 scoreboard = ServerUtil.mc.field_1687.method_8428();
        class_266 objective = scoreboard.method_1189(class_8646.field_45157);
        switch (server) {
            case "FunTime": {
                String[] string;
                if (objective == null || (string = objective.method_1114().getString().split("-")).length <= 1) break;
                return Integer.parseInt(string[1]);
            }
            case "HolyWorld": {
                for (class_9011 scoreboardEntry : scoreboard.method_1184(objective)) {
                    String string;
                    String text = class_268.method_1142((class_270)scoreboard.method_1164(scoreboardEntry.comp_2127()), (class_2561)scoreboardEntry.method_55387()).getString();
                    if (text.isEmpty() || (string = StringUtils.substringBetween((String)text, (String)"#", (String)" -\u25c6-")) == null || string.isEmpty()) continue;
                    return Integer.parseInt(string.replace(" (1.20)", ""));
                }
                break;
            }
        }
        return -1;
    }

    private static boolean inPvp() {
        return ServerUtil.mc.field_1705.method_1740().field_2060.values().stream().map(c -> c.method_5414().getString().toLowerCase()).anyMatch(s -> s.contains("pvp") || s.contains("\u043f\u0432\u043f"));
    }

    private static boolean inPvpEnd() {
        return ServerUtil.mc.field_1705.method_1740().field_2060.values().stream().map(c -> c.method_5414().getString().toLowerCase()).anyMatch(s -> !(!s.contains("pvp") && !s.contains("\u043f\u0432\u043f") || !s.contains("0") && !s.contains("1")));
    }

    private ServerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static int getAnarchy() {
        return anarchy;
    }

    public static boolean isPvpEnd() {
        return pvpEnd;
    }
}

