/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.core.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_310;
import padej.soup.api.repository.client.ClientUserRepository;
import padej.soup.base.util.logger.LoggerUtil;

public class ServerApi {
    private static final String SERVER_HOST = "77.110.111.251";
    private static final int SERVER_PORT = 25565;
    private static final int HEARTBEAT_INTERVAL = 30;
    public static final String HTTP_API_URL = "https://77.110.111.251/api";
    public static final boolean HTTP_API_ENABLED = true;
    public static final long CACHE_DURATION_MS = 60000L;
    public static final long FULL_REFRESH_INTERVAL_MS = 300000L;
    private Socket socket;
    private PrintWriter out;
    private BufferedReader in;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> heartbeatTask;
    private boolean running = false;
    private String currentUsername;

    public void start() {
        if (this.running) {
            LoggerUtil.warn("ServerApi is already running");
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.method_1548() == null || mc.method_1548().method_1676() == null) {
            LoggerUtil.error("Cannot start ServerApi: No valid session");
            return;
        }
        this.currentUsername = mc.method_1548().method_1676();
        this.running = true;
        this.executor = Executors.newScheduledThreadPool(2);
        this.executor.submit(this::connectToServer);
    }

    public void stop() {
        this.running = false;
        try {
            if (this.out != null) {
                this.out.println("DISCONNECT:" + this.currentUsername);
                this.out.flush();
            }
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
            if (this.executor != null) {
                this.executor.shutdown();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            LoggerUtil.error("Error stopping ServerApi: " + e.getMessage());
        }
        LoggerUtil.info("ServerApi stopped");
    }

    private void connectToServer() {
        try {
            LoggerUtil.info("Connecting to SoupAPI server at 77.110.111.251:25565");
            this.socket = new Socket(SERVER_HOST, 25565);
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out.println("CONNECT:" + this.currentUsername);
            LoggerUtil.info("Connected to SoupAPI server");
            if (this.heartbeatTask != null && !this.heartbeatTask.isCancelled()) {
                this.heartbeatTask.cancel(false);
            }
            this.heartbeatTask = this.executor.scheduleAtFixedRate(this::sendHeartbeat, 0L, 30L, TimeUnit.SECONDS);
            this.executor.submit(this::listenForMessages);
        }
        catch (Exception e) {
            LoggerUtil.error("Failed to connect to SoupAPI server: " + e.getMessage());
            this.running = false;
        }
    }

    private void sendHeartbeat() {
        if (!this.running || this.out == null) {
            return;
        }
        try {
            this.out.println("HEARTBEAT:" + this.currentUsername);
        }
        catch (Exception e) {
            LoggerUtil.error("Error sending heartbeat: " + e.getMessage());
            this.reconnect();
        }
    }

    private void listenForMessages() {
        block4: {
            try {
                String message;
                while (this.running && (message = this.in.readLine()) != null) {
                    this.handleMessage(message);
                }
                if (this.running) {
                    LoggerUtil.error("Connection lost: stream closed by server");
                    this.reconnect();
                }
            }
            catch (Exception e) {
                if (!this.running) break block4;
                LoggerUtil.error("Connection lost: " + e.getMessage());
                this.reconnect();
            }
        }
    }

    private void handleMessage(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        if (message.startsWith("USERS:")) {
            String userList = message.substring(6);
            ClientUserRepository.updateUsers(userList);
        }
    }

    private void reconnect() {
        LoggerUtil.info("Attempting to reconnect...");
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Thread.sleep(5000L);
            this.connectToServer();
        }
        catch (Exception e) {
            LoggerUtil.error("Reconnection failed: " + e.getMessage());
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

