/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.draggables;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.entity.PlayerIntersectionUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.implement.features.draggables.playerinfo.BPSComponent;
import padej.soup.implement.features.draggables.playerinfo.PlayerInfoComponent;
import padej.soup.implement.features.draggables.playerinfo.TPSComponent;
import padej.soup.implement.features.draggables.playerinfo.XYZComponent;

public class PlayerInfo
extends AbstractDraggable {
    private final List<PlayerInfoComponent> components = new ArrayList<PlayerInfoComponent>();
    private final Animation chatHideAnimation = new DecelerateAnimation().setMs(250).setValue(1.0);

    public PlayerInfo() {
        super("PlayerInfo", 3, 0, 92, 16, false);
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.components.add(new BPSComponent());
        this.components.add(new TPSComponent());
        this.components.add(new XYZComponent());
    }

    @Override
    public void tick() {
        for (PlayerInfoComponent component : this.components) {
            component.tick();
        }
    }

    @Override
    public void drawDraggable(class_332 e) {
        int offset;
        class_4587 matrix = e.method_51448();
        FontRenderer font = Fonts.getSize(15, Fonts.Type.INTER_DEFAULT);
        List<PlayerInfoComponent> enabledComponents = this.getEnabledComponents();
        if (enabledComponents.isEmpty()) {
            return;
        }
        padej.soup.implement.features.modules.hud.PlayerInfo playerInfo = padej.soup.implement.features.modules.hud.PlayerInfo.getInstance();
        boolean isVertical = playerInfo.position.isSelected("Vertical");
        boolean isChatOpen = PlayerIntersectionUtil.isChat(PlayerInfo.mc.field_1755);
        int n = offset = isChatOpen ? -13 : 0;
        if (isVertical) {
            this.chatHideAnimation.setDirection(isChatOpen ? Direction.BACKWARDS : Direction.FORWARDS);
            float alpha = this.chatHideAnimation.getOutput().floatValue();
            if (alpha < 0.01f) {
                return;
            }
            float lineHeight = 16.0f;
            boolean isSplitStyle = playerInfo.style.isSelected("Split");
            boolean hasBackground = playerInfo.getShowBackground().isValue();
            float lineGap = hasBackground && !isSplitStyle ? -6.0f : 2.0f;
            int totalHeight = (int)((float)enabledComponents.size() * lineHeight + (float)(enabledComponents.size() - 1) * lineGap);
            this.setY(window.method_4502() + offset - totalHeight - 5);
            MathUtil.setAlpha(alpha, () -> this.drawVerticalStyle(matrix, font, enabledComponents));
        } else {
            this.setY(window.method_4502() + offset - 24);
            boolean isSplitStyle = playerInfo.style.isSelected("Split");
            if (isSplitStyle) {
                this.drawSplitStyle(matrix, font, enabledComponents);
            } else {
                this.drawMonoStyle(matrix, font, enabledComponents);
            }
        }
    }

    private void drawMonoStyle(class_4587 matrix, FontRenderer font, List<PlayerInfoComponent> enabledComponents) {
        List<Object> lines;
        float padding = 5.0f;
        float separatorSpacing = 10.0f;
        float lineGap = 4.0f;
        float lineHeight = 16.0f;
        float maxWidth = 300.0f;
        ArrayList<Float> componentWidths = new ArrayList<Float>();
        for (PlayerInfoComponent comp : enabledComponents) {
            componentWidths.add(Float.valueOf(comp.getSmoothedWidth(font, lineHeight)));
        }
        float totalWidth = 0.0f;
        for (int i = 0; i < enabledComponents.size(); ++i) {
            float componentWidth = ((Float)componentWidths.get(i)).floatValue();
            totalWidth += componentWidth + padding * 2.0f;
            if (i <= 0) continue;
            totalWidth += separatorSpacing;
        }
        if (totalWidth <= maxWidth) {
            lines = new ArrayList();
            ArrayList<Integer> singleLine = new ArrayList<Integer>();
            for (int i = 0; i < enabledComponents.size(); ++i) {
                singleLine.add(i);
            }
            lines.add(singleLine);
        } else {
            lines = this.balanceLines(enabledComponents, componentWidths, maxWidth, padding, separatorSpacing, lineHeight);
        }
        float currentY = this.getY();
        float maxLineWidth = 0.0f;
        for (List list : lines) {
            float lineContentWidth = 0.0f;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                lineContentWidth += ((Float)componentWidths.get(idx)).floatValue();
            }
            if (list.size() > 1) {
                lineContentWidth += separatorSpacing * (float)(list.size() - 1);
            }
            float backgroundX = this.getX();
            if (lineContentWidth > 0.0f) {
                float actualWidth = lineContentWidth + padding * 2.0f;
                if (padej.soup.implement.features.modules.hud.PlayerInfo.getInstance().getShowBackground().isValue()) {
                    blur.render(ShapeProperties.create(matrix, backgroundX, currentY, actualWidth, lineHeight).round(3.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
                }
                maxLineWidth = Math.max(maxLineWidth, actualWidth);
            }
            float currentX = backgroundX + padding;
            for (int i = 0; i < list.size(); ++i) {
                int componentIndex = (Integer)list.get(i);
                PlayerInfoComponent component = enabledComponents.get(componentIndex);
                component.render(matrix, currentX, currentY, lineHeight, font);
                currentX += ((Float)componentWidths.get(componentIndex)).floatValue();
                if (i >= list.size() - 1) continue;
                currentX += separatorSpacing;
            }
            this.renderLineSeparators(matrix, list, enabledComponents, componentWidths, padding, separatorSpacing, currentY, lineHeight);
            currentY += lineHeight + lineGap;
        }
        int totalHeight = (int)((float)lines.size() * lineHeight + (float)(lines.size() - 1) * lineGap);
        this.setWidth((int)maxLineWidth);
        this.setHeight(totalHeight);
    }

    private List<List<Integer>> balanceLines(List<PlayerInfoComponent> components, List<Float> widths, float maxWidth, float padding, float separatorSpacing, float lineHeight) {
        ArrayList<List<Integer>> lines = new ArrayList<List<Integer>>();
        ArrayList<Integer> currentLine = new ArrayList<Integer>();
        float currentLineWidth = 0.0f;
        for (int i = 0; i < components.size(); ++i) {
            float componentWidth = widths.get(i).floatValue();
            boolean needsSeparator = !currentLine.isEmpty();
            float widthNeeded = componentWidth + padding * 2.0f;
            if (needsSeparator) {
                widthNeeded += separatorSpacing;
            }
            if (!currentLine.isEmpty() && currentLineWidth + widthNeeded > maxWidth) {
                lines.add(new ArrayList(currentLine));
                currentLine.clear();
                currentLineWidth = 0.0f;
                widthNeeded = componentWidth + padding * 2.0f;
            }
            currentLine.add(i);
            currentLineWidth += widthNeeded;
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine);
        }
        return lines;
    }

    private void renderLineSeparators(class_4587 matrix, List<Integer> line, List<PlayerInfoComponent> allComponents, List<Float> componentWidths, float padding, float separatorSpacing, float y, float lineHeight) {
        float backgroundX = this.getX();
        float currentX = backgroundX + padding;
        padej.soup.implement.features.modules.hud.PlayerInfo playerInfo = padej.soup.implement.features.modules.hud.PlayerInfo.getInstance();
        int separatorColor = !playerInfo.getColoredSeparators().isValue() ? ColorUtil.getOutline(0.75f, 0.5f) : (playerInfo.getSeparatorGradient().isValue() ? ColorUtil.fade(8) : ColorUtil.getClientColor());
        for (int i = 0; i < line.size() - 1; ++i) {
            int componentIndex = line.get(i);
            float width = componentWidths.get(componentIndex).floatValue();
            float separatorX = (currentX += width) + separatorSpacing / 2.0f;
            rectangle.render(ShapeProperties.create(matrix, separatorX, y + 4.0f, 0.5, lineHeight - 8.0f).color(separatorColor).build());
            currentX += separatorSpacing;
        }
    }

    private void drawSplitStyle(class_4587 matrix, FontRenderer font, List<PlayerInfoComponent> enabledComponents) {
        List<Object> lines;
        float padding = 5.0f;
        float componentGap = 4.0f;
        float lineGap = 4.0f;
        float lineHeight = 16.0f;
        float maxWidth = 300.0f;
        ArrayList<Float> componentWidths = new ArrayList<Float>();
        for (PlayerInfoComponent comp : enabledComponents) {
            componentWidths.add(Float.valueOf(comp.getSmoothedWidth(font, lineHeight)));
        }
        float totalWidth = 0.0f;
        for (int i = 0; i < enabledComponents.size(); ++i) {
            float componentWidth = ((Float)componentWidths.get(i)).floatValue();
            float fullWidth = componentWidth + padding * 2.0f;
            totalWidth += fullWidth;
            if (i <= 0) continue;
            totalWidth += componentGap;
        }
        if (totalWidth <= maxWidth) {
            lines = new ArrayList();
            ArrayList<Integer> singleLine = new ArrayList<Integer>();
            for (int i = 0; i < enabledComponents.size(); ++i) {
                singleLine.add(i);
            }
            lines.add(singleLine);
        } else {
            lines = this.balanceSplitLines(enabledComponents, componentWidths, maxWidth, padding, componentGap);
        }
        float currentY = this.getY();
        float maxLineWidth = 0.0f;
        for (List list : lines) {
            float currentX = this.getX();
            float lineWidth = 0.0f;
            for (int i = 0; i < list.size(); ++i) {
                int componentIndex = (Integer)list.get(i);
                PlayerInfoComponent component = enabledComponents.get(componentIndex);
                float componentWidth = ((Float)componentWidths.get(componentIndex)).floatValue();
                if (padej.soup.implement.features.modules.hud.PlayerInfo.getInstance().getShowBackground().isValue()) {
                    blur.render(ShapeProperties.create(matrix, currentX, currentY, componentWidth + padding * 2.0f, lineHeight).round(3.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
                }
                float renderX = currentX + padding;
                component.render(matrix, renderX, currentY, lineHeight, font);
                float fullComponentWidth = componentWidth + padding * 2.0f;
                currentX += fullComponentWidth;
                lineWidth += fullComponentWidth;
                if (i >= list.size() - 1) continue;
                currentX += componentGap;
                lineWidth += componentGap;
            }
            maxLineWidth = Math.max(maxLineWidth, lineWidth);
            currentY += lineHeight + lineGap;
        }
        int totalHeight = (int)((float)lines.size() * lineHeight + (float)(lines.size() - 1) * lineGap);
        this.setWidth((int)maxLineWidth);
        this.setHeight(totalHeight);
    }

    private List<List<Integer>> balanceSplitLines(List<PlayerInfoComponent> components, List<Float> widths, float maxWidth, float padding, float componentGap) {
        ArrayList<List<Integer>> lines = new ArrayList<List<Integer>>();
        ArrayList<Integer> currentLine = new ArrayList<Integer>();
        float currentLineWidth = 0.0f;
        for (int i = 0; i < components.size(); ++i) {
            float fullWidth = widths.get(i).floatValue() + padding * 2.0f;
            float widthToAdd = fullWidth + (currentLine.isEmpty() ? 0.0f : componentGap);
            if (!currentLine.isEmpty() && currentLineWidth + widthToAdd > maxWidth) {
                lines.add(new ArrayList(currentLine));
                currentLine.clear();
                currentLineWidth = 0.0f;
                widthToAdd = fullWidth;
            }
            currentLine.add(i);
            currentLineWidth += widthToAdd;
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine);
        }
        return lines;
    }

    private List<PlayerInfoComponent> getEnabledComponents() {
        ArrayList<PlayerInfoComponent> enabled = new ArrayList<PlayerInfoComponent>();
        for (PlayerInfoComponent component : this.components) {
            if (!this.isComponentEnabled(component.getName())) continue;
            enabled.add(component);
        }
        return enabled;
    }

    private boolean isComponentEnabled(String componentName) {
        return padej.soup.implement.features.modules.hud.PlayerInfo.getInstance().playerInfoComponents.isSelected(componentName);
    }

    private void drawVerticalStyle(class_4587 matrix, FontRenderer font, List<PlayerInfoComponent> enabledComponents) {
        float padding = 5.0f;
        float lineHeight = 16.0f;
        padej.soup.implement.features.modules.hud.PlayerInfo playerInfo = padej.soup.implement.features.modules.hud.PlayerInfo.getInstance();
        boolean isSplitStyle = playerInfo.style.isSelected("Split");
        boolean hasBackground = playerInfo.getShowBackground().isValue();
        float lineGap = hasBackground && !isSplitStyle ? -6.0f : 2.0f;
        ArrayList<Float> componentWidths = new ArrayList<Float>();
        for (PlayerInfoComponent playerInfoComponent : enabledComponents) {
            componentWidths.add(Float.valueOf(playerInfoComponent.getSmoothedWidth(font, lineHeight)));
        }
        float maxComponentWidth = 0.0f;
        Iterator iterator = componentWidths.iterator();
        while (iterator.hasNext()) {
            float width = ((Float)iterator.next()).floatValue();
            maxComponentWidth = Math.max(maxComponentWidth, width);
        }
        float f = this.getY();
        float maxWidth = 0.0f;
        for (int i = 0; i < enabledComponents.size(); ++i) {
            PlayerInfoComponent component = enabledComponents.get(i);
            float componentWidth = ((Float)componentWidths.get(i)).floatValue();
            float backgroundX = this.getX();
            if (isSplitStyle) {
                if (playerInfo.getShowBackground().isValue()) {
                    blur.render(ShapeProperties.create(matrix, backgroundX, f, componentWidth + padding * 2.0f, lineHeight).round(3.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
                }
                maxWidth = Math.max(maxWidth, componentWidth + padding * 2.0f);
            } else {
                if (i == 0 && playerInfo.getShowBackground().isValue()) {
                    float totalHeight = (float)enabledComponents.size() * lineHeight + (float)(enabledComponents.size() - 1) * lineGap;
                    blur.render(ShapeProperties.create(matrix, backgroundX, f, maxComponentWidth + padding * 2.0f, totalHeight).round(3.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getRect(0.7f)).build());
                }
                maxWidth = maxComponentWidth + padding * 2.0f;
            }
            float renderX = backgroundX + padding;
            component.render(matrix, renderX, f, lineHeight, font);
            f += lineHeight + lineGap;
        }
        int totalHeight = (int)((float)enabledComponents.size() * lineHeight + (float)(enabledComponents.size() - 1) * lineGap);
        this.setWidth((int)maxWidth);
        this.setHeight(totalHeight);
    }
}

