/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.other;

import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1764;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import padej.soup.api.event.EventHandler;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.implement.BooleanSetting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.base.util.compat.ModCompatibility;
import padej.soup.base.util.other.Instance;
import padej.soup.implement.events.item.HandAnimationEvent;
import padej.soup.implement.events.item.HandOffsetEvent;
import padej.soup.implement.events.item.HandScaleEvent;
import padej.soup.implement.events.item.SwingDurationEvent;

public class HandTweaks
extends Module {
    private final BooleanSetting enableSwing = new BooleanSetting("setting.handtweaks.enableswing.name", "setting.handtweaks.enableswing.desc").setValue(false).visible(() -> !ModCompatibility.isHoldMyItemsLoaded());
    private final SelectSetting swingType = new SelectSetting("setting.handtweaks.swingtype.name", "setting.handtweaks.swingtype.desc").value("Vanilla", "Swipe", "Down", "Smooth", "Power", "Feast", "Custom").selected("Vanilla").visible(() -> this.enableSwing.isValue() && !ModCompatibility.isHoldMyItemsLoaded());
    private final ValueSetting swingSpeed = new ValueSetting("setting.handtweaks.swingspeed.name", "setting.handtweaks.swingspeed.desc").setValue(1.0f).range(0.5f, 2.0f).visible(() -> this.enableSwing.isValue() || ModCompatibility.isHoldMyItemsLoaded());
    private final ValueSetting customTranslateX = new ValueSetting("setting.handtweaks.customtranslatex.name", "setting.handtweaks.customtranslatex.desc").setValue(0.56f).range(-2.0f, 2.0f).visible(() -> this.enableSwing.isValue() && this.swingType.getSelected().equals("Custom"));
    private final ValueSetting customTranslateY = new ValueSetting("setting.handtweaks.customtranslatey.name", "setting.handtweaks.customtranslatey.desc").setValue(-0.32f).range(-2.0f, 2.0f).visible(() -> this.enableSwing.isValue() && this.swingType.getSelected().equals("Custom"));
    private final ValueSetting customTranslateZ = new ValueSetting("setting.handtweaks.customtranslatez.name", "setting.handtweaks.customtranslatez.desc").setValue(-0.72f).range(-2.0f, 2.0f).visible(() -> this.enableSwing.isValue() && this.swingType.getSelected().equals("Custom"));
    private final ValueSetting customRotateX = new ValueSetting("setting.handtweaks.customrotatex.name", "setting.handtweaks.customrotatex.desc").setValue(0.0f).range(-180.0f, 180.0f).visible(() -> this.enableSwing.isValue() && this.swingType.getSelected().equals("Custom"));
    private final ValueSetting customRotateY = new ValueSetting("setting.handtweaks.customrotatey.name", "setting.handtweaks.customrotatey.desc").setValue(0.0f).range(-180.0f, 180.0f).visible(() -> this.enableSwing.isValue() && this.swingType.getSelected().equals("Custom"));
    private final ValueSetting customRotateZ = new ValueSetting("setting.handtweaks.customrotatez.name", "setting.handtweaks.customrotatez.desc").setValue(0.0f).range(-180.0f, 180.0f).visible(() -> this.enableSwing.isValue() && this.swingType.getSelected().equals("Custom"));
    private final ValueSetting customSwingRotateX = new ValueSetting("setting.handtweaks.customswingrotatex.name", "setting.handtweaks.customswingrotatex.desc").setValue(-60.0f).range(-180.0f, 180.0f).visible(() -> this.enableSwing.isValue() && this.swingType.getSelected().equals("Custom"));
    private final ValueSetting customSwingRotateY = new ValueSetting("setting.handtweaks.customswingrotatey.name", "setting.handtweaks.customswingrotatey.desc").setValue(0.0f).range(-180.0f, 180.0f).visible(() -> this.enableSwing.isValue() && this.swingType.getSelected().equals("Custom"));
    private final ValueSetting customSwingRotateZ = new ValueSetting("setting.handtweaks.customswingrotatez.name", "setting.handtweaks.customswingrotatez.desc").setValue(0.0f).range(-180.0f, 180.0f).visible(() -> this.enableSwing.isValue() && this.swingType.getSelected().equals("Custom"));
    private final ValueSetting mainHandX = new ValueSetting("setting.handtweaks.mainhandx.name", "setting.handtweaks.mainhandx.desc").setValue(0.0f).range(-1.0f, 1.0f);
    private final ValueSetting mainHandY = new ValueSetting("setting.handtweaks.mainhandy.name", "setting.handtweaks.mainhandy.desc").setValue(0.0f).range(-1.0f, 1.0f);
    private final ValueSetting mainHandZ = new ValueSetting("setting.handtweaks.mainhandz.name", "setting.handtweaks.mainhandz.desc").setValue(0.0f).range(-2.5f, 2.5f);
    private final ValueSetting mainHandPitch = new ValueSetting("setting.handtweaks.mainhandpitch.name", "setting.handtweaks.mainhandpitch.desc").setValue(0.0f).range(-180.0f, 180.0f);
    private final ValueSetting mainHandYaw = new ValueSetting("setting.handtweaks.mainhandyaw.name", "setting.handtweaks.mainhandyaw.desc").setValue(0.0f).range(-180.0f, 180.0f);
    private final ValueSetting mainHandRoll = new ValueSetting("setting.handtweaks.mainhandroll.name", "setting.handtweaks.mainhandroll.desc").setValue(0.0f).range(-180.0f, 180.0f);
    private final ValueSetting mainHandScale = new ValueSetting("setting.handtweaks.mainhandscale.name", "setting.handtweaks.mainhandscale.desc").setValue(1.0f).range(0.1f, 2.0f);
    private final ValueSetting offHandX = new ValueSetting("setting.handtweaks.offhandx.name", "setting.handtweaks.offhandx.desc").setValue(0.0f).range(-1.0f, 1.0f);
    private final ValueSetting offHandY = new ValueSetting("setting.handtweaks.offhandy.name", "setting.handtweaks.offhandy.desc").setValue(0.0f).range(-1.0f, 1.0f);
    private final ValueSetting offHandZ = new ValueSetting("setting.handtweaks.offhandz.name", "setting.handtweaks.offhandz.desc").setValue(0.0f).range(-2.5f, 2.5f);
    private final ValueSetting offHandPitch = new ValueSetting("setting.handtweaks.offhandpitch.name", "setting.handtweaks.offhandpitch.desc").setValue(0.0f).range(-180.0f, 180.0f);
    private final ValueSetting offHandYaw = new ValueSetting("setting.handtweaks.offhandyaw.name", "setting.handtweaks.offhandyaw.desc").setValue(0.0f).range(-180.0f, 180.0f);
    private final ValueSetting offHandRoll = new ValueSetting("setting.handtweaks.offhandroll.name", "setting.handtweaks.offhandroll.desc").setValue(0.0f).range(-180.0f, 180.0f);
    private final ValueSetting offHandScale = new ValueSetting("setting.handtweaks.offhandscale.name", "setting.handtweaks.offhandscale.desc").setValue(1.0f).range(0.1f, 2.0f);

    public static HandTweaks getInstance() {
        return Instance.get(HandTweaks.class);
    }

    public HandTweaks() {
        super("module.handtweaks.name", ModuleCategory.OTHER);
        GroupSetting swingGroup = new GroupSetting("group.handtweaks.swing.name", "group.handtweaks.swing.desc", false).settings(this.enableSwing, this.swingType, this.swingSpeed);
        GroupSetting customTranslateGroup = new GroupSetting("group.handtweaks.customtranslate.name", "group.handtweaks.customtranslate.desc", false).settings(this.customTranslateX, this.customTranslateY, this.customTranslateZ).visible(() -> this.enableSwing.isValue() && this.swingType.getSelected().equals("Custom"));
        GroupSetting customRotateGroup = new GroupSetting("group.handtweaks.customrotate.name", "group.handtweaks.customrotate.desc", false).settings(this.customRotateX, this.customRotateY, this.customRotateZ).visible(() -> this.enableSwing.isValue() && this.swingType.getSelected().equals("Custom"));
        GroupSetting customSwingRotateGroup = new GroupSetting("group.handtweaks.customswingrotat.name", "group.handtweaks.customswingrotat.desc", false).settings(this.customSwingRotateX, this.customSwingRotateY, this.customSwingRotateZ).visible(() -> this.enableSwing.isValue() && this.swingType.getSelected().equals("Custom"));
        GroupSetting mainPositionGroup = new GroupSetting("group.handtweaks.mainposition.name", "group.handtweaks.mainposition.desc", false).settings(this.mainHandX, this.mainHandY, this.mainHandZ);
        GroupSetting mainRotationGroup = new GroupSetting("group.handtweaks.mainrotation.name", "group.handtweaks.mainrotation.desc", false).settings(this.mainHandPitch, this.mainHandYaw, this.mainHandRoll);
        GroupSetting offPositionGroup = new GroupSetting("group.handtweaks.offposition.name", "group.handtweaks.offposition.desc", false).settings(this.offHandX, this.offHandY, this.offHandZ);
        GroupSetting offRotationGroup = new GroupSetting("group.handtweaks.offrotation.name", "group.handtweaks.offrotation.desc", false).settings(this.offHandPitch, this.offHandYaw, this.offHandRoll);
        if (ModCompatibility.isHoldMyItemsLoaded()) {
            this.setup(this.swingSpeed);
        } else {
            this.setup(swingGroup, customTranslateGroup, customRotateGroup, customSwingRotateGroup, mainPositionGroup, mainRotationGroup, this.mainHandScale, offPositionGroup, offRotationGroup, this.offHandScale);
        }
    }

    @EventHandler
    public void onSwingDuration(SwingDurationEvent event) {
        if (!this.isEnabled() || !this.enableSwing.isValue()) {
            return;
        }
        event.setAnimation(this.swingSpeed.getValue());
        event.cancel();
    }

    @EventHandler
    public void onHandScale(HandScaleEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        class_1268 hand = event.getHand();
        if (hand.equals((Object)class_1268.field_5808)) {
            if (this.mainHandScale.getValue() != 1.0f) {
                event.setScale(this.mainHandScale.getValue());
            }
        } else if (this.offHandScale.getValue() != 1.0f) {
            event.setScale(this.offHandScale.getValue());
        }
    }

    @EventHandler
    public void onHandAnimation(HandAnimationEvent event) {
        if (!this.isEnabled() || !this.enableSwing.isValue()) {
            return;
        }
        if (!event.getHand().equals((Object)class_1268.field_5808) || this.swingType.getSelected().equals("Vanilla")) {
            return;
        }
        class_4587 matrix = event.getMatrices();
        float swingProgress = event.getSwingProgress();
        int i = HandTweaks.mc.field_1724.method_6068().equals((Object)class_1306.field_6183) ? 1 : -1;
        float sin1 = class_3532.method_15374((float)(swingProgress * swingProgress * (float)Math.PI));
        float sin2 = class_3532.method_15374((float)(class_3532.method_15355((float)swingProgress) * (float)Math.PI));
        float sinSmooth = (float)(Math.sin((double)swingProgress * Math.PI) * 0.5);
        switch (this.swingType.getSelected()) {
            case "Swipe": {
                matrix.method_46416(0.56f * (float)i, -0.32f, -0.72f);
                matrix.method_22907(class_7833.field_40716.rotationDegrees((float)(60 * i)));
                matrix.method_22907(class_7833.field_40718.rotationDegrees((float)(-60 * i)));
                matrix.method_22907(class_7833.field_40716.rotationDegrees(sin2 * sin1 * -5.0f));
                matrix.method_22907(class_7833.field_40714.rotationDegrees(sin2 * sin1 * -120.0f));
                matrix.method_22907(class_7833.field_40714.rotationDegrees(-60.0f));
                break;
            }
            case "Down": {
                matrix.method_46416((float)i * 0.56f, -0.32f, -0.72f);
                matrix.method_22907(class_7833.field_40716.rotationDegrees((float)(76 * i)));
                matrix.method_22907(class_7833.field_40716.rotationDegrees(sin2 * -5.0f));
                matrix.method_22907(class_7833.field_40713.rotationDegrees(sin2 * -100.0f));
                matrix.method_22907(class_7833.field_40714.rotationDegrees(sin2 * -155.0f));
                matrix.method_22907(class_7833.field_40714.rotationDegrees(-100.0f));
                break;
            }
            case "Smooth": {
                matrix.method_46416((float)i * 0.56f, -0.42f, -0.72f);
                matrix.method_22907(class_7833.field_40716.rotationDegrees((float)i * (45.0f + sin1 * -20.0f)));
                matrix.method_22907(class_7833.field_40718.rotationDegrees((float)i * sin2 * -20.0f));
                matrix.method_22907(class_7833.field_40714.rotationDegrees(sin2 * -80.0f));
                matrix.method_22907(class_7833.field_40716.rotationDegrees((float)i * -45.0f));
                matrix.method_22904(0.0, -0.1, 0.0);
                break;
            }
            case "Power": {
                matrix.method_46416((float)i * 0.56f, -0.32f, -0.72f);
                matrix.method_46416(-sinSmooth * sinSmooth * sin1 * (float)i, 0.0f, 0.0f);
                matrix.method_22907(class_7833.field_40716.rotationDegrees((float)(61 * i)));
                matrix.method_22907(class_7833.field_40718.rotationDegrees(sin2));
                matrix.method_22907(class_7833.field_40716.rotationDegrees(sin2 * sin1 * -5.0f));
                matrix.method_22907(class_7833.field_40714.rotationDegrees(sin2 * sin1 * -30.0f));
                matrix.method_22907(class_7833.field_40714.rotationDegrees(-60.0f));
                matrix.method_22907(class_7833.field_40714.rotationDegrees(sinSmooth * -60.0f));
                break;
            }
            case "Feast": {
                matrix.method_46416((float)i * 0.56f, -0.32f, -0.72f);
                matrix.method_22907(class_7833.field_40716.rotationDegrees((float)(30 * i)));
                matrix.method_22907(class_7833.field_40716.rotationDegrees(sin2 * 75.0f * (float)i));
                matrix.method_22907(class_7833.field_40714.rotationDegrees(sin2 * -45.0f));
                matrix.method_22907(class_7833.field_40716.rotationDegrees((float)(30 * i)));
                matrix.method_22907(class_7833.field_40714.rotationDegrees(-80.0f));
                matrix.method_22907(class_7833.field_40716.rotationDegrees((float)(35 * i)));
                break;
            }
            case "Custom": {
                matrix.method_46416((float)i * this.customTranslateX.getValue(), this.customTranslateY.getValue(), this.customTranslateZ.getValue());
                if (this.customRotateX.getValue() != 0.0f) {
                    matrix.method_22907(class_7833.field_40714.rotationDegrees(this.customRotateX.getValue()));
                }
                if (this.customRotateY.getValue() != 0.0f) {
                    matrix.method_22907(class_7833.field_40716.rotationDegrees(this.customRotateY.getValue() * (float)i));
                }
                if (this.customRotateZ.getValue() != 0.0f) {
                    matrix.method_22907(class_7833.field_40718.rotationDegrees(this.customRotateZ.getValue() * (float)i));
                }
                if (this.customSwingRotateX.getValue() != 0.0f) {
                    matrix.method_22907(class_7833.field_40714.rotationDegrees(sin2 * this.customSwingRotateX.getValue()));
                }
                if (this.customSwingRotateY.getValue() != 0.0f) {
                    matrix.method_22907(class_7833.field_40716.rotationDegrees(sin2 * this.customSwingRotateY.getValue() * (float)i));
                }
                if (this.customSwingRotateZ.getValue() == 0.0f) break;
                matrix.method_22907(class_7833.field_40718.rotationDegrees(sin2 * this.customSwingRotateZ.getValue() * (float)i));
            }
        }
        event.cancel();
    }

    @EventHandler
    public void onHandOffset(HandOffsetEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        class_1268 hand = event.getHand();
        if (hand.equals((Object)class_1268.field_5808) && event.getStack().method_7909() instanceof class_1764) {
            return;
        }
        class_4587 matrix = event.getMatrices();
        if (hand.equals((Object)class_1268.field_5808)) {
            matrix.method_46416(this.mainHandX.getValue(), this.mainHandY.getValue(), this.mainHandZ.getValue());
            if (this.mainHandPitch.getValue() != 0.0f) {
                matrix.method_22907(class_7833.field_40714.rotationDegrees(this.mainHandPitch.getValue()));
            }
            if (this.mainHandYaw.getValue() != 0.0f) {
                matrix.method_22907(class_7833.field_40716.rotationDegrees(this.mainHandYaw.getValue()));
            }
            if (this.mainHandRoll.getValue() != 0.0f) {
                matrix.method_22907(class_7833.field_40718.rotationDegrees(this.mainHandRoll.getValue()));
            }
        } else {
            matrix.method_46416(this.offHandX.getValue(), this.offHandY.getValue(), this.offHandZ.getValue());
            if (this.offHandPitch.getValue() != 0.0f) {
                matrix.method_22907(class_7833.field_40714.rotationDegrees(this.offHandPitch.getValue()));
            }
            if (this.offHandYaw.getValue() != 0.0f) {
                matrix.method_22907(class_7833.field_40716.rotationDegrees(this.offHandYaw.getValue()));
            }
            if (this.offHandRoll.getValue() != 0.0f) {
                matrix.method_22907(class_7833.field_40718.rotationDegrees(this.offHandRoll.getValue()));
            }
        }
    }

    public BooleanSetting getEnableSwing() {
        return this.enableSwing;
    }

    public SelectSetting getSwingType() {
        return this.swingType;
    }

    public ValueSetting getSwingSpeed() {
        return this.swingSpeed;
    }

    public ValueSetting getCustomTranslateX() {
        return this.customTranslateX;
    }

    public ValueSetting getCustomTranslateY() {
        return this.customTranslateY;
    }

    public ValueSetting getCustomTranslateZ() {
        return this.customTranslateZ;
    }

    public ValueSetting getCustomRotateX() {
        return this.customRotateX;
    }

    public ValueSetting getCustomRotateY() {
        return this.customRotateY;
    }

    public ValueSetting getCustomRotateZ() {
        return this.customRotateZ;
    }

    public ValueSetting getCustomSwingRotateX() {
        return this.customSwingRotateX;
    }

    public ValueSetting getCustomSwingRotateY() {
        return this.customSwingRotateY;
    }

    public ValueSetting getCustomSwingRotateZ() {
        return this.customSwingRotateZ;
    }

    public ValueSetting getMainHandX() {
        return this.mainHandX;
    }

    public ValueSetting getMainHandY() {
        return this.mainHandY;
    }

    public ValueSetting getMainHandZ() {
        return this.mainHandZ;
    }

    public ValueSetting getMainHandPitch() {
        return this.mainHandPitch;
    }

    public ValueSetting getMainHandYaw() {
        return this.mainHandYaw;
    }

    public ValueSetting getMainHandRoll() {
        return this.mainHandRoll;
    }

    public ValueSetting getMainHandScale() {
        return this.mainHandScale;
    }

    public ValueSetting getOffHandX() {
        return this.offHandX;
    }

    public ValueSetting getOffHandY() {
        return this.offHandY;
    }

    public ValueSetting getOffHandZ() {
        return this.offHandZ;
    }

    public ValueSetting getOffHandPitch() {
        return this.offHandPitch;
    }

    public ValueSetting getOffHandYaw() {
        return this.offHandYaw;
    }

    public ValueSetting getOffHandRoll() {
        return this.offHandRoll;
    }

    public ValueSetting getOffHandScale() {
        return this.offHandScale;
    }
}

