/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.visuals;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import padej.soup.api.event.EventHandler;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.base.util.animation.Interpolations;
import padej.soup.base.util.animation.ThreeStageAnimation;
import padej.soup.base.util.other.Instance;
import padej.soup.base.util.other.StopWatch;
import padej.soup.base.util.render.JumpCircleRenderer;
import padej.soup.implement.events.player.JumpEvent;
import padej.soup.implement.events.render.WorldRenderEvent;

public class JumpCircles
extends Module {
    private final List<Circle> circles = new ArrayList<Circle>();
    public final SelectSetting colorMode = new SelectSetting("setting.jumpcircles.colormode.name", "setting.jumpcircles.colormode.desc").value("Sync", "Custom").selected("Sync");
    public final SelectSetting customColorsCount = new SelectSetting("setting.jumpcircles.colorcount.name", "setting.jumpcircles.colorcount.desc").value("Solo", "Duo", "Triple", "Quartet").selected("Solo").visible(() -> this.colorMode.isSelected("Custom"));
    public final MultiColorSetting customColors = new MultiColorSetting("setting.jumpcircles.gradientcolors.name", "setting.jumpcircles.gradientcolors.desc").colors("Color 1", "Color 2", "Color 3", "Color 4").defaultColors(-1499549, -13273872, -6596170, -409301).visible(() -> this.colorMode.isSelected("Custom"));
    public final SelectSetting colorAnimation = new SelectSetting("setting.jumpcircles.coloranimation.name", "setting.jumpcircles.coloranimation.desc").value("Wave", "Vertexes").selected("Wave").visible(() -> this.colorMode.isSelected("Custom"));
    private final SelectSetting circleTexture = new SelectSetting("setting.jumpcircles.circlestyle.name", "setting.jumpcircles.circlestyle.desc").value("Default", "Bold", "Portal", "Soup").selected("Default");
    public final SelectSetting animationType = new SelectSetting("setting.jumpcircles.animationtype.name", "setting.jumpcircles.animationtype.desc").value("Fade", "Scale", "Both").selected("Both");
    public final ValueSetting appearDuration = new ValueSetting("setting.jumpcircles.appearduration.name", "setting.jumpcircles.appearduration.desc").setValue(1.0f).range(0.1f, 3.0f);
    public final ValueSetting existDuration = new ValueSetting("setting.jumpcircles.existduration.name", "setting.jumpcircles.existduration.desc").setValue(1.5f).range(0.1f, 3.0f);
    public final ValueSetting disappearDuration = new ValueSetting("setting.jumpcircles.disappearduration.name", "setting.jumpcircles.disappearduration.desc").setValue(1.0f).range(0.1f, 3.0f);
    public final SelectSetting appearInterpolation = new SelectSetting("setting.jumpcircles.appearinterpolation.name", "setting.jumpcircles.appearinterpolation.desc").value(Interpolations.getAllNames()).selected("Bounce");
    public final SelectSetting disappearInterpolation = new SelectSetting("setting.jumpcircles.disappearinterpolation.name", "setting.jumpcircles.disappearinterpolation.desc").value(Interpolations.getAllNames()).selected("Smooth");
    public final ValueSetting rotateSpeed = new ValueSetting("setting.jumpcircles.rotatespeed.name", "setting.jumpcircles.rotatespeed.desc").setValue(2.0f).range(0.5f, 5.0f);
    public final ValueSetting circleScale = new ValueSetting("setting.jumpcircles.circlescale.name", "setting.jumpcircles.circlescale.desc").setValue(1.0f).range(0.5f, 3.0f);

    public static JumpCircles getInstance() {
        return Instance.get(JumpCircles.class);
    }

    public JumpCircles() {
        super("module.jumpcircles.name", ModuleCategory.VISUALS);
        GroupSetting colorGroup = new GroupSetting("group.jumpcircles.colors.name", "group.jumpcircles.colors.desc", false).settings(this.colorMode, this.customColorsCount, this.customColors, this.colorAnimation);
        GroupSetting appearanceGroup = new GroupSetting("group.jumpcircles.appearance.name", "group.jumpcircles.appearance.desc", false).settings(this.circleTexture, this.animationType);
        GroupSetting durationGroup = new GroupSetting("group.jumpcircles.duration.name", "group.jumpcircles.duration.desc", false).settings(this.appearDuration, this.existDuration, this.disappearDuration);
        GroupSetting animationGroup = new GroupSetting("group.jumpcircles.animation.name", "group.jumpcircles.animation.desc", false).settings(this.appearInterpolation, this.disappearInterpolation, this.rotateSpeed, this.circleScale);
        this.setup(colorGroup, appearanceGroup, durationGroup, animationGroup);
    }

    @Override
    public void deactivate() {
        this.circles.clear();
    }

    @EventHandler
    public void onJump(JumpEvent event) {
        class_1657 player = event.getPlayer();
        if (player == null) {
            return;
        }
        class_243 pos = new class_243(player.method_23317(), player.method_23318(), player.method_23321());
        this.circles.add(new Circle(pos, new StopWatch(), player));
    }

    @EventHandler
    public void onWorldRender(WorldRenderEvent e) {
        if (JumpCircles.mc.field_1687 == null || JumpCircles.mc.field_1724 == null) {
            return;
        }
        this.circles.removeIf(circle -> {
            double totalDuration;
            double elapsedSeconds = (double)circle.timer.elapsedTime() / 1000.0;
            return elapsedSeconds > (totalDuration = this.getTotalAnimationDuration());
        });
        if (this.circles.isEmpty()) {
            return;
        }
        for (Circle circle2 : this.circles) {
            circle2.updateRotation(this);
            circle2.updateAnimation(this);
            JumpCircleRenderer.renderCircle(circle2.pos, circle2.timer, circle2.rotationAngle, this, circle2.animation);
        }
    }

    public int[] getCustomColors() {
        int[] nArray;
        if (!this.colorMode.isSelected("Custom")) {
            return null;
        }
        switch (this.customColorsCount.getSelected()) {
            case "Solo": {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.customColors.getColor1().getColor();
                break;
            }
            case "Duo": {
                int[] nArray3 = new int[2];
                nArray3[0] = this.customColors.getColor1().getColor();
                nArray = nArray3;
                nArray3[1] = this.customColors.getColor2().getColor();
                break;
            }
            case "Triple": {
                int[] nArray4 = new int[3];
                nArray4[0] = this.customColors.getColor1().getColor();
                nArray4[1] = this.customColors.getColor2().getColor();
                nArray = nArray4;
                nArray4[2] = this.customColors.getColor3().getColor();
                break;
            }
            case "Quartet": {
                nArray = this.customColors.getColorValues();
                break;
            }
            default: {
                nArray = null;
            }
        }
        return nArray;
    }

    public double getTotalAnimationDuration() {
        return this.appearDuration.getValue() + this.existDuration.getValue() + this.disappearDuration.getValue();
    }

    public ThreeStageAnimation createAnimation() {
        return new ThreeStageAnimation(this.appearDuration.getValue(), this.existDuration.getValue(), this.disappearDuration.getValue(), Interpolations.getByName(this.appearInterpolation.getSelected()), Interpolations.getByName(this.disappearInterpolation.getSelected()));
    }

    public class_2960 getCircleTexture() {
        return switch (this.circleTexture.getSelected()) {
            case "Default" -> class_2960.method_60654((String)"textures/circles/circle.png");
            case "Bold" -> class_2960.method_60654((String)"textures/circles/circle_bold.png");
            case "Portal" -> class_2960.method_60654((String)"textures/circles/portal.png");
            case "Soup" -> class_2960.method_60654((String)"textures/circles/soup.png");
            default -> null;
        };
    }

    public List<Circle> getCircles() {
        return this.circles;
    }

    public SelectSetting getColorMode() {
        return this.colorMode;
    }

    public SelectSetting getCustomColorsCount() {
        return this.customColorsCount;
    }

    public SelectSetting getColorAnimation() {
        return this.colorAnimation;
    }

    public SelectSetting getAnimationType() {
        return this.animationType;
    }

    public ValueSetting getAppearDuration() {
        return this.appearDuration;
    }

    public ValueSetting getExistDuration() {
        return this.existDuration;
    }

    public ValueSetting getDisappearDuration() {
        return this.disappearDuration;
    }

    public SelectSetting getAppearInterpolation() {
        return this.appearInterpolation;
    }

    public SelectSetting getDisappearInterpolation() {
        return this.disappearInterpolation;
    }

    public ValueSetting getRotateSpeed() {
        return this.rotateSpeed;
    }

    public ValueSetting getCircleScale() {
        return this.circleScale;
    }

    private static class Circle {
        final class_243 pos;
        final StopWatch timer;
        final class_1657 player;
        float rotationAngle;
        final float angularVelocity;
        long lastUpdateTime;
        ThreeStageAnimation animation;

        Circle(class_243 pos, StopWatch timer, class_1657 player) {
            this.pos = pos;
            this.timer = timer;
            this.player = player;
            this.rotationAngle = 0.0f;
            this.angularVelocity = (float)(Math.random() * 2.0 + 1.0);
            this.lastUpdateTime = System.currentTimeMillis();
        }

        void updateAnimation(JumpCircles module) {
            if (this.animation == null) {
                this.animation = module.createAnimation();
            }
        }

        void updateRotation(JumpCircles module) {
            long currentTime = System.currentTimeMillis();
            float deltaTime = (float)(currentTime - this.lastUpdateTime) / 1000.0f;
            this.lastUpdateTime = currentTime;
            deltaTime = Math.min(deltaTime, 0.1f);
            double elapsedSeconds = (double)this.timer.elapsedTime() / 1000.0;
            if (this.animation != null) {
                ThreeStageAnimation.AnimationStage stage = this.animation.getStage(elapsedSeconds);
                float frameTime = 0.016666668f;
                float normalizedDelta = deltaTime / frameTime;
                switch (stage) {
                    case APPEAR: {
                        this.rotationAngle -= this.angularVelocity * normalizedDelta * module.rotateSpeed.getValue();
                        break;
                    }
                    case EXIST: {
                        this.rotationAngle -= this.angularVelocity * normalizedDelta * module.rotateSpeed.getValue();
                        break;
                    }
                    case DISAPPEAR: {
                        double disappearProgress = (elapsedSeconds - this.animation.getAppearDuration() - this.animation.getExistDuration()) / this.animation.getDisappearDuration();
                        float fadeFactor = (float)(1.0 - disappearProgress);
                        this.rotationAngle -= this.angularVelocity * normalizedDelta * fadeFactor * module.rotateSpeed.getValue();
                        break;
                    }
                }
            }
        }
    }
}

