/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.features.modules.visuals;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import padej.soup.api.event.EventHandler;
import padej.soup.api.feature.module.ITargetRenderModule;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleCategory;
import padej.soup.api.feature.module.setting.implement.BooleanSetting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.base.util.entity.VisibleUtils;
import padej.soup.base.util.math.ProjectionUtil;
import padej.soup.base.util.other.Instance;
import padej.soup.base.util.render.TargetRenderer;
import padej.soup.implement.events.player.TickEvent;
import padej.soup.implement.events.render.WorldRenderEvent;
import padej.soup.implement.features.modules.particles.render.ParticleBatchRenderer;
import padej.soup.implement.features.modules.visuals.FriendsTargetRender;

public class TargetRender
extends Module
implements ITargetRenderModule {
    private class_1309 targetEntity;
    private class_1309 lastTargetEntity;
    private long lastTargetTime;
    private final Animation animation = new DecelerateAnimation().setMs(500).setValue(1.0);
    private final SelectSetting colorMode = new SelectSetting("setting.targetrender.colormode.name", "setting.targetrender.colormode.desc").value("Sync", "Custom").selected("Sync");
    private final SelectSetting customColorsCount = new SelectSetting("setting.targetrender.colorcount.name", "setting.targetrender.colorcount.desc").value("Solo", "Duo", "Triple", "Quartet").selected("Solo").visible(() -> this.colorMode.isSelected("Custom"));
    private final MultiColorSetting customColors = new MultiColorSetting("setting.targetrender.gradientcolors.name", "setting.targetrender.gradientcolors.desc").colors("Color 1", "Color 2", "Color 3", "Color 4").defaultColors(-1499549, -13273872, -6596170, -409301).visible(() -> this.colorMode.isSelected("Custom"));
    private final SelectSetting targetRenderType = new SelectSetting("setting.targetrender.rendertype.name", "setting.targetrender.rendertype.desc").value("Legacy", "Circle", "Ghosts").selected("Legacy");
    private final SelectSetting legacyTexture = new SelectSetting("setting.targetrender.legacytexture.name", "setting.targetrender.legacytexture.desc").value("Amogus", "Bo", "Capture", "Jeka", "Marker", "Scifi", "Simple", "Skull", "Vegas", "Rockfly").selected("Capture");
    private final BooleanSetting optimalAim = new BooleanSetting("setting.targetrender.optimalaim.name", "setting.targetrender.optimalaim.desc").setValue(false);
    private final BooleanSetting staticMode = new BooleanSetting("setting.targetrender.staticmode.name", "setting.targetrender.staticmode.desc").setValue(false);
    private final ValueSetting legacySize = new ValueSetting("setting.targetrender.legacysize.name", "setting.targetrender.legacysize.desc").setValue(1.0f).range(0.5f, 1.5f);
    private final SelectSetting ghostsTexture = new SelectSetting("setting.targetrender.ghoststexture.name", "setting.targetrender.ghoststexture.desc").value("Bloom", "Soft").selected("Soft");
    private final SelectSetting ghostsBlend = new SelectSetting("setting.targetrender.ghostsblend.name", "setting.targetrender.ghostsblend.desc").value("Smoke", "Plasma").selected("Plasma");
    private final ValueSetting ghostsLength = new ValueSetting("setting.targetrender.ghostslength.name", "setting.targetrender.ghostslength.desc").setValue(1.3f).range(0.5f, 1.5f);
    private final SelectSetting ghostsTrajectory = new SelectSetting("setting.targetrender.ghoststrajectory.name", "setting.targetrender.ghoststrajectory.desc").value("Standard", "Spiral", "Atomic").selected("Standard");
    private final ValueSetting ghostsRadiusModifier = new ValueSetting("setting.targetrender.ghostsradiusmodifier.name", "setting.targetrender.ghostsradiusmodifier.desc").setValue(1.6f).range(0.5f, 2.0f);
    private final ValueSetting ghostsEndSize = new ValueSetting("setting.targetrender.ghostsstartsize.name", "setting.targetrender.ghostsstartsize.desc").setValue(0.1f).range(0.1f, 1.0f);
    private final ValueSetting ghostsStartSize = new ValueSetting("setting.targetrender.ghostsendsize.name", "setting.targetrender.ghostsendsize.desc").setValue(0.7f).range(0.1f, 1.0f);
    private final ValueSetting ghostsCount = new ValueSetting("setting.targetrender.ghostscount.name", "setting.targetrender.ghostscount.desc").setValue(4.0f).range(1, 8);
    private final ValueSetting ghostsSubdivision = new ValueSetting("setting.targetrender.ghostssubdivision.name", "setting.targetrender.ghostssubdivision.desc").setValue(5.0f).range(1, 8);
    private final ValueSetting followTime = new ValueSetting("setting.targetrender.followtime.name", "setting.targetrender.followtime.desc").setValue(0.0f).range(0, 10);
    private final ValueSetting speedMod = new ValueSetting("setting.targetrender.speedmod.name", "setting.targetrender.speedmod.desc").setValue(0.5f).range(0.5f, 2.0f);
    private final ValueSetting maxDistance = new ValueSetting("setting.targetrender.maxdistance.name", "setting.targetrender.maxdistance.desc").setValue(64.0f).range(16.0f, 128.0f);

    public static TargetRender getInstance() {
        return Instance.get(TargetRender.class);
    }

    public TargetRender() {
        super("module.targetrender.name", ModuleCategory.VISUALS, true, false);
        GroupSetting colorGroup = new GroupSetting("group.targetrender.colors.name", "group.targetrender.colors.desc", false).settings(this.colorMode, this.customColorsCount, this.customColors);
        GroupSetting legacyGroup = new GroupSetting("group.targetrender.legacy.name", "group.targetrender.legacy.desc", false).settings(this.legacyTexture, this.optimalAim, this.staticMode, this.legacySize).visible(() -> this.targetRenderType.isSelected("Legacy"));
        GroupSetting ghostsVisualGroup = new GroupSetting("group.targetrender.ghosts.visual.name", "group.targetrender.ghosts.visual.desc", false).settings(this.ghostsTexture, this.ghostsBlend);
        GroupSetting ghostsAnimationGroup = new GroupSetting("group.targetrender.ghosts.animation.name", "group.targetrender.ghosts.animation.desc", false).settings(this.ghostsLength, this.ghostsTrajectory);
        GroupSetting ghostsSizeGroup = new GroupSetting("group.targetrender.ghosts.size.name", "group.targetrender.ghosts.size.desc", false).settings(this.ghostsRadiusModifier, this.ghostsStartSize, this.ghostsEndSize, this.ghostsCount, this.ghostsSubdivision);
        GroupSetting ghostsGroup = new GroupSetting("group.targetrender.ghosts.name", "group.targetrender.ghosts.desc", false).settings(ghostsVisualGroup, ghostsAnimationGroup, ghostsSizeGroup).visible(() -> this.targetRenderType.isSelected("Ghosts"));
        GroupSetting behaviorGroup = new GroupSetting("group.targetrender.behavior.name", "group.targetrender.behavior.desc", false).settings(this.followTime, this.speedMod, this.maxDistance);
        this.setup(colorGroup, this.targetRenderType, legacyGroup, ghostsGroup, behaviorGroup);
    }

    @Override
    public void deactivate() {
        this.targetEntity = null;
        this.lastTargetEntity = null;
        this.lastTargetTime = 0L;
    }

    @EventHandler
    public void onWorldRender(WorldRenderEvent e) {
        boolean shouldRender;
        if (this.shouldSkipDueToPriority()) {
            return;
        }
        boolean bl = shouldRender = this.targetEntity != null && VisibleUtils.canBeTargeted(this.targetEntity) && ProjectionUtil.canSeeEntity((class_1297)this.targetEntity);
        if (this.targetEntity == null && this.lastTargetEntity != null) {
            long followTimeMs;
            long currentTime = System.currentTimeMillis();
            boolean bl2 = shouldRender = currentTime - this.lastTargetTime < (followTimeMs = (long)(this.followTime.getValue() * 1000.0f)) && VisibleUtils.canBeTargeted(this.lastTargetEntity) && ProjectionUtil.canSeeEntity((class_1297)this.lastTargetEntity);
            if (this.lastTargetEntity.method_29504() || !this.lastTargetEntity.method_5805()) {
                shouldRender = false;
            }
        }
        this.animation.setDirection(shouldRender ? Direction.FORWARDS : Direction.BACKWARDS);
        float animationDelta = this.animation.getOutput().floatValue();
        if (this.targetEntity != null) {
            this.lastTargetEntity = this.targetEntity;
        }
        if (this.lastTargetEntity == null || this.animation.isFinished(Direction.BACKWARDS)) {
            return;
        }
        float tickDelta = tickCounter.method_60637(false);
        float red = class_3532.method_15363((float)(((float)this.lastTargetEntity.field_6235 - tickDelta) / 10.0f), (float)0.0f, (float)1.0f);
        switch (this.targetRenderType.getSelected()) {
            case "Legacy": {
                TargetRenderer.drawLegacy(this.lastTargetEntity, animationDelta, red, this);
                break;
            }
            case "Circle": {
                TargetRenderer.drawCircle(e.getStack(), this.lastTargetEntity, animationDelta, red, this);
                break;
            }
            case "Ghosts": {
                TargetRenderer.drawGhosts(this.lastTargetEntity, animationDelta, red, this.speedMod.getValue(), this.ghostsLength.getValue(), this.ghostsRadiusModifier.getValue(), this.ghostsStartSize.getValue(), this.ghostsEndSize.getValue(), this.ghostsSubdivision.getValue(), this);
                ParticleBatchRenderer.renderBatches();
            }
        }
    }

    @EventHandler
    public void onTick(TickEvent e) {
        class_1309 entity;
        class_3966 entityHit;
        class_1297 class_12972;
        class_1309 previousTarget = this.targetEntity;
        class_239 class_2392 = TargetRender.mc.field_1765;
        this.targetEntity = class_2392 instanceof class_3966 ? ((class_12972 = (entityHit = (class_3966)class_2392).method_17782()) instanceof class_1309 && !(entity = (class_1309)class_12972).method_29504() && entity.method_5805() ? (VisibleUtils.canBeTargeted(entity) && TargetRender.mc.field_1724.method_5739((class_1297)entity) <= this.maxDistance.getValue() ? entity : null) : null) : null;
        if (this.targetEntity != null && (this.targetEntity.method_29504() || !this.targetEntity.method_5805())) {
            this.targetEntity = null;
            if (previousTarget != null) {
                this.lastTargetTime = System.currentTimeMillis();
            }
        }
        if (previousTarget != null && this.targetEntity == null) {
            this.lastTargetTime = System.currentTimeMillis();
        }
        TargetRenderer.updateAnimations(this.speedMod.getValue());
    }

    @Override
    public int[] getCustomColors() {
        int[] nArray;
        if (!this.colorMode.isSelected("Custom")) {
            return null;
        }
        switch (this.customColorsCount.getSelected()) {
            case "Solo": {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.customColors.getColor1().getColor();
                break;
            }
            case "Duo": {
                int[] nArray3 = new int[2];
                nArray3[0] = this.customColors.getColor1().getColor();
                nArray = nArray3;
                nArray3[1] = this.customColors.getColor2().getColor();
                break;
            }
            case "Triple": {
                int[] nArray4 = new int[3];
                nArray4[0] = this.customColors.getColor1().getColor();
                nArray4[1] = this.customColors.getColor2().getColor();
                nArray = nArray4;
                nArray4[2] = this.customColors.getColor3().getColor();
                break;
            }
            case "Quartet": {
                nArray = this.customColors.getColorValues();
                break;
            }
            default: {
                nArray = null;
            }
        }
        return nArray;
    }

    @Override
    public boolean isOptimalAim() {
        return this.optimalAim.isValue();
    }

    @Override
    public boolean isStaticMode() {
        return this.staticMode.isValue();
    }

    @Override
    public float getLegacySize() {
        return this.legacySize.getValue();
    }

    @Override
    public class_2960 getGhostTexture() {
        return switch (this.ghostsTexture.getSelected()) {
            case "Bloom" -> class_2960.method_60654((String)"textures/particles/bloom/bloom.png");
            case "Soft" -> class_2960.method_60654((String)"textures/particles/bloom/bloom_soft.png");
            default -> null;
        };
    }

    @Override
    public class_2960 getLegacyTexture() {
        return switch (this.legacyTexture.getSelected()) {
            case "Amogus" -> class_2960.method_60654((String)"textures/legacy/amongus.png");
            case "Bo" -> class_2960.method_60654((String)"textures/legacy/bo.png");
            case "Capture" -> class_2960.method_60654((String)"textures/legacy/capture.png");
            case "Jeka" -> class_2960.method_60654((String)"textures/legacy/jeka.png");
            case "Marker" -> class_2960.method_60654((String)"textures/legacy/marker.png");
            case "Scifi" -> class_2960.method_60654((String)"textures/legacy/scifi.png");
            case "Simple" -> class_2960.method_60654((String)"textures/legacy/simple.png");
            case "Skull" -> class_2960.method_60654((String)"textures/legacy/skull.png");
            case "Vegas" -> class_2960.method_60654((String)"textures/legacy/vegas.png");
            case "Rockfly" -> class_2960.method_60654((String)"textures/legacy/rockfly.png");
            default -> null;
        };
    }

    private boolean shouldSkipDueToPriority() {
        FriendsTargetRender friendsTargetRender = FriendsTargetRender.getInstance();
        if (friendsTargetRender == null || !friendsTargetRender.isEnabled()) {
            return false;
        }
        if (this.targetEntity == null) {
            return false;
        }
        boolean friendTargetingSame = friendsTargetRender.isFriendTargeting(this.targetEntity);
        if (!friendTargetingSame) {
            return false;
        }
        String priority = friendsTargetRender.getRenderPriority().getSelected();
        return "Friend".equals(priority);
    }

    public class_1309 getTargetEntity() {
        return this.targetEntity;
    }

    public class_1309 getLastTargetEntity() {
        return this.lastTargetEntity;
    }

    public long getLastTargetTime() {
        return this.lastTargetTime;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    public SelectSetting getColorMode() {
        return this.colorMode;
    }

    public SelectSetting getCustomColorsCount() {
        return this.customColorsCount;
    }

    public SelectSetting getTargetRenderType() {
        return this.targetRenderType;
    }

    public BooleanSetting getOptimalAim() {
        return this.optimalAim;
    }

    public BooleanSetting getStaticMode() {
        return this.staticMode;
    }

    public SelectSetting getGhostsTexture() {
        return this.ghostsTexture;
    }

    @Override
    public SelectSetting getGhostsBlend() {
        return this.ghostsBlend;
    }

    public ValueSetting getGhostsLength() {
        return this.ghostsLength;
    }

    @Override
    public SelectSetting getGhostsTrajectory() {
        return this.ghostsTrajectory;
    }

    public ValueSetting getGhostsRadiusModifier() {
        return this.ghostsRadiusModifier;
    }

    public ValueSetting getGhostsEndSize() {
        return this.ghostsEndSize;
    }

    public ValueSetting getGhostsStartSize() {
        return this.ghostsStartSize;
    }

    @Override
    public ValueSetting getGhostsCount() {
        return this.ghostsCount;
    }

    public ValueSetting getGhostsSubdivision() {
        return this.ghostsSubdivision;
    }

    public ValueSetting getFollowTime() {
        return this.followTime;
    }

    public ValueSetting getSpeedMod() {
        return this.speedMod;
    }

    public ValueSetting getMaxDistance() {
        return this.maxDistance;
    }
}

