/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.other;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import padej.soup.api.system.activity.ActivityData;
import padej.soup.api.system.activity.ActivityManager;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.localization.LocalizationManager;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.implement.menu.components.AbstractComponent;

public class ActivityCalendarComponent
extends AbstractComponent {
    private final ActivityManager activityManager;
    private final float CELL_SIZE = 4.0f;
    private final float CELL_SPACING = 1.15f;
    private int weeksToShow;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final DateTimeFormatter TOOLTIP_DATE_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final float[] INTENSITY_LEVELS = new float[]{0.0f, 0.25f, 0.4f, 0.6f, 0.85f};
    private long cachedMaxActivity = -1L;
    private LocalDate cachedStatsDate = null;
    private Map<String, ActivityData> cachedCalendarData = null;
    private LocalDate cachedCalendarDate = null;
    private LocalDate cachedStartDate = null;
    private LocalDate cachedEndDate = null;
    private String[] cachedDateStrings = null;
    private LocalDate[] cachedDates = null;
    public String hoveredDate = null;
    public ActivityData hoveredActivity = null;

    public ActivityCalendarComponent(ActivityManager activityManager) {
        this.activityManager = activityManager;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrix = context.method_51448();
        this.renderCalendarGrid(context, mouseX, mouseY);
        String totalTime = this.activityManager.getFormattedTotalPlayTime();
        Fonts.getSize(12).drawString(matrix, LocalizationManager.getInstance().get("ui.total_playtime").replace("%s", totalTime), this.x + 4.0f, this.y + 55.0f, ColorUtil.getDescription());
    }

    private void renderCalendarGrid(class_332 context, int mouseX, int mouseY) {
        LocalDate currentDate;
        class_4587 matrix = context.method_51448();
        LocalDate today = LocalDate.now();
        this.weeksToShow = 52;
        LocalDate startDate = today.minusWeeks(this.weeksToShow - 1);
        while (startDate.getDayOfWeek() != DayOfWeek.SUNDAY) {
            startDate = startDate.minusDays(1L);
        }
        if (!(this.cachedStatsDate != null && this.cachedStatsDate.equals(today) && this.cachedCalendarDate != null && this.cachedCalendarDate.equals(today) && this.cachedStartDate != null && this.cachedStartDate.equals(startDate))) {
            this.cachedMaxActivity = this.calculateYearlyMaxActivity(today);
            this.cachedStatsDate = today;
            this.cachedCalendarData = new HashMap<String, ActivityData>();
            this.cachedCalendarDate = today;
            this.cachedStartDate = startDate;
            this.cachedEndDate = today;
            int totalDays = this.weeksToShow * 7;
            this.cachedDates = new LocalDate[totalDays];
            this.cachedDateStrings = new String[totalDays];
            LocalDate date = startDate;
            for (int index = 0; !date.isAfter(today) && index < totalDays; ++index) {
                this.cachedDates[index] = date;
                this.cachedDateStrings[index] = date.format(DATE_FORMATTER);
                ActivityData activity = this.activityManager.getActivityForDate(this.cachedDateStrings[index]);
                this.cachedCalendarData.put(this.cachedDateStrings[index], activity);
                date = date.plusDays(1L);
            }
        }
        float calendarX = this.x + 15.0f;
        float calendarY = this.y + 15.0f;
        String[] dayLabelKeys = new String[]{"", "calendar.day.mon", "", "calendar.day.wed", "", "calendar.day.fri", ""};
        for (int day = 0; day < 7; ++day) {
            if (dayLabelKeys[day].isEmpty()) continue;
            String dayLabel = LocalizationManager.getInstance().get(dayLabelKeys[day]);
            Fonts.getSize(8).drawString(matrix, dayLabel, calendarX - 12.0f, calendarY + (float)day * 5.15f + 2.0f, ColorUtil.getDescription());
        }
        this.renderMonthLabels(matrix, startDate, calendarX, calendarY - 10.0f);
        this.hoveredDate = null;
        this.hoveredActivity = null;
        float cellSpacingTotal = 5.15f;
        boolean hasActiveSession = this.activityManager.getSessionStartTime() > 0L;
        int baseRectColor = ColorUtil.getRectDarker(1.0f);
        int accentColor = ColorUtil.getClientColor();
        int validDays = this.cachedDates != null ? this.cachedDates.length : 0;
        for (int i = 0; i < validDays && (currentDate = this.cachedDates[i]) != null && !currentDate.isAfter(today); ++i) {
            boolean isHovered;
            int week = i / 7;
            int day = i % 7;
            float cellX = calendarX + (float)week * cellSpacingTotal;
            float cellY = calendarY + (float)day * cellSpacingTotal;
            String dateString = this.cachedDateStrings[i];
            ActivityData activity = this.cachedCalendarData.getOrDefault(dateString, new ActivityData(dateString));
            if (currentDate.equals(today) && hasActiveSession) {
                activity = this.getCurrentDayActivityWithSession(dateString, activity);
            }
            if (isHovered = MathUtil.isHovered(mouseX, mouseY, cellX, cellY, 4.0, 4.0)) {
                this.hoveredDate = dateString;
                this.hoveredActivity = activity;
            }
            int color = this.getIntensityColorOptimized(activity, isHovered, baseRectColor, accentColor);
            rectangle.render(ShapeProperties.create(matrix, cellX, cellY, 4.0, 4.0).round(1.0f).color(color).build());
        }
        this.renderLegend(context, calendarX + 103.5f, calendarY + 36.05f + 5.0f);
    }

    private void renderLegend(class_332 context, float legendX, float legendY) {
        class_4587 matrix = context.method_51448();
        String lessText = LocalizationManager.getInstance().get("ui.less");
        String moreText = LocalizationManager.getInstance().get("ui.more");
        float lessTextWidth = Fonts.getSize(8).getStringWidth(lessText);
        float moreTextWidth = Fonts.getSize(8).getStringWidth(moreText);
        float squaresWidth = 24.0f;
        float totalWidth = lessTextWidth + 5.0f + squaresWidth + 5.0f + moreTextWidth;
        float startX = legendX + ((float)this.weeksToShow * 5.15f - totalWidth) / 2.0f;
        Fonts.getSize(8).drawString(matrix, lessText, startX, legendY, ColorUtil.getDescription());
        float squareStartX = startX + lessTextWidth + 5.0f;
        for (int i = 0; i <= 4; ++i) {
            int color;
            float cellX = squareStartX + (float)i * 5.0f;
            int baseRectColor = ColorUtil.getRectDarker(1.0f);
            int accentColor = ColorUtil.getClientColor();
            if (i == 0) {
                color = baseRectColor;
            } else {
                float intensity = INTENSITY_LEVELS[i];
                color = ColorUtil.overCol(baseRectColor, accentColor, intensity);
            }
            rectangle.render(ShapeProperties.create(matrix, cellX, legendY - 2.0f, 4.0, 4.0).round(1.0f).color(color).build());
        }
        float moreX = squareStartX + squaresWidth + 5.0f;
        Fonts.getSize(8).drawString(matrix, moreText, moreX, legendY, ColorUtil.getDescription());
    }

    public void renderTooltip(class_332 context, int mouseX, int mouseY) {
        class_4587 matrix = context.method_51448();
        String dateText = this.formatDateForTooltip(this.hoveredDate);
        String timeText = this.formatPlayTimeForTooltip(this.hoveredActivity.getTotalPlayTime());
        int textWidth = (int)Math.max(Fonts.getSize(12).getStringWidth(dateText), Fonts.getSize(11).getStringWidth(timeText));
        int tooltipWidth = textWidth + 12;
        int tooltipHeight = 26;
        int tooltipX = mouseX + 10;
        int tooltipY = mouseY - tooltipHeight - 10;
        if (tooltipX + tooltipWidth > window.method_4486()) {
            tooltipX = mouseX - tooltipWidth - 10;
        }
        if (tooltipY < 0) {
            tooltipY = mouseY + 20;
        }
        rectangle.render(ShapeProperties.create(matrix, tooltipX, tooltipY, tooltipWidth, tooltipHeight).round(4.0f).color(ColorUtil.getGuiRectColor(0.9f)).thickness(2.0f).outlineColor(ColorUtil.getOutline()).build());
        int dateCenterX = tooltipX + (tooltipWidth - (int)Fonts.getSize(12).getStringWidth(dateText)) / 2;
        int timeCenterX = tooltipX + (tooltipWidth - (int)Fonts.getSize(11).getStringWidth(timeText)) / 2;
        Fonts.getSize(12, Fonts.Type.INTER_BOLD).drawString(matrix, dateText, dateCenterX, tooltipY + 6, ColorUtil.getDescription());
        Fonts.getSize(11).drawString(matrix, timeText, timeCenterX, tooltipY + 18, ColorUtil.getText());
    }

    private int getIntensityColorOptimized(ActivityData activity, boolean hovered, int baseRectColor, int accentColor) {
        int baseColor;
        int level = this.getRelativeIntensityLevel(activity);
        if (level == 0) {
            baseColor = baseRectColor;
        } else {
            float intensity = INTENSITY_LEVELS[Math.max(0, Math.min(4, level))];
            baseColor = ColorUtil.overCol(baseRectColor, accentColor, intensity);
        }
        if (hovered) {
            baseColor = ColorUtil.lighter(baseColor, 2);
        }
        return baseColor;
    }

    private int getIntensityColor(ActivityData activity, boolean hovered) {
        return this.getIntensityColorOptimized(activity, hovered, ColorUtil.getRectDarker(1.0f), ColorUtil.getClientColor());
    }

    private int getRelativeIntensityLevel(ActivityData activity) {
        if (activity.getTotalPlayTime() == 0L) {
            return 0;
        }
        if (this.cachedMaxActivity == 0L) {
            return 0;
        }
        long currentScore = activity.getTotalPlayTime() / 60000L + (long)activity.getSessionsCount() * 5L;
        double intensity = (double)currentScore / (double)this.cachedMaxActivity;
        if (intensity <= 0.0) {
            return 0;
        }
        if (intensity <= 0.25) {
            return 1;
        }
        if (intensity <= 0.5) {
            return 2;
        }
        if (intensity <= 0.75) {
            return 3;
        }
        return 4;
    }

    private long calculateYearlyMaxActivity(LocalDate today) {
        LocalDate startDate;
        long maxActivity = 0L;
        LocalDate date = startDate = today.minusYears(1L);
        while (!date.isAfter(today)) {
            String dateString = date.format(DATE_FORMATTER);
            ActivityData dayActivity = this.activityManager.getActivityForDate(dateString);
            if (dayActivity.getTotalPlayTime() > 0L) {
                long dayScore = dayActivity.getTotalPlayTime() / 60000L + (long)dayActivity.getSessionsCount() * 5L;
                maxActivity = Math.max(maxActivity, dayScore);
            }
            date = date.plusDays(1L);
        }
        return maxActivity;
    }

    private String formatDateForTooltip(String dateString) {
        LocalDate date = LocalDate.parse(dateString);
        return date.format(TOOLTIP_DATE_FORMATTER);
    }

    private String formatPlayTimeForTooltip(long playTimeMs) {
        if (playTimeMs == 0L) {
            return LocalizationManager.getInstance().get("calendar.no_activity");
        }
        long hours = playTimeMs / 3600000L;
        long minutes = playTimeMs % 3600000L / 60000L;
        if (hours > 0L) {
            return String.format(LocalizationManager.getInstance().get("calendar.hours_minutes_played"), hours, minutes);
        }
        return String.format(LocalizationManager.getInstance().get("calendar.minutes_played"), minutes);
    }

    private void renderMonthLabels(class_4587 matrix, LocalDate startDate, float calendarX, float monthLabelY) {
        LocalDate currentMonth = null;
        for (int week = 0; week < this.weeksToShow; ++week) {
            LocalDate weekStart = startDate.plusWeeks(week);
            if (currentMonth != null && weekStart.getMonth().equals(currentMonth.getMonth()) && weekStart.getYear() == currentMonth.getYear()) continue;
            currentMonth = weekStart;
            String monthKey = "calendar.month." + weekStart.getMonth().name().substring(0, 3).toLowerCase();
            String monthName = LocalizationManager.getInstance().get(monthKey);
            Fonts.getSize(8).drawString(matrix, monthName, calendarX + (float)week * 5.15f, monthLabelY + 5.0f, ColorUtil.getDescription());
        }
    }

    private ActivityData getCurrentDayActivityWithSession(String dateString, ActivityData activity) {
        long sessionStart = this.activityManager.getSessionStartTime();
        if (sessionStart > 0L) {
            long currentTime = System.currentTimeMillis();
            long currentSessionTime = currentTime - sessionStart;
            ActivityData currentActivity = new ActivityData(dateString);
            currentActivity.setTotalPlayTime(activity.getTotalPlayTime() + currentSessionTime);
            currentActivity.setSessionsCount(activity.getSessionsCount() + 1);
            currentActivity.setLoginTime(activity.getLoginTime() != 0L ? activity.getLoginTime() : sessionStart);
            currentActivity.setLogoutTime(currentTime);
            return currentActivity;
        }
        return activity;
    }

    public ActivityCalendarComponent setWeeksToShow(int weeksToShow) {
        this.weeksToShow = weeksToShow;
        return this;
    }

    public ActivityCalendarComponent setCachedMaxActivity(long cachedMaxActivity) {
        this.cachedMaxActivity = cachedMaxActivity;
        return this;
    }

    public ActivityCalendarComponent setCachedStatsDate(LocalDate cachedStatsDate) {
        this.cachedStatsDate = cachedStatsDate;
        return this;
    }

    public ActivityCalendarComponent setCachedCalendarData(Map<String, ActivityData> cachedCalendarData) {
        this.cachedCalendarData = cachedCalendarData;
        return this;
    }

    public ActivityCalendarComponent setCachedCalendarDate(LocalDate cachedCalendarDate) {
        this.cachedCalendarDate = cachedCalendarDate;
        return this;
    }

    public ActivityCalendarComponent setCachedStartDate(LocalDate cachedStartDate) {
        this.cachedStartDate = cachedStartDate;
        return this;
    }

    public ActivityCalendarComponent setCachedEndDate(LocalDate cachedEndDate) {
        this.cachedEndDate = cachedEndDate;
        return this;
    }

    public ActivityCalendarComponent setCachedDateStrings(String[] cachedDateStrings) {
        this.cachedDateStrings = cachedDateStrings;
        return this;
    }

    public ActivityCalendarComponent setCachedDates(LocalDate[] cachedDates) {
        this.cachedDates = cachedDates;
        return this;
    }

    public ActivityCalendarComponent setHoveredDate(String hoveredDate) {
        this.hoveredDate = hoveredDate;
        return this;
    }

    public ActivityCalendarComponent setHoveredActivity(ActivityData hoveredActivity) {
        this.hoveredActivity = hoveredActivity;
        return this;
    }
}

