/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.other;

import java.util.ArrayList;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleDescription;
import padej.soup.api.feature.module.setting.Setting;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.implement.menu.MenuScreen;
import padej.soup.implement.menu.components.AbstractComponent;

public class ModuleDescriptionComponent
extends AbstractComponent {
    private Module hoveredModule = null;
    private Setting hoveredSetting = null;
    private String description = "";
    private boolean visible = false;

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.description.isEmpty() || !this.visible) {
            return;
        }
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        float maxWidth = 300.0f;
        float lineHeight = 4.0f;
        int fontSize = 16;
        String[] lines = this.wrapText(this.description, maxWidth);
        float textWidth = 0.0f;
        for (String line : lines) {
            float lineWidth = Fonts.getSize(fontSize).getStringWidth(line);
            textWidth = Math.max(textWidth, lineWidth);
        }
        float padding = 4.0f;
        float boxWidth = textWidth + padding * 2.0f;
        float boxHeight = (float)lines.length * lineHeight + padding * 2.0f;
        int menuX = MenuScreen.INSTANCE.x;
        int menuY = MenuScreen.INSTANCE.y;
        int menuWidth = MenuScreen.INSTANCE.width;
        float boxX = (float)menuX + (float)menuWidth / 2.0f - boxWidth / 2.0f;
        float topY = (float)menuY - boxHeight - 10.0f;
        float bottomY = menuY + 238;
        float boxY = topY >= 10.0f ? topY : bottomY;
        boxX = Math.max(10.0f, Math.min(boxX, (float)screenWidth - boxWidth - 10.0f));
        boxY = Math.max(10.0f, Math.min(boxY, (float)screenHeight - boxHeight - 10.0f));
        class_4587 matrices = context.method_51448();
        rectangle.render(ShapeProperties.create(matrices, boxX, boxY, boxWidth, boxHeight).round(4.0f).softness(1.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getGuiRectColor(0.5f)).build());
        int textColor = ColorUtil.getText();
        float textX = boxX + padding;
        float textY = boxY + padding;
        for (String line : lines) {
            Fonts.getSize(fontSize).drawString(matrices, line, textX, textY - 0.5f, textColor);
            textY += lineHeight;
        }
    }

    public void setHoveredModule(Module module) {
        if (module != null) {
            String moduleDescription = ModuleDescription.getDescription(module);
            if (!moduleDescription.isEmpty()) {
                this.hoveredModule = module;
                this.hoveredSetting = null;
                this.description = moduleDescription;
                this.visible = true;
            } else {
                this.hoveredModule = null;
                this.hoveredSetting = null;
                this.description = "";
                this.visible = false;
            }
        } else {
            this.hoveredModule = null;
            this.hoveredSetting = null;
            this.description = "";
            this.visible = false;
        }
    }

    public void setHoveredSetting(Setting setting) {
        if (setting != null) {
            String settingDescription = setting.getLocalizedDescription();
            if (settingDescription != null && !settingDescription.isEmpty()) {
                this.hoveredModule = null;
                this.hoveredSetting = setting;
                this.description = settingDescription;
                this.visible = true;
            } else {
                this.hoveredModule = null;
                this.hoveredSetting = null;
                this.description = "";
                this.visible = false;
            }
        } else {
            this.hoveredModule = null;
            this.hoveredSetting = null;
            this.description = "";
            this.visible = false;
        }
    }

    public void setHoveredSettingDescription(String descriptionKey) {
        if (descriptionKey != null && !descriptionKey.isEmpty()) {
            String settingDescription = ModuleDescription.getDescription(descriptionKey);
            if (!settingDescription.isEmpty()) {
                this.hoveredModule = null;
                this.hoveredSetting = null;
                this.description = settingDescription;
                this.visible = true;
            } else {
                this.hoveredModule = null;
                this.hoveredSetting = null;
                this.description = "";
                this.visible = false;
            }
        } else {
            this.hoveredModule = null;
            this.hoveredSetting = null;
            this.description = "";
            this.visible = false;
        }
    }

    public void hide() {
        this.visible = false;
        this.hoveredModule = null;
        this.hoveredSetting = null;
        this.description = "";
    }

    private String[] wrapText(String text, float maxWidth) {
        if (text.isEmpty()) {
            return new String[0];
        }
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        ArrayList<String> lines = new ArrayList<String>();
        for (String word : words) {
            String testLine = !currentLine.isEmpty() ? String.valueOf(currentLine) + " " + word : word;
            float lineWidth = Fonts.getSize(16).getStringWidth(testLine);
            if (lineWidth <= maxWidth) {
                currentLine = new StringBuilder(testLine);
                continue;
            }
            if (!currentLine.isEmpty()) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine.toString());
        }
        return lines.toArray(new String[0]);
    }

    public Module getHoveredModule() {
        return this.hoveredModule;
    }

    public Setting getHoveredSetting() {
        return this.hoveredSetting;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

