/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.settings;

import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_9848;
import padej.soup.api.feature.module.setting.implement.BindSetting;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.other.StringUtil;
import padej.soup.implement.menu.components.implement.settings.AbstractSettingComponent;
import padej.soup.implement.menu.components.implement.settings.ResetIconComponent;

public class BindComponent
extends AbstractSettingComponent {
    private final BindSetting setting;
    private boolean binding;

    public BindComponent(BindSetting setting) {
        super(setting);
        this.setting = setting;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        this.updateVisibilityAnimation();
        boolean isModified = this.setting.isModified();
        float textOffset = isModified ? ResetIconComponent.getTextOffset() : 0.0f;
        class_4587 matrix = context.method_51448();
        String bindName = StringUtil.getBindName(this.setting.getKey());
        Object name = this.binding ? "(" + bindName + ") ..." : bindName;
        float stringWidth = Fonts.getSize(13, Fonts.Type.INTER_BOLD).getStringWidth((String)name) - 2.0f;
        String wrapped = StringUtil.wrap(this.setting.getLocalizedName(), (int)(this.width - 74.0f - textOffset), 14);
        float wrappedHeight = Fonts.getSize(14).getStringHeight(wrapped);
        this.height = (int)(18.0f + Math.max(0.0f, (wrappedHeight - 14.0f) / 2.0f));
        rectangle.render(ShapeProperties.create(matrix, this.x + this.width - stringWidth - 17.0f, this.y + this.height / 2.0f - 5.75f, stringWidth + 10.0f, 11.5).round(2.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getGuiRectColor(1.0f)).build());
        int bindingColor = class_9848.method_61324((int)255, (int)135, (int)136, (int)148);
        int textColor = ColorUtil.multAlpha(ColorUtil.getText(), this.currentAlpha);
        Fonts.getSize(13, Fonts.Type.INTER_BOLD).drawString(matrix, (String)name, this.x + this.width - 12.0f - stringWidth - 1.0f, this.y + this.height / 2.0f - 1.0f + 0.25f, bindingColor);
        this.resetIcon.position(this.x, this.y).alpha(this.currentAlpha).modified(isModified).render(matrix);
        float textX = this.x + 9.0f + textOffset;
        Fonts.getSize(14, Fonts.Type.INTER_BOLD).drawString(matrix, wrapped, textX, this.y + 9.0f, textColor);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.resetIcon.isHovered(mouseX, mouseY)) {
            this.setting.reset();
            return true;
        }
        if (button == 0 && MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, this.height)) {
            this.binding = !this.binding;
            return true;
        }
        if (this.binding && button > 1) {
            this.setting.setKey(button);
            this.binding = false;
            return true;
        }
        if (this.binding && button == 0) {
            this.binding = false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean isHover(double mouseX, double mouseY) {
        if (!this.setting.isVisible()) {
            return false;
        }
        return MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, this.height);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.binding) {
            int key = keyCode == 261 ? -1 : keyCode;
            this.setting.setKey(key);
            this.binding = false;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

