/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.settings;

import net.minecraft.class_332;
import net.minecraft.class_4587;
import padej.soup.api.feature.module.setting.implement.ColorSetting;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.api.system.sound.SoundManager;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.other.StringUtil;
import padej.soup.implement.menu.components.implement.settings.AbstractSettingComponent;
import padej.soup.implement.menu.components.implement.settings.ResetIconComponent;
import padej.soup.implement.menu.components.implement.window.AbstractWindow;
import padej.soup.implement.menu.components.implement.window.implement.settings.color.ColorWindow;

public class ColorComponent
extends AbstractSettingComponent {
    private final ColorSetting setting;

    public ColorComponent(ColorSetting setting) {
        super(setting);
        this.setting = setting;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        float textOffset;
        this.updateVisibilityAnimation();
        boolean isModified = this.setting.isModified();
        float f = textOffset = isModified ? ResetIconComponent.getTextOffset() : 0.0f;
        if (!this.setting.isVisible()) {
            return;
        }
        class_4587 matrix = context.method_51448();
        String wrapped = StringUtil.wrap(this.setting.getLocalizedName(), (int)(this.width - 29.0f - textOffset), 14);
        float wrappedHeight = Fonts.getSize(14).getStringHeight(wrapped);
        this.height = (int)(18.0f + Math.max(0.0f, (wrappedHeight - 14.0f) / 2.0f));
        int textColor = ColorUtil.multAlpha(ColorUtil.getText(), this.currentAlpha);
        this.resetIcon.position(this.x, this.y).alpha(this.currentAlpha).modified(isModified).render(matrix);
        float textX = this.x + 9.0f + textOffset;
        Fonts.getSize(14, Fonts.Type.INTER_BOLD).drawString(matrix, wrapped, textX, this.y + 9.0f, textColor);
        rectangle.render(ShapeProperties.create(matrix, this.x + this.width - 15.5f, this.y + this.height / 2.0f - 3.5f, 7.0, 7.0).round(3.5f).color(this.setting.getColor()).build());
        rectangle.render(ShapeProperties.create(matrix, this.x + this.width - 15.5f, this.y + this.height / 2.0f - 3.5f, 7.0, 7.0).round(3.5f).thickness(2.0f).softness(1.0f).outlineColor(ColorUtil.getOutline()).color(0).build());
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.setting.isVisible()) {
            return false;
        }
        if (button == 0 && this.resetIcon.isHovered(mouseX, mouseY)) {
            this.setting.reset();
            return true;
        }
        if (MathUtil.isHovered(mouseX, mouseY, this.x + this.width - 15.5f, this.y + this.height / 2.0f - 3.5f, 7.0, 7.0) && button == 0) {
            AbstractWindow existingWindow = null;
            for (AbstractWindow window : windowManager.getWindows()) {
                if (!(window instanceof ColorWindow)) continue;
                existingWindow = window;
                break;
            }
            if (existingWindow != null) {
                SoundManager.playSound(SoundManager.CLOSE_GUI, 1.0f, 1.5f);
                windowManager.delete(existingWindow);
            } else {
                SoundManager.playSound(SoundManager.OPEN_GUI, 1.0f, 1.5f);
                int windowWidth = 150;
                int windowHeight = 165;
                int windowX = (int)(mouseX + 10.0);
                int windowY = (int)(mouseY + 10.0);
                int screenWidth = mc.method_22683().method_4486();
                int screenHeight = mc.method_22683().method_4502();
                windowX = Math.max(0, Math.min(windowX, screenWidth - windowWidth));
                windowY = Math.max(0, Math.min(windowY, screenHeight - windowHeight));
                AbstractWindow colorWindow = new ColorWindow(this.setting).position(windowX, windowY).size(windowWidth, windowHeight).draggable(true);
                windowManager.add(colorWindow);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean isHover(double mouseX, double mouseY) {
        if (!this.setting.isVisible()) {
            return false;
        }
        if (MathUtil.isHovered(mouseX, mouseY, this.x + this.width - 15.5f, this.y + this.height / 2.0f - 3.5f, 7.0, 7.0)) {
            return true;
        }
        return MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, this.y + 6.0f, this.width - 24.5f, this.height - 12.0f);
    }
}

