/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.settings.select;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.api.system.font.Fonts;
import padej.soup.api.system.shape.ShapeProperties;
import padej.soup.api.system.sound.SoundManager;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.other.StringUtil;
import padej.soup.implement.menu.components.implement.settings.AbstractSettingComponent;
import padej.soup.implement.menu.components.implement.settings.ResetIconComponent;
import padej.soup.implement.menu.components.implement.settings.select.SelectedButton;

public class SelectComponent
extends AbstractSettingComponent {
    private final List<SelectedButton> selectedButtons = new ArrayList<SelectedButton>();
    private static final List<SelectComponent> openDropdowns = new ArrayList<SelectComponent>();
    private final SelectSetting setting;
    private boolean open;
    private float dropdownListX;
    private float dropDownListY;
    private float dropDownListWidth;
    private float dropDownListHeight;
    private final Animation alphaAnimation = new DecelerateAnimation().setMs(300).setValue(1.0);
    private final Animation slideAnimation = new DecelerateAnimation().setMs(250).setValue(1.0);

    public SelectComponent(SelectSetting setting) {
        super(setting);
        this.setting = setting;
        this.alphaAnimation.setDirection(Direction.BACKWARDS);
        this.slideAnimation.setDirection(Direction.BACKWARDS);
        for (String s : setting.getList()) {
            this.selectedButtons.add(new SelectedButton(setting, s));
        }
    }

    private void setOpen(boolean open) {
        if (this.open == open) {
            return;
        }
        this.open = open;
        if (open) {
            SelectComponent.closeAllDropdowns();
            openDropdowns.add(this);
        } else {
            openDropdowns.remove(this);
        }
    }

    public static void closeAllDropdowns() {
        for (SelectComponent dropdown : new ArrayList<SelectComponent>(openDropdowns)) {
            dropdown.open = false;
        }
        openDropdowns.clear();
    }

    public static void handleGlobalClick(double mouseX, double mouseY) {
        for (SelectComponent dropdown : new ArrayList<SelectComponent>(openDropdowns)) {
            if (dropdown.isHover(mouseX, mouseY)) continue;
            dropdown.setOpen(false);
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        this.updateVisibilityAnimation();
        boolean isModified = this.setting.isModified();
        float textOffset = isModified ? ResetIconComponent.getTextOffset() : 0.0f;
        class_4587 matrices = context.method_51448();
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        String wrapped = StringUtil.wrap(this.setting.getLocalizedName(), (int)(this.width - 89.0f - textOffset), 14);
        float wrappedHeight = Fonts.getSize(14).getStringHeight(wrapped);
        this.height = (int)(18.0f + Math.max(0.0f, (wrappedHeight - 14.0f) / 2.0f));
        List<String> fullSettingsList = this.setting.getList();
        this.dropdownListX = this.x + this.width - 75.0f + 2.0f + 5.0f;
        this.dropDownListY = this.y + this.height + 2.0f;
        this.dropDownListWidth = 61.0f;
        this.dropDownListHeight = fullSettingsList.size() * 12;
        this.alphaAnimation.setDirection(this.open ? Direction.FORWARDS : Direction.BACKWARDS);
        this.slideAnimation.setDirection(this.open ? Direction.FORWARDS : Direction.BACKWARDS);
        this.renderSelected(matrices);
        if (!this.alphaAnimation.isFinished(Direction.BACKWARDS)) {
            this.renderSelectList(context, mouseX, mouseY, delta);
        }
        int textColor = ColorUtil.multAlpha(ColorUtil.getText(), this.currentAlpha);
        int descColor = ColorUtil.multAlpha(ColorUtil.getDescription(), this.currentAlpha);
        this.resetIcon.position(this.x, this.y).alpha(this.currentAlpha).modified(isModified).render(matrices);
        float textX = this.x + 9.0f + textOffset;
        Fonts.getSize(14, Fonts.Type.INTER_BOLD).drawString(matrices, wrapped, textX, this.y + 9.0f, textColor);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.resetIcon.isHovered(mouseX, mouseY)) {
                this.setting.reset();
                return true;
            }
            float buttonY = this.y + this.height / 2.0f - 7.0f;
            if (MathUtil.isHovered(mouseX, mouseY, this.x + this.width - 75.0f + 2.0f, buttonY, 66.0, 14.0)) {
                SoundManager.playSound(SoundManager.CLICK);
                this.setOpen(!this.open);
                return true;
            }
            if (this.open && !this.isHoveredList(mouseX, mouseY)) {
                this.setOpen(false);
                return true;
            }
            if (this.open) {
                for (SelectedButton selectedButton : this.selectedButtons) {
                    if (!selectedButton.mouseClicked(mouseX, mouseY, button)) continue;
                    return true;
                }
                if (this.isHoveredList(mouseX, mouseY)) {
                    return true;
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean isHover(double mouseX, double mouseY) {
        float buttonY = this.y + this.height / 2.0f - 7.0f;
        if (MathUtil.isHovered(mouseX, mouseY, this.x + this.width - 75.0f + 2.0f, buttonY, 66.0, 14.0)) {
            return true;
        }
        if (MathUtil.isHovered(mouseX, mouseY, this.x + 9.0f, this.y + 6.0f, this.width - 75.0f - 9.0f, this.height - 12.0f)) {
            return true;
        }
        return this.open && this.isHoveredList(mouseX, mouseY);
    }

    private void renderSelected(class_4587 matrices) {
        float buttonY = this.y + this.height / 2.0f - 7.0f;
        rectangle.render(ShapeProperties.create(matrices, this.x + this.width - 75.0f + 2.0f + 5.0f, buttonY, 61.0, 14.0).round(2.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline()).color(ColorUtil.getGuiRectColor(1.0f)).build());
        String selectedName = String.join((CharSequence)", ", this.setting.getSelected());
        Fonts.getSize(12, Fonts.Type.INTER_BOLD).drawString(matrices, selectedName, this.x + this.width - 75.0f + 3.0f + 2.0f + 5.0f, buttonY + 6.0f, ColorUtil.getText());
        rectangle.render(ShapeProperties.create(matrices, this.x + this.width - 20.0f + 2.0f, buttonY + 1.0f, 10.0, 12.0).round(3.0f).color(ColorUtil.getGuiRectColor(0.0f), ColorUtil.getGuiRectColor(0.0f), ColorUtil.getGuiRectColor(1.0f), ColorUtil.getGuiRectColor(1.0f)).build());
    }

    private void renderSelectList(class_332 context, int mouseX, int mouseY, float delta) {
        float opacity = this.alphaAnimation.getOutput().floatValue();
        float slideProgress = this.slideAnimation.getOutput().floatValue();
        float animatedHeight = this.dropDownListHeight * slideProgress;
        float animatedY = this.dropDownListY;
        context.method_51448().method_22903();
        rectangle.render(ShapeProperties.create(context.method_51448(), this.dropdownListX, animatedY, this.dropDownListWidth, animatedHeight).round(3.0f).thickness(2.0f).outlineColor(ColorUtil.getOutline(opacity, 1.0f)).color(ColorUtil.getGuiRectColor(opacity)).build());
        float offset = this.dropDownListY;
        int visibleButtons = Math.max(1, (int)((float)this.selectedButtons.size() * slideProgress));
        for (int i = 0; i < Math.min(visibleButtons, this.selectedButtons.size()); ++i) {
            SelectedButton button = this.selectedButtons.get(i);
            button.x = this.dropdownListX;
            button.y = offset;
            button.width = this.dropDownListWidth;
            button.height = 12.0f;
            button.setAlpha(opacity);
            if (offset + 12.0f <= animatedY + animatedHeight) {
                button.render(context, mouseX, mouseY, delta);
            }
            offset += 12.0f;
        }
        context.method_51448().method_22909();
    }

    public void renderTooltips(class_332 context) {
    }

    private boolean isHoveredList(double mouseX, double mouseY) {
        float slideProgress = this.slideAnimation.getOutput().floatValue();
        float animatedHeight = this.dropDownListHeight * slideProgress;
        return MathUtil.isHovered(mouseX, mouseY, this.dropdownListX, this.dropDownListY - 16.0f, this.dropDownListWidth, animatedHeight + 16.0f);
    }

    @Override
    public float getExpandedHeight() {
        if (!this.open || this.slideAnimation.getOutput().floatValue() < 0.01f) {
            return this.height;
        }
        float slideProgress = this.slideAnimation.getOutput().floatValue();
        float dropdownHeight = this.dropDownListHeight * slideProgress;
        return this.height + 2.0f + dropdownHeight;
    }
}

