/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.implement.menu.components.implement.window;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;
import padej.soup.implement.menu.MenuScreen;
import padej.soup.implement.menu.components.AbstractComponent;
import padej.soup.implement.menu.components.implement.other.ModuleDescriptionComponent;
import padej.soup.implement.menu.components.implement.settings.AbstractSettingComponent;
import padej.soup.implement.menu.components.implement.window.AbstractWindow;
import padej.soup.implement.menu.components.implement.window.implement.settings.color.ColorWindow;
import padej.soup.implement.menu.components.implement.window.implement.settings.group.GroupWindow;

public class WindowManager
extends AbstractComponent {
    public static final WindowManager INSTANCE = new WindowManager();
    private final List<AbstractWindow> windows = new ArrayList<AbstractWindow>();

    public void add(AbstractWindow window) {
        this.windows.add(window);
    }

    public void delete(AbstractWindow window) {
        window.startCloseAnimation();
    }

    public boolean isMouseOverAnyWindow(double mouseX, double mouseY) {
        for (AbstractWindow window : this.windows) {
            if (!window.isHovered(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        ArrayList toRemove = new ArrayList();
        this.windows.forEach(window -> {
            window.render(context, mouseX, mouseY, delta);
            if (window.isCloseAnimationFinished()) {
                toRemove.add(window);
            }
        });
        this.windows.removeAll(toRemove);
        this.renderWindowHoverDescriptions(context, mouseX, mouseY, delta);
    }

    private void renderWindowHoverDescriptions(class_332 context, int mouseX, int mouseY, float delta) {
        MenuScreen menuScreen = MenuScreen.INSTANCE;
        ModuleDescriptionComponent descriptionComponent = menuScreen.getModuleDescriptionComponent();
        if (descriptionComponent != null) {
            boolean mouseOverWindow = false;
            for (int i = this.windows.size() - 1; i >= 0; --i) {
                AbstractWindow window = this.windows.get(i);
                if (!window.isHovered(mouseX, mouseY)) continue;
                mouseOverWindow = true;
                this.handleWindowHoverDescriptions(window, descriptionComponent, mouseX, mouseY, context, delta);
                break;
            }
            if (!mouseOverWindow) {
                descriptionComponent.hide();
            }
        }
    }

    private void handleWindowHoverDescriptions(AbstractWindow window, ModuleDescriptionComponent descriptionComponent, int mouseX, int mouseY, class_332 context, float delta) {
        if (window instanceof GroupWindow) {
            GroupWindow groupWindow = (GroupWindow)window;
            for (AbstractSettingComponent settingComponent : groupWindow.getComponents()) {
                if (!settingComponent.isHover(mouseX, mouseY)) continue;
                descriptionComponent.setHoveredSetting(settingComponent.getSetting());
                descriptionComponent.render(context, mouseX, mouseY, delta);
                return;
            }
        }
        if (window instanceof ColorWindow) {
            ColorWindow colorWindow = (ColorWindow)window;
            for (AbstractComponent component : colorWindow.getComponents()) {
                String componentDescription;
                if (!component.isHover(mouseX, mouseY) || (componentDescription = this.getColorComponentDescription(component)) == null || componentDescription.isEmpty()) continue;
                descriptionComponent.setHoveredSettingDescription(componentDescription);
                descriptionComponent.render(context, mouseX, mouseY, delta);
                return;
            }
        }
        descriptionComponent.hide();
    }

    private String getColorComponentDescription(AbstractComponent component) {
        String className;
        switch (className = component.getClass().getSimpleName()) {
            case "HueComponent": {
                return "setting.color.hue.name";
            }
            case "SaturationComponent": {
                return "setting.color.saturation.name";
            }
            case "AlphaComponent": {
                return "setting.color.alpha.name";
            }
            case "ColorEditorComponent": {
                return "setting.color.editor.name";
            }
            case "ColorPresetComponent": {
                return "setting.color.preset.name";
            }
        }
        return null;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clickedInsideWindow = false;
        ArrayList<AbstractWindow> windowsCopy = new ArrayList<AbstractWindow>(this.windows);
        for (int i = windowsCopy.size() - 1; i >= 0; --i) {
            AbstractWindow window = (AbstractWindow)windowsCopy.get(i);
            if (!window.isHovered(mouseX, mouseY)) continue;
            clickedInsideWindow = true;
            this.windows.remove(window);
            this.windows.add(window);
            window.mouseClicked(mouseX, mouseY, button);
            break;
        }
        if (!clickedInsideWindow) {
            for (AbstractWindow window : this.windows) {
                window.startCloseAnimation();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isHover(double mouseX, double mouseY) {
        this.windows.forEach(window -> window.isHovered(mouseX, mouseY));
        for (AbstractWindow window2 : this.windows) {
            if (!window2.isHover(mouseX, mouseY)) continue;
            return true;
        }
        return super.isHover(mouseX, mouseY);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        this.windows.forEach(window -> window.charTyped(chr, modifiers));
        return super.charTyped(chr, modifiers);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        for (AbstractWindow window : this.windows) {
            if (!window.mouseScrolled(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amount);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.windows.forEach(window -> window.keyPressed(keyCode, scanCode, modifiers));
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.windows.forEach(window -> window.keyReleased(keyCode, scanCode, modifiers));
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.windows.forEach(window -> window.mouseReleased(mouseX, mouseY, button));
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public List<AbstractWindow> getWindows() {
        return this.windows;
    }
}

