/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.mixins;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2586;
import net.minecraft.class_4737;
import net.minecraft.class_765;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.implement.features.modules.world.Light;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_4737.class})
public class LightmapCoordinatesRetrieverMixin<S extends class_2586> {
    @Inject(method={"getFromBoth(Lnet/minecraft/block/entity/BlockEntity;Lnet/minecraft/block/entity/BlockEntity;)Lit/unimi/dsi/fastutil/ints/Int2IntFunction;"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyLightmapFromBoth(S blockEntity, S blockEntity2, CallbackInfoReturnable<Int2IntFunction> cir) {
        Light light = Light.getInstance();
        if (light != null && light.isState()) {
            Int2IntFunction original = (Int2IntFunction)cir.getReturnValue();
            cir.setReturnValue(i -> {
                int originalValue = original.applyAsInt(i);
                return this.applyColorToLightmap(originalValue, light);
            });
        }
    }

    @Inject(method={"getFrom(Lnet/minecraft/block/entity/BlockEntity;)Lit/unimi/dsi/fastutil/ints/Int2IntFunction;"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyLightmapFrom(S blockEntity, CallbackInfoReturnable<Int2IntFunction> cir) {
        Light light = Light.getInstance();
        if (light != null && light.isState()) {
            Int2IntFunction original = (Int2IntFunction)cir.getReturnValue();
            cir.setReturnValue(i -> {
                int originalValue = original.applyAsInt(i);
                return this.applyColorToLightmap(originalValue, light);
            });
        }
    }

    @Inject(method={"getFallback()Lit/unimi/dsi/fastutil/ints/Int2IntFunction;"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyLightmapFallback(CallbackInfoReturnable<Int2IntFunction> cir) {
        Light light = Light.getInstance();
        if (light != null && light.isState()) {
            Int2IntFunction original = (Int2IntFunction)cir.getReturnValue();
            cir.setReturnValue(i -> {
                int originalValue = original.applyAsInt(i);
                return this.applyColorToLightmap(originalValue, light);
            });
        }
    }

    @Unique
    private int applyColorToLightmap(int lightmapCoords, Light light) {
        int blockLight = class_765.method_24186((int)lightmapCoords);
        int skyLight = class_765.method_24187((int)lightmapCoords);
        int color = light.getUseCustomLightColor().isValue() ? light.getLightColor().getColor() : ColorUtil.getClientColor();
        float red = ColorUtil.redf(color);
        float green = ColorUtil.greenf(color);
        float blue = ColorUtil.bluef(color);
        float brightness = (red + green + blue) / 3.0f;
        int modifiedBlockLight = Math.min(15, (int)((float)blockLight * (1.0f + brightness * 0.5f)));
        int modifiedSkyLight = Math.min(15, (int)((float)skyLight * (1.0f + brightness * 0.5f)));
        return class_765.method_23687((int)modifiedBlockLight, (int)modifiedSkyLight);
    }
}

