/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.mixins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_490;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import padej.soup.base.util.render.PhysicsIconRenderer;
import padej.soup.implement.features.modules.other.Trinket;

@Mixin(value={class_490.class})
public abstract class SurvivalInventoryMixin
extends class_465 {
    @Unique
    private static PhysicsIconRenderer physicsIcon;

    protected SurvivalInventoryMixin(class_2561 title) {
        super(null, null, title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void hookInit(CallbackInfo ci) {
        if (physicsIcon == null) {
            physicsIcon = new PhysicsIconRenderer(this.field_22789, this.field_22790);
        } else {
            physicsIcon.updateScreenSize(this.field_22789, this.field_22790);
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void hookRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!Trinket.getInstance().isEnabled()) {
            return;
        }
        if (physicsIcon != null) {
            List<PhysicsIconRenderer.Rectangle> collisionRects = this.calculateCollisionRectangles();
            physicsIcon.setUIRectangles(collisionRects);
            physicsIcon.render(context, mouseX, mouseY, delta);
        }
    }

    @Unique
    private List<PhysicsIconRenderer.Rectangle> calculateCollisionRectangles() {
        boolean recipeBookOpen;
        ArrayList<PhysicsIconRenderer.Rectangle> rectangles = new ArrayList<PhysicsIconRenderer.Rectangle>();
        int invWidth = 176;
        int invHeight = 166;
        int invX = this.field_2776;
        int invY = this.field_2800;
        rectangles.add(new PhysicsIconRenderer.Rectangle(new class_241((float)invX, (float)invY), new class_241((float)(invX + invWidth), (float)(invY + invHeight))));
        int centerX = (this.field_22789 - invWidth) / 2;
        boolean bl = recipeBookOpen = invX > centerX + 10;
        if (recipeBookOpen) {
            int recipeBookWidth = 147;
            int recipeBookHeight = invHeight;
            int recipeBookX = invX - recipeBookWidth;
            int recipeBookY = invY;
            rectangles.add(new PhysicsIconRenderer.Rectangle(new class_241((float)recipeBookX, (float)recipeBookY), new class_241((float)(recipeBookX + recipeBookWidth), (float)(recipeBookY + recipeBookHeight))));
        }
        rectangles.addAll(this.calculateStatusEffectRectangles());
        return rectangles;
    }

    @Unique
    private List<PhysicsIconRenderer.Rectangle> calculateStatusEffectRectangles() {
        ArrayList<PhysicsIconRenderer.Rectangle> effectRects = new ArrayList<PhysicsIconRenderer.Rectangle>();
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return effectRects;
        }
        Collection collection = this.field_22787.field_1724.method_6026();
        if (collection.isEmpty()) {
            return effectRects;
        }
        int invX = this.field_2776;
        int invWidth = 176;
        int effectStartX = invX + invWidth + 2;
        int availableWidth = this.field_22789 - effectStartX;
        if (availableWidth < 32) {
            return effectRects;
        }
        boolean wide = availableWidth >= 120;
        int rectWidth = wide ? 120 : 32;
        int k = 33;
        if (collection.size() > 5) {
            k = 132 / (collection.size() - 1);
        }
        int yPos = this.field_2800;
        for (class_1293 ignored : collection) {
            effectRects.add(new PhysicsIconRenderer.Rectangle(new class_241((float)effectStartX, (float)yPos), new class_241((float)(effectStartX + rectWidth), (float)(yPos + 32))));
            yPos += k;
        }
        return effectRects;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (physicsIcon != null) {
            physicsIcon.handleMouseClick((int)mouseX, (int)mouseY, button);
            if (physicsIcon.isMouseOver((int)mouseX, (int)mouseY)) {
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (physicsIcon != null) {
            physicsIcon.handleMouseRelease((int)mouseX, (int)mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (physicsIcon != null) {
            physicsIcon.handleMouseDrag((int)mouseX, (int)mouseY);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void method_25419() {
        super.method_25419();
    }
}

