/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.particleoptimizer.client;

import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1684;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import org.ChSP.soupapi.SoupApi;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerConfig;
import org.ChSP.soupapi.particleoptimizer.ParticleStyle;
import org.ChSP.soupapi.particleoptimizer.SoupApiParticles;
import org.ChSP.soupapi.particleoptimizer.particle.OptimizedParticle;
import org.ChSP.soupapi.rendersoptimization.CirclesRenderer;
import org.ChSP.soupapi.sound.SoundCriticalType;
import org.ChSP.soupapi.sound.SoupSound;

public class RegisterParticlesClient
implements ClientModInitializer {
    private static final class_310 mc = class_310.method_1551();
    private static final Random RANDOM = new Random();

    public void onInitializeClient() {
        ParticleFactoryRegistry registry = ParticleFactoryRegistry.getInstance();
        registry.register(SoupApiParticles.STAR, OptimizedParticle.Factory::new);
        registry.register(SoupApiParticles.LIGHT_BOLT, OptimizedParticle.Factory::new);
        registry.register(SoupApiParticles.FIRE, OptimizedParticle.Factory::new);
        registry.register(SoupApiParticles.PAW, OptimizedParticle.Factory::new);
        registry.register(SoupApiParticles.FEATHER, OptimizedParticle.Factory::new);
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (!SoupApi.PANIC) {
                if (entity != null && ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).particle_optimization) {
                    RegisterParticlesClient.spawnHitParticles(entity, ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).particle_count);
                }
                if (RegisterParticlesClient.mc.field_1724.field_6017 > 0.0f && RegisterParticlesClient.isCritical()) {
                    RegisterParticlesClient.playSound();
                }
            }
            return class_1269.field_5811;
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> RegisterParticlesClient.spawnPearParticle());
    }

    public static void spawnPearParticle() {
        if (SoupApi.PANIC || !((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).pearl_particle_optimization) {
            return;
        }
        if (RegisterParticlesClient.mc.field_1687 == null) {
            return;
        }
        ParticleStyle particleStyle = ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).particle_style;
        class_2396 particleType = particleStyle.getParticleType();
        for (class_1297 entity : RegisterParticlesClient.mc.field_1687.method_18112()) {
            if (!(entity instanceof class_1684)) continue;
            class_1684 pearl = (class_1684)entity;
            class_243 pearlPos = pearl.method_19538();
            class_243 pearlVelocity = pearl.method_18798();
            for (int i = 0; i < ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).pearl_particle_count; ++i) {
                double offsetX = (RANDOM.nextDouble() - 0.5) * 0.6;
                double offsetY = (RANDOM.nextDouble() - 0.5) * 0.6;
                double offsetZ = (RANDOM.nextDouble() - 0.5) * 0.6;
                double particleVelocityX = -pearlVelocity.field_1352 + (RANDOM.nextDouble() - 0.5) * 0.1;
                double particleVelocityY = -pearlVelocity.field_1351 + (RANDOM.nextDouble() - 0.5) * 0.1;
                double particleVelocityZ = -pearlVelocity.field_1350 + (RANDOM.nextDouble() - 0.5) * 0.1;
                RegisterParticlesClient.mc.field_1687.method_8406((class_2394)particleType, pearlPos.field_1352 + offsetX, pearlPos.field_1351 + offsetY, pearlPos.field_1350 + offsetZ, particleVelocityX / 5.0 + offsetX / 10.0, particleVelocityY / 5.0 + offsetY / 10.0, particleVelocityZ / 5.0 + offsetZ / 10.0);
            }
        }
    }

    public static void spawnHitParticles(class_1297 entity, int particleCount) {
        ParticleStyle particleStyle = ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).particle_style;
        class_2396 particleType = particleStyle.getParticleType();
        double width = entity.method_17681();
        double height = entity.method_17682();
        double entityX = entity.method_23317();
        double entityY = entity.method_23318() + (double)(entity.method_17682() / 2.0f);
        double entityZ = entity.method_23321();
        for (int i = 0; i < particleCount; ++i) {
            double xOffset = RANDOM.nextGaussian() * 0.1;
            double zOffset = RANDOM.nextGaussian() * 0.1;
            double yOffset = (double)RANDOM.nextFloat() * -0.2;
            double x = entityX + RANDOM.nextDouble() * width * 2.0 - width;
            double y = entityY + RANDOM.nextDouble() * height;
            double z = entityZ + RANDOM.nextDouble() * width * 2.0 - width;
            if (RegisterParticlesClient.mc.field_1724 == null || !(RegisterParticlesClient.mc.field_1724.field_6017 > 0.0f) || !RegisterParticlesClient.isCritical()) continue;
            RegisterParticlesClient.mc.field_1713.method_3056((class_2394)particleType, x, y, z, xOffset, yOffset, zOffset);
        }
    }

    public static void playSound() {
        if (!((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).sound_critical && !((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).sound || RegisterParticlesClient.mc.field_1724 == null) {
            return;
        }
        Random random = new Random();
        double pitch = 0.9 + (double)random.nextInt(51) / 100.0;
        class_3414 sound = switch (((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).sound_critical_type) {
            default -> throw new MatchException(null, null);
            case SoundCriticalType.GET -> SoupSound.GET;
            case SoundCriticalType.BUBBLE -> SoupSound.BUBBLE;
            case SoundCriticalType.BELL -> SoupSound.BELL;
            case SoundCriticalType.BONK -> SoupSound.BONK;
            case SoundCriticalType.POK -> SoupSound.POK;
            case SoundCriticalType.MAGIC_POK -> SoupSound.MAGIC_POK;
        };
        RegisterParticlesClient.mc.field_1724.method_5783(sound, (float)((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).sound_volume / 100.0f, ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).sound_critical_random_pitch ? (float)pitch : 1.0f);
    }

    private static boolean isCritical() {
        return RegisterParticlesClient.mc.field_1724 != null && RegisterParticlesClient.mc.field_1724.method_7261(0.5f) > 0.9f && RegisterParticlesClient.mc.field_1724.field_6017 > 0.0f && !RegisterParticlesClient.mc.field_1724.method_24828() && !RegisterParticlesClient.mc.field_1724.method_6101() && !RegisterParticlesClient.mc.field_1724.method_5799() && !RegisterParticlesClient.mc.field_1724.method_6059(class_1294.field_5919) && !RegisterParticlesClient.mc.field_1724.method_5765() && !RegisterParticlesClient.mc.field_1724.method_5624();
    }
}

