/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.rendersoptimization;

import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.ChSP.soupapi.SoupApi;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerConfig;
import org.joml.Quaternionf;

public class QuadRendererMod
implements ClientModInitializer {
    private ConfigHolder<BlockEntityOptimizerConfig> configHolder;
    private float rollAngle = 0.0f;
    private float targetRollAngle = 0.0f;
    private float currentSizeMultiplier = 1.0f;

    public void onInitializeClient() {
        this.configHolder = AutoConfig.getConfigHolder(BlockEntityOptimizerConfig.class);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::onWorldRender);
    }

    private void onWorldRender(WorldRenderContext context) {
        if (SoupApi.PANIC) {
            return;
        }
        this.targetRollAngle += context.tickCounter().method_60637(true) * 2.2f;
        this.rollAngle = this.lerp(this.rollAngle, this.targetRollAngle, 0.1f);
        this.renderBillboardQuad(context.matrixStack(), context.camera(), context.tickCounter().method_60637(true));
    }

    private float lerp(float start, float end, float alpha) {
        return start + alpha * (end - start);
    }

    private int lerpColor(int startColor, int endColor, float alpha) {
        int r = (int)((float)(startColor >> 16 & 0xFF) * (1.0f - alpha) + (float)(endColor >> 16 & 0xFF) * alpha);
        int g = (int)((float)(startColor >> 8 & 0xFF) * (1.0f - alpha) + (float)(endColor >> 8 & 0xFF) * alpha);
        int b = (int)((float)(startColor & 0xFF) * (1.0f - alpha) + (float)(endColor & 0xFF) * alpha);
        return r << 16 | g << 8 | b;
    }

    public void renderBillboardQuad(class_4587 matrixStack, class_4184 camera, float tickDelta) {
        BlockEntityOptimizerConfig config = (BlockEntityOptimizerConfig)this.configHolder.getConfig();
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null || !config.render_optimization) {
            return;
        }
        class_1297 targetEntity = null;
        class_239 hitResult = client.field_1765;
        float targetSizeMultiplier = 1.0f;
        if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1331) {
            class_3966 entityHitResult = (class_3966)hitResult;
            targetEntity = entityHitResult.method_17782();
        }
        this.currentSizeMultiplier = this.lerp(this.currentSizeMultiplier, targetSizeMultiplier, tickDelta * 0.1f);
        if (targetEntity == null) {
            return;
        }
        this.renderQuadWithMultiplier(matrixStack, camera, tickDelta, targetEntity, this.currentSizeMultiplier);
    }

    private void renderQuadWithMultiplier(class_4587 matrixStack, class_4184 camera, float tickDelta, class_1297 targetEntity, float sizeMultiplier) {
        BlockEntityOptimizerConfig config = (BlockEntityOptimizerConfig)this.configHolder.getConfig();
        double interpolatedX = this.lerp((float)targetEntity.field_6014, (float)targetEntity.method_23317(), tickDelta);
        double interpolatedY = this.lerp((float)targetEntity.field_6036, (float)targetEntity.method_23318(), tickDelta) + targetEntity.method_17682() / 2.0f;
        double interpolatedZ = this.lerp((float)targetEntity.field_5969, (float)targetEntity.method_23321(), tickDelta);
        class_243 entityPos = new class_243(interpolatedX, interpolatedY, interpolatedZ);
        class_243 cameraPos = camera.method_19326();
        class_243 transformedPos = entityPos.method_1020(cameraPos);
        matrixStack.method_22903();
        matrixStack.method_22904(transformedPos.field_1352, transformedPos.field_1351, transformedPos.field_1350);
        Quaternionf rotation = new Quaternionf().identity();
        rotation.rotateY(-camera.method_19330() * (float)Math.PI / 180.0f);
        rotation.rotateX(camera.method_19329() * (float)Math.PI / 180.0f);
        rotation.rotateZ((float)Math.toRadians(this.rollAngle));
        matrixStack.method_22907(rotation);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)config.render_style.getTexture());
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        float size = (targetEntity.method_17682() / 2.0f + 0.5f) * (float)config.render_size_multiply / 100.0f * sizeMultiplier;
        float halfSize = size / 2.0f;
        float colorAlpha = 1.0f;
        float colorProgress = (float)(Math.sin((double)System.currentTimeMillis() * 0.001) * 0.5 + 0.5);
        int currentColor = this.lerpColor(config.start_color, config.end_color, colorProgress);
        float r = (float)(currentColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(currentColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(currentColor & 0xFF) / 255.0f;
        buffer.method_22918(matrixStack.method_23760().method_23761(), -halfSize, halfSize, 0.0f).method_22913(0.0f, 0.0f);
        buffer.method_22918(matrixStack.method_23760().method_23761(), halfSize, halfSize, 0.0f).method_22913(1.0f, 0.0f);
        buffer.method_22918(matrixStack.method_23760().method_23761(), halfSize, -halfSize, 0.0f).method_22913(1.0f, 1.0f);
        buffer.method_22918(matrixStack.method_23760().method_23761(), -halfSize, -halfSize, 0.0f).method_22913(0.0f, 1.0f);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)colorAlpha);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        matrixStack.method_22909();
    }
}

