/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.rendersoptimization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_243;

public class Rail
implements ModInitializer {
    private final Map<UUID, PlayerTrail> playerTrails = new HashMap<UUID, PlayerTrail>();
    private static final float SEGMENT_LIFETIME = 1.35f;
    private static final float FADE_IN_TIME = 0.2f;

    public void onInitialize() {
    }

    private int calculateAlpha(float age) {
        if (age < 0.2f) {
            return (int)(255.0f * (age / 0.2f));
        }
        if (age < 1.35f) {
            return (int)(255.0f * (1.0f - (age - 0.2f) / 1.15f));
        }
        return 0;
    }

    private int interpolateColor(int startColor, int endColor, float factor) {
        int startRed = startColor >> 16 & 0xFF;
        int startGreen = startColor >> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endRed = endColor >> 16 & 0xFF;
        int endGreen = endColor >> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        int red = (int)((float)startRed + (float)(endRed - startRed) * factor);
        int green = (int)((float)startGreen + (float)(endGreen - startGreen) * factor);
        int blue = (int)((float)startBlue + (float)(endBlue - startBlue) * factor);
        return red << 16 | green << 8 | blue;
    }

    private int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    private int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    private int getBlue(int color) {
        return color & 0xFF;
    }

    private static class TrailSegment {
        class_243 position;
        float age;

        TrailSegment(class_243 position) {
            this.position = position;
            this.age = 0.0f;
        }
    }

    private static class PlayerTrail {
        List<TrailSegment> segments = new ArrayList<TrailSegment>();
        class_243 lastPosition;

        private PlayerTrail() {
        }
    }
}

