/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.rendersoptimization.mixin;

import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.ChSP.soupapi.SoupApi;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerConfig;
import org.ChSP.soupapi.rendersoptimization.CirclesRenderer;
import org.ChSP.soupapi.rendersoptimization.SwingStyle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_759.class})
public class CustomSwingHandMixin {
    @Inject(method={"renderFirstPersonItem"}, at={@At(value="HEAD")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, cancellable=true)
    private void modifySwingAnimation(class_742 player, float tickDelta, float pitch, class_1268 hand, float swingProgress, class_1799 item, float equipProgress, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        class_1306 arm;
        if (SoupApi.PANIC || !((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing) {
            return;
        }
        if (item.method_7960()) {
            return;
        }
        ci.cancel();
        boolean isMainHand = hand == class_1268.field_5808;
        class_1306 class_13062 = arm = isMainHand ? player.method_6068() : player.method_6068().method_5928();
        if (isMainHand && player.method_6047().method_7960() || !isMainHand && player.method_6079().method_7960()) {
            return;
        }
        matrices.method_22903();
        if (player.method_6115() && (item.method_7976() == class_1839.field_8950 || item.method_7976() == class_1839.field_8946)) {
            this.applyEatOrDrinkTransformation(matrices, tickDelta, arm, item);
            this.applyEquipOffset(matrices, arm, equipProgress);
        } else {
            this.applySwingTransformation(((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_style, matrices, swingProgress, arm);
        }
        class_759 heldItemRenderer = (class_759)this;
        heldItemRenderer.method_3233((class_1309)player, item, arm == class_1306.field_6183 ? class_811.field_4322 : class_811.field_4321, arm == class_1306.field_6182, matrices, vertexConsumers, light);
        matrices.method_22909();
    }

    @Unique
    private void applySwingTransformation(SwingStyle style, class_4587 matrices, float swingProgress, class_1306 arm) {
        float offsetX = arm == class_1306.field_6183 ? 1.0f : -1.0f;
        float swingAmount = class_3532.method_15374((float)(class_3532.method_15355((float)(swingProgress * (float)((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_speed / 100.0f)) * (float)Math.PI));
        swingAmount = Math.max(swingAmount, 0.05f);
        switch (style) {
            case BASIC_SWING: {
                matrices.method_22904((double)offsetX * 0.5, (double)-0.3f, (double)-0.7f);
                matrices.method_22905(0.55f, 0.55f, 0.55f);
                float rotationX = class_3532.method_16439((float)swingAmount, (float)0.0f, (float)-45.0f);
                float rotationY = class_3532.method_16439((float)swingAmount, (float)0.0f, (float)((arm == class_1306.field_6183 ? -10.0f : 10.0f) * 3.0f));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(rotationX));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(rotationY));
                float forwardOffset = class_3532.method_16439((float)swingAmount, (float)0.0f, (float)0.1f);
                matrices.method_46416(0.0f, 0.0f, forwardOffset);
                break;
            }
            case SWIPE_IN: {
                matrices.method_22904((double)offsetX * 1.5, -0.8, -2.7);
                matrices.method_22905(1.3f, 1.3f, 1.3f);
                float rotationX = class_3532.method_16439((float)swingAmount, (float)0.0f, (float)-45.0f);
                float rotationY = class_3532.method_16439((float)swingAmount, (float)0.0f, (float)((arm == class_1306.field_6183 ? -10.0f : 10.0f) * 8.5f));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(0.0f));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-70.0f - rotationY));
                matrices.method_22907(class_7833.field_40718.rotationDegrees(65.0f + rotationY * -0.25f));
                break;
            }
            case SWIPE_OUT: {
                matrices.method_22904((double)offsetX * 1.5, -0.8, -2.7);
                matrices.method_22905(1.3f, 1.3f, 1.3f);
                float rotationX = class_3532.method_16439((float)swingAmount, (float)0.0f, (float)-45.0f);
                float rotationY = class_3532.method_16439((float)swingAmount, (float)0.0f, (float)((arm == class_1306.field_6183 ? -10.0f : 10.0f) * 8.5f));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(0.0f));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-70.0f + rotationY));
                matrices.method_22907(class_7833.field_40718.rotationDegrees(65.0f + rotationY * -0.25f));
                break;
            }
            case SWING_DOWN: {
                matrices.method_22904((double)offsetX * 1.5, -0.8, -2.7);
                matrices.method_22905(1.3f, 1.3f, 1.3f);
                float rotationX = class_3532.method_16439((float)swingAmount, (float)0.0f, (float)-45.0f);
                float rotationY = class_3532.method_16439((float)swingAmount, (float)0.0f, (float)((arm == class_1306.field_6183 ? -10.0f : 10.0f) * 6.5f));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(0.0f));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-70.0f));
                matrices.method_22907(class_7833.field_40718.rotationDegrees(65.0f + rotationY * -0.35f));
                break;
            }
            case CUSTOM: {
                float x = ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_xPos;
                float y = ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_yPos;
                float z = ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_zPos;
                matrices.method_46416(offsetX * x, y, z);
                float xScale = ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_xScale;
                float yScale = ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_yScale;
                float zScale = ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_zScale;
                matrices.method_22905(xScale, yScale, zScale);
                float swingRotationX = class_3532.method_16439((float)swingAmount, (float)0.0f, (float)((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_xSwingRot);
                float swingRotationY = class_3532.method_16439((float)swingAmount, (float)0.0f, (float)((float)(arm == class_1306.field_6183 ? -1 : 1) * ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_ySwingRot));
                float swingRotationZ = class_3532.method_16439((float)swingAmount, (float)0.0f, (float)((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_zSwingRot);
                float rotX = ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_rotX;
                float rotY = ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_rotY;
                float rotZ = ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).swing_hand_rotZ;
                matrices.method_22907(class_7833.field_40714.rotationDegrees(rotX + swingRotationX));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(rotY + swingRotationY));
                matrices.method_22907(class_7833.field_40718.rotationDegrees(rotZ + swingRotationZ));
            }
        }
    }

    @Unique
    private void applyEquipOffset(class_4587 matrices, class_1306 arm, float equipProgress) {
        int i = arm == class_1306.field_6183 ? 1 : -1;
        matrices.method_46416((float)i * 0.56f, -0.52f + equipProgress * -0.6f, -0.72f);
    }

    @Unique
    private void applyEatOrDrinkTransformation(class_4587 matrices, float tickDelta, class_1306 arm, class_1799 stack) {
        float h;
        float f = (float)class_310.method_1551().field_1724.method_6014() - tickDelta + 1.0f;
        float g = f / (float)stack.method_7935((class_1309)class_310.method_1551().field_1724);
        if (g < 0.8f) {
            h = class_3532.method_15379((float)(class_3532.method_15362((float)(f / 4.0f * (float)Math.PI)) * 0.1f));
            matrices.method_46416(0.0f, h, 0.0f);
        }
        h = 1.0f - (float)Math.pow(g, 27.0);
        int i = arm == class_1306.field_6183 ? 1 : -1;
        matrices.method_46416(h * 0.6f * (float)i, h * -0.5f, h * 0.0f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees((float)i * h * 90.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(h * 10.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees((float)i * h * 30.0f));
    }
}

