/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.rendersoptimization.mixin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_355;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_640;
import org.ChSP.soupapi.SoupApi;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerConfig;
import org.ChSP.soupapi.listsoptimizer.FriendCommandClient;
import org.ChSP.soupapi.rendersoptimization.CirclesRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_355.class})
public abstract class PlayerListHudMixin {
    @Unique
    private static final int WAVE_LENGTH = 2;
    @Unique
    private static final int COLOR_CYCLE_TICKS = 40;

    @Inject(method={"getPlayerName"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectPlayerName(class_640 entry, CallbackInfoReturnable<class_2561> cir) {
        if (SoupApi.PANIC) {
            return;
        }
        String playerName = entry.method_2966().getName();
        List<String> friendsList = this.loadFriendsFromFile();
        String NAME = new String(Base64.getDecoder().decode("UGFkZWpf"));
        if (NAME.equals(playerName)) {
            int tick = (int)(class_310.method_1551().field_1687.method_8510() % 40L);
            cir.setReturnValue((Object)class_2561.method_43470((String)"\u00a76\u2605 ").method_10852((class_2561)this.applyWaveEffectToName(NAME, tick)));
            return;
        }
        if (friendsList.contains(playerName)) {
            class_5250 originalText = (class_5250)cir.getReturnValue();
            int tick = (int)(class_310.method_1551().field_1687.method_8510() % 40L);
            class_5250 customText = class_2561.method_43470((String)"");
            boolean nameFound = false;
            for (class_2561 sibling : originalText.method_10855()) {
                String siblingText = sibling.getString();
                if (siblingText.contains(playerName)) {
                    nameFound = true;
                    customText.method_10852((class_2561)this.applyWaveEffectToName(playerName, tick));
                    continue;
                }
                customText.method_10852(sibling);
            }
            if (!nameFound) {
                customText.method_10852((class_2561)this.applyWaveEffectToName(originalText.getString(), tick));
            }
            cir.setReturnValue((Object)customText);
        }
    }

    private class_5250 applyWaveEffectToName(String name, int tick) {
        class_5250 customText = class_2561.method_43470((String)"");
        boolean skipNextChar = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\u00a7') {
                customText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(c)));
                skipNextChar = true;
                continue;
            }
            if (skipNextChar) {
                skipNextChar = false;
                continue;
            }
            int waveOffset = (name.length() - 1 - i) * 2 % 40;
            int colorIndex = (tick + waveOffset) % 40;
            float t = (float)colorIndex / 40.0f;
            t = (float)(0.5 * (1.0 + Math.sin((double)(t * 2.0f) * Math.PI)));
            int color = this.interpolateColor(((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).start_color, ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).end_color, t);
            customText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(c)).method_27694(style -> style.method_27703(class_5251.method_27717((int)color))));
        }
        return customText;
    }

    private List<String> loadFriendsFromFile() {
        List<String> friends = new ArrayList<String>();
        try {
            Path path = Path.of("config/soupapi/Friends.txt", new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                friends = Files.readAllLines(path).stream().filter(line -> !line.trim().isEmpty()).map(line -> {
                    try {
                        return FriendCommandClient.decrypt(line);
                    }
                    catch (Exception e) {
                        System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u043a\u0438 \u0441\u0442\u0440\u043e\u043a\u0438: " + e.getMessage());
                        return null;
                    }
                }).filter(name -> name != null).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 \u0434\u0440\u0443\u0437\u0435\u0439: " + e.getMessage());
        }
        return friends;
    }

    private int interpolateColor(int color1, int color2, float t) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }
}

