/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.blockentityoptimizer;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_746;
import org.ChSP.soupapi.SoupApi;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerGroup;
import org.ChSP.soupapi.blockentityoptimizer.util.RenderUtils;
import org.ChSP.soupapi.blockentityoptimizer.util.RotationUtils;
import org.joml.Matrix4f;

public final class BlockEntityOptimizerRenderer {
    private static class_291 solidBox;
    private static class_291 outlinedBox;
    private final class_4587 matrixStack;
    private final int regionX;
    private final int regionZ;
    private final class_243 start;

    public BlockEntityOptimizerRenderer(class_4587 matrixStack) {
        this.matrixStack = matrixStack;
        class_2338 camPos = RenderUtils.getCameraBlockPos();
        this.regionX = (camPos.method_10263() >> 9) * 512;
        this.regionZ = (camPos.method_10260() >> 9) * 512;
        this.start = RotationUtils.getClientLookVec().method_1019(RenderUtils.getCameraPos()).method_1023((double)this.regionX, 0.0, (double)this.regionZ);
    }

    public void renderBoxes(BlockEntityOptimizerGroup group) {
        if (SoupApi.PANIC) {
            return;
        }
        float[] colorF = group.getColorF();
        class_746 player = class_310.method_1551().field_1724;
        for (class_238 box : group.getBoxes()) {
            this.matrixStack.method_22903();
            this.matrixStack.method_22904(box.field_1323 - (double)this.regionX, box.field_1322, box.field_1321 - (double)this.regionZ);
            this.matrixStack.method_22905((float)(box.field_1320 - box.field_1323), (float)(box.field_1325 - box.field_1322), (float)(box.field_1324 - box.field_1321));
            double distance = player.method_5649(box.field_1323, box.field_1322, box.field_1321);
            Matrix4f viewMatrix = this.matrixStack.method_23760().method_23761();
            Matrix4f projMatrix = RenderSystem.getProjectionMatrix();
            class_5944 shader = RenderSystem.getShader();
            RenderSystem.setShaderColor((float)colorF[0], (float)colorF[1], (float)colorF[2], (float)0.25f);
            solidBox.method_1353();
            solidBox.method_34427(viewMatrix, projMatrix, shader);
            class_291.method_1354();
            RenderSystem.setShaderColor((float)colorF[0], (float)colorF[1], (float)colorF[2], (float)0.5f);
            outlinedBox.method_1353();
            outlinedBox.method_34427(viewMatrix, projMatrix, shader);
            class_291.method_1354();
            this.matrixStack.method_22909();
        }
    }

    private float calculateAlpha(double distance, double maxDistance, double minDistance, float baseAlpha) {
        if (distance < minDistance * minDistance) {
            return 0.0f;
        }
        if (distance > maxDistance * maxDistance) {
            return baseAlpha;
        }
        if (distance >= minDistance * minDistance && distance <= maxDistance * maxDistance) {
            float ratio = (float)(Math.sqrt(distance) - minDistance) / (float)(maxDistance - minDistance);
            return class_3532.method_15363((float)(baseAlpha * ratio), (float)0.0f, (float)baseAlpha);
        }
        return 0.0f;
    }

    public static void prepareBuffers() {
        BlockEntityOptimizerRenderer.closeBuffers();
        solidBox = new class_291(class_291.class_8555.field_44793);
        outlinedBox = new class_291(class_291.class_8555.field_44793);
        class_238 box = new class_238(class_2338.field_10980);
        RenderUtils.drawSolidBox(box, solidBox);
        RenderUtils.drawOutlinedBox(box, outlinedBox);
    }

    public static void closeBuffers() {
        if (solidBox != null) {
            solidBox.close();
        }
        solidBox = null;
        if (outlinedBox != null) {
            outlinedBox.close();
        }
        outlinedBox = null;
    }
}

