/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.hudaddon;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.util.LinkedList;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_640;
import org.ChSP.soupapi.SoupApi;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerConfig;

public class HudAuthMod
implements ModInitializer {
    private static final class_310 mc = class_310.method_1551();
    private boolean show;
    private String enemyNickname;
    private double enemyHP;
    private class_1657 entity;
    private class_2960 enemySkin;
    private int hudTimer = 0;
    private float hudScale = 0.0f;
    private final float scaleSpeed = 0.2f;
    private double currentAbsorption;
    private ConfigHolder<BlockEntityOptimizerConfig> configHolder;
    private final LinkedList<Double> healthHistory = new LinkedList();
    private static final int MAX_HEALTH_HISTORY = 10;
    private boolean healthFalling = false;

    public void onInitialize() {
        this.configHolder = AutoConfig.getConfigHolder(BlockEntityOptimizerConfig.class);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            double newAbsorption;
            boolean isChatOpen;
            if (SoupApi.PANIC) {
                return;
            }
            BlockEntityOptimizerConfig config = (BlockEntityOptimizerConfig)this.configHolder.getConfig();
            class_239 objectMouseOver = HudAuthMod.mc.field_1765;
            boolean bl = isChatOpen = HudAuthMod.mc.field_1755 != null && (HudAuthMod.mc.field_1755.method_25440().getString().equals("Chat screen") || HudAuthMod.mc.field_1755.method_25440().getString().equals("\u0427\u0430\u0442"));
            if (HudAuthMod.mc.field_1724 != null && (newAbsorption = (double)HudAuthMod.mc.field_1724.method_6067()) != this.currentAbsorption) {
                this.currentAbsorption = newAbsorption;
            }
            if (objectMouseOver != null && objectMouseOver.method_17783() == class_239.class_240.field_1331) {
                class_3966 entityHitResult = (class_3966)objectMouseOver;
                if (entityHitResult.method_17782() instanceof class_1657) {
                    this.entity = (class_1657)entityHitResult.method_17782();
                    this.enemyNickname = this.entity.method_5477().getString();
                    this.enemyHP = this.entity.method_6032();
                    this.show = true;
                    this.hudTimer = config.hud_live_ticks;
                    if (mc.method_1562() != null && HudAuthMod.mc.field_1687 != null) {
                        this.fetchSkin(this.entity);
                    }
                    this.updateHealthHistory(this.enemyHP);
                } else {
                    this.show = false;
                }
            } else if (isChatOpen) {
                this.entity = HudAuthMod.mc.field_1724;
                this.enemyNickname = this.entity.method_5477().getString();
                this.enemyHP = this.entity.method_6032();
                this.show = true;
                this.hudTimer = config.hud_live_ticks;
                if (mc.method_1562() != null && HudAuthMod.mc.field_1687 != null) {
                    this.fetchSkin(this.entity);
                }
                this.updateHealthHistory(this.enemyHP);
            } else if (this.hudTimer > 0) {
                --this.hudTimer;
            }
            if (this.hudTimer <= 0) {
                this.show = false;
            }
        });
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (!((BlockEntityOptimizerConfig)this.configHolder.get()).hud_optimization) {
                return;
            }
            BlockEntityOptimizerConfig config = (BlockEntityOptimizerConfig)this.configHolder.getConfig();
            this.hudScale = this.show ? class_3532.method_16439((float)(tickDelta.method_60637(true) * 0.2f), (float)this.hudScale, (float)1.0f) : class_3532.method_16439((float)(tickDelta.method_60637(true) * 0.2f), (float)this.hudScale, (float)0.0f);
            if (this.hudScale > 0.0f && HudAuthMod.mc.field_1724 != null) {
                this.renderTargetHUD(drawContext, this.hudScale * (float)config.hud_size_multiply / 100.0f, config.hud_x_offset, config.hud_y_offset, config.hud_background_color, config.start_color, config.end_color, config.hud_start_absorption_health_color, config.hud_end_absorption_health_color);
            }
        });
    }

    private void renderTargetHUD(class_332 drawContext, float scale, int offsetX, int offsetY, int hud_background_color, int hud_start_health_color, int hud_end_health_color, int hud_start_absorption_health_color, int hud_end_absorption_health_color) {
        class_327 textRenderer = HudAuthMod.mc.field_1772;
        float scaledWidth = mc.method_22683().method_4486();
        float scaledHeight = mc.method_22683().method_4502();
        float x = scaledWidth / 2.0f + (float)offsetX;
        float y = scaledHeight / 2.0f - (float)offsetY;
        float health = (float)this.getAverageHealth();
        double hpPercentage = health / 20.0f;
        hpPercentage = class_3532.method_15350((double)hpPercentage, (double)0.0, (double)1.0);
        double baseHpWidth = 97.0 * hpPercentage;
        float absorption = this.entity.method_6067();
        double absorptionPercentage = absorption / 20.0f;
        absorptionPercentage = class_3532.method_15350((double)absorptionPercentage, (double)0.0, (double)1.0);
        double baseAbsorptionWidth = 97.0 * absorptionPercentage;
        float animationProgress = (float)(Math.sin((double)HudAuthMod.mc.field_1687.method_8510() / 10.0) + 1.0) / 2.0f;
        int animatedHealthColor = this.blendColors(hud_start_health_color, hud_end_health_color, animationProgress);
        int absorptionAnimatedHealthColor = this.blendColors(hud_start_absorption_health_color, hud_end_absorption_health_color, animationProgress);
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416(x, y, 0.0f);
        matrices.method_22905(scale, scale, 1.0f);
        Color backgroundColor = new Color(hud_background_color >> 16 & 0xFF, hud_background_color >> 8 & 0xFF, hud_background_color & 0xFF, ((BlockEntityOptimizerConfig)this.configHolder.get()).hud_background_alpha);
        this.drawGlowingBackground(drawContext, -32, -8, 142, 44, new Color(animatedHealthColor).brighter().brighter().getRGB());
        drawContext.method_25294(-32, -8, 110, 36, backgroundColor.getRGB());
        int gradientStartColor = new Color(animatedHealthColor).darker().getRGB();
        int gradientEndColor = new Color(animatedHealthColor).brighter().getRGB();
        this.drawGradient(drawContext, 12, 5, 12 + (int)baseHpWidth, 17, gradientStartColor, gradientEndColor);
        int absorptionStartColor = new Color(absorptionAnimatedHealthColor).darker().getRGB();
        int absorptionEndColor = new Color(absorptionAnimatedHealthColor).brighter().getRGB();
        this.drawGradient(drawContext, 12, 5, 12 + (int)baseAbsorptionWidth, 17, absorptionStartColor, absorptionEndColor);
        drawContext.method_51433(textRenderer, String.valueOf(Math.round(health)), 14, 7, -1, true);
        drawContext.method_51433(textRenderer, this.enemyNickname, 12, -5, -1, true);
        if (this.entity instanceof class_1657 && this.enemySkin != null) {
            this.drawHead(drawContext, this.enemySkin, -30, -50);
        }
        this.renderItems(drawContext, 12.0f, 17.0f);
        matrices.method_22909();
    }

    private void drawGlowingBackground(class_332 drawContext, int x, int y, int width, int height, int glowColor) {
        int glowRadius = 3;
        for (int dy = -glowRadius; dy <= glowRadius; ++dy) {
            for (int dx = -glowRadius; dx <= glowRadius; ++dx) {
                int alpha;
                int distance = (int)Math.sqrt(dx * dx + dy * dy);
                if (distance > glowRadius || (alpha = (int)(255.0f * (0.5f * (1.0f - (float)distance / (float)glowRadius)))) <= 0) continue;
                int glowingColor = alpha << 24 | glowColor & 0xFFFFFF;
                this.drawOutline(drawContext, x + dx, y + dy, width, height, glowingColor);
            }
        }
    }

    private void drawOutline(class_332 drawContext, int x, int y, int width, int height, int color) {
        drawContext.method_25294(x, y, x + width, y + 1, color);
        drawContext.method_25294(x, y + height - 1, x + width, y + height, color);
        drawContext.method_25294(x, y + 1, x + 1, y + height - 1, color);
        drawContext.method_25294(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    private void drawGradient(class_332 drawContext, int x1, int y1, int x2, int y2, int colorStart, int colorEnd) {
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 0.0f);
        int steps = x2 - x1;
        for (int i = 0; i < steps; ++i) {
            float ratio = (float)i / (float)(steps - 1);
            int color = this.blendColors(colorStart, colorEnd, ratio);
            drawContext.method_25294(x1 + i, y1, x1 + i + 1, y2, color + -16777216);
        }
        matrices.method_22909();
    }

    private int blendColors(int color1, int color2, float ratio) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + ratio * (float)(r2 - r1));
        int g = (int)((float)g1 + ratio * (float)(g2 - g1));
        int b = (int)((float)b1 + ratio * (float)(b2 - b1));
        return r << 16 | g << 8 | b;
    }

    private void drawHead(class_332 drawContext, class_2960 skin, int x, int y) {
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416((float)x, (float)y, 0.0f);
        mc.method_1531().method_22813(skin);
        drawContext.method_25290(skin, 0, 44, 40.0f, 40.0f, 40, 40, 320, 320);
        drawContext.method_25290(skin, 0, 44, 200.0f, 40.0f, 40, 40, 320, 320);
        drawContext.method_51448().method_22909();
    }

    private void renderItems(class_332 drawContext, float xOffset, float yOffset) {
        class_1799 mainHandItem = this.entity.method_6047();
        class_1799 offHandItem = this.entity.method_6079();
        class_327 textRenderer = HudAuthMod.mc.field_1772;
        drawContext.method_51427(mainHandItem, (int)xOffset, (int)yOffset);
        drawContext.method_51432(textRenderer, mainHandItem, (int)xOffset, (int)yOffset, null);
        drawContext.method_51427(offHandItem, (int)(xOffset + 16.0f), (int)yOffset);
        drawContext.method_51432(textRenderer, offHandItem, (int)(xOffset + 16.0f), (int)yOffset, null);
        int armorX = (int)(xOffset + 82.0f);
        int armorY = (int)yOffset;
        int i = 0;
        for (class_1799 armorItem : this.entity.method_5661()) {
            drawContext.method_51427(armorItem, armorX - i * 16, armorY);
            drawContext.method_51432(textRenderer, armorItem, armorX - i * 16, armorY, null);
            ++i;
        }
        if (HudAuthMod.mc.field_1724.method_5661() == null) {
            return;
        }
        int j = 0;
        for (class_1799 armorItem : HudAuthMod.mc.field_1724.method_5661()) {
            drawContext.method_51432(textRenderer, armorItem, armorX - j * 16, armorY + 2, null);
            ++j;
        }
    }

    private void updateHealthHistory(double newHealth) {
        if (HudAuthMod.mc.field_1724 != null) {
            if (this.healthHistory.size() >= 10) {
                this.healthHistory.removeFirst();
            }
            this.healthHistory.addLast(newHealth);
            this.healthFalling = this.isHealthFalling();
        }
    }

    private double getAverageHealth() {
        return this.healthHistory.stream().mapToDouble(Double::doubleValue).average().orElse(20.0);
    }

    private boolean isHealthFalling() {
        double secondLastHealth;
        if (this.healthHistory.size() < 2) {
            return false;
        }
        double lastHealth = this.healthHistory.getLast();
        return lastHealth < (secondLastHealth = this.healthHistory.get(this.healthHistory.size() - 2).doubleValue());
    }

    private void fetchSkin(class_1657 player) {
        if (mc.method_1562() == null || HudAuthMod.mc.field_1687 == null) {
            return;
        }
        GameProfile profile = player.method_7334();
        class_640 playerInfo = mc.method_1562().method_2871(profile.getId());
        if (playerInfo != null) {
            class_2960 skinTexture = playerInfo.method_52810().comp_1626();
            this.enemySkin = Objects.requireNonNullElseGet(skinTexture, () -> class_2960.method_60655((String)"soupapi", (String)"textures/entity/steve.png"));
        }
    }
}

