/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.hudaddon;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.ChSP.soupapi.SoupApi;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerConfig;
import org.ChSP.soupapi.sound.SoupSound;

public class RegisterHudMod
implements ModInitializer {
    private final class_310 mc = class_310.method_1551();
    private ConfigHolder<BlockEntityOptimizerConfig> configHolder;
    private final Map<String, ModuleState> moduleStates = new HashMap<String, ModuleState>();

    public void onInitialize() {
        this.configHolder = AutoConfig.getConfigHolder(BlockEntityOptimizerConfig.class);
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (SoupApi.PANIC) {
                return;
            }
            if (this.mc.field_1724 != null) {
                this.renderHud(drawContext, tickDelta.method_60637(true));
            }
        });
    }

    private void renderHud(class_332 drawContext, float tickDelta) {
        if (!((BlockEntityOptimizerConfig)this.configHolder.get()).list_optimization) {
            return;
        }
        class_327 textRenderer = this.mc.field_1772;
        int screenWidth = this.mc.method_22683().method_4486();
        int y = 15;
        ArrayList<String> activeModules = new ArrayList<String>();
        if (((BlockEntityOptimizerConfig)this.configHolder.get()).render_line_optimization) {
            activeModules.add("Pearl Trajectory");
        }
        if (((BlockEntityOptimizerConfig)this.configHolder.get()).crosshair) {
            activeModules.add("Ring Crosshair");
        }
        if (((BlockEntityOptimizerConfig)this.configHolder.get()).render_optimization) {
            activeModules.add("Target Render");
        }
        if (((BlockEntityOptimizerConfig)this.configHolder.get()).particle_optimization) {
            activeModules.add("Hit Particles");
        }
        if (((BlockEntityOptimizerConfig)this.configHolder.get()).hud_optimization) {
            activeModules.add("Target HUD");
        }
        if (((BlockEntityOptimizerConfig)this.configHolder.get()).head_optimization) {
            activeModules.add("China Hat");
        }
        if (((BlockEntityOptimizerConfig)this.configHolder.get()).sound) {
            activeModules.add("Sounds");
        }
        if (((BlockEntityOptimizerConfig)this.configHolder.get()).swing) {
            activeModules.add("Swing Hand");
        }
        this.updateModuleStates(activeModules);
        ArrayList<String> sortedModules = new ArrayList<String>(this.moduleStates.keySet());
        sortedModules.sort((a, b) -> Integer.compare(textRenderer.method_1727(b), textRenderer.method_1727(a)));
        int tick = (int)(this.mc.field_1687.method_8510() % 100L);
        for (int i = 0; i < sortedModules.size(); ++i) {
            String moduleName = (String)sortedModules.get(i);
            ModuleState state = this.moduleStates.get(moduleName);
            int targetX = screenWidth - textRenderer.method_1727(moduleName) - 10;
            int animatedX = (int)this.interpolate(state.getAnimationProgress(tickDelta), screenWidth, targetX);
            int waveDelay = i * 10;
            int colorTick = (tick + waveDelay) % 100;
            float t = (float)colorTick / 100.0f;
            t = (float)(0.5 * (1.0 + Math.sin((double)(t * 2.0f) * Math.PI)));
            int color = this.interpolateColor(((BlockEntityOptimizerConfig)this.configHolder.get()).start_color, ((BlockEntityOptimizerConfig)this.configHolder.get()).end_color, t);
            if (((BlockEntityOptimizerConfig)this.configHolder.get()).list_optimization_glow) {
                this.drawGlowingText(drawContext, textRenderer, moduleName, animatedX, y, color, new Color(color).darker().darker().getRGB());
            }
            drawContext.method_51439(textRenderer, class_2561.method_30163((String)moduleName), animatedX, y, color, true);
            if (state.getAnimationProgress(tickDelta) <= 0.0f && !state.isEnabled()) {
                this.moduleStates.remove(moduleName);
            }
            y += 11;
        }
    }

    private void drawGlowingText(class_332 drawContext, class_327 textRenderer, String text, int x, int y, int color, int glowColor) {
        int glowRadius = 3;
        for (int dx = -glowRadius; dx <= glowRadius; ++dx) {
            for (int dy = -glowRadius; dy <= glowRadius; ++dy) {
                int distance;
                int alpha;
                if (Math.abs(dx) + Math.abs(dy) > glowRadius || dx == 0 && dy == 0 || (alpha = (int)(255.0f * (0.5f * (1.0f - (float)(distance = (int)Math.sqrt(dx * dx + dy * dy)) / (float)glowRadius)))) <= 0) continue;
                int glowingColor = alpha << 24 | glowColor & 0xFFFFFF;
                drawContext.method_51439(textRenderer, class_2561.method_30163((String)text), x + dx, y + dy, glowingColor, false);
            }
        }
        drawContext.method_51439(textRenderer, class_2561.method_30163((String)text), x, y, color, true);
    }

    private void updateModuleStates(List<String> activeModules) {
        ModuleState state;
        for (String module : activeModules) {
            state = this.moduleStates.computeIfAbsent(module, k -> new ModuleState());
            if (state.isEnabled()) continue;
            if (((BlockEntityOptimizerConfig)this.configHolder.get()).sound) {
                this.mc.field_1724.method_5783(SoupSound.ON, (float)((BlockEntityOptimizerConfig)this.configHolder.get()).sound_volume / 100.0f, 1.0f);
            }
            state.setEnabled(true);
            state.resetAnimation();
        }
        for (String module : new ArrayList<String>(this.moduleStates.keySet())) {
            if (activeModules.contains(module) || !(state = this.moduleStates.get(module)).isEnabled()) continue;
            if (((BlockEntityOptimizerConfig)this.configHolder.get()).sound) {
                this.mc.field_1724.method_5783(SoupSound.OFF, (float)((BlockEntityOptimizerConfig)this.configHolder.get()).sound_volume / 100.0f, 1.0f);
            }
            state.setEnabled(false);
            state.startReverseAnimation();
        }
    }

    private float interpolate(float progress, float start, float end) {
        return start + progress * (end - start);
    }

    private int interpolateColor(int color1, int color2, float t) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }

    private static class ModuleState {
        private boolean enabled = false;
        private float animationProgress = 0.0f;
        private static final float ANIMATION_SPEED = 0.1f;
        private boolean reverseAnimation = false;

        private ModuleState() {
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void resetAnimation() {
            this.animationProgress = 0.0f;
            this.reverseAnimation = false;
        }

        public void startReverseAnimation() {
            this.reverseAnimation = true;
        }

        public float getAnimationProgress(float tickDelta) {
            this.animationProgress = this.reverseAnimation ? (this.animationProgress > 0.0f ? (this.animationProgress -= 0.1f * tickDelta) : 0.0f) : (this.animationProgress < 1.0f ? (this.animationProgress += 0.1f * tickDelta) : 1.0f);
            return this.animationProgress;
        }
    }
}

