/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.listsoptimizer;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;

public class FriendCommandClient {
    private static final String CONFIG_PATH = "config/soupapi/Friends.txt";
    private static List<String> cachedFriends = new ArrayList<String>();
    private static final long CACHE_UPDATE_INTERVAL = 60000L;
    private static final String KEYSTORE_PATH = "config/soupapi.keystore";
    private static final String KEYSTORE_PASSWORD = "soupapi";
    private static final String KEY_ALIAS = "soupapi_key";
    private static SecretKey secretKey;

    public static void register() {
        FriendCommandClient.ensureConfigDirectory();
        FriendCommandClient.initializeKeyStore();
        ClientCommandRegistrationCallback.EVENT.register(FriendCommandClient::registerCommands);
        FriendCommandClient.loadFriendsFromFile();
        FriendCommandClient.addClientToFriends();
        FriendCommandClient.startCacheUpdateThread();
    }

    private static void initializeKeyStore() {
        block13: {
            try {
                File keystoreFile = new File(KEYSTORE_PATH);
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                if (!keystoreFile.exists()) {
                    keyStore.load(null, KEYSTORE_PASSWORD.toCharArray());
                    KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                    keyGen.init(256);
                    secretKey = keyGen.generateKey();
                    KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(secretKey);
                    KeyStore.PasswordProtection protection = new KeyStore.PasswordProtection(KEYSTORE_PASSWORD.toCharArray());
                    keyStore.setEntry(KEY_ALIAS, entry, protection);
                    try (FileOutputStream fos = new FileOutputStream(keystoreFile);){
                        keyStore.store(fos, KEYSTORE_PASSWORD.toCharArray());
                        break block13;
                    }
                }
                try (FileInputStream fis = new FileInputStream(keystoreFile);){
                    keyStore.load(fis, KEYSTORE_PASSWORD.toCharArray());
                }
                KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)keyStore.getEntry(KEY_ALIAS, new KeyStore.PasswordProtection(KEYSTORE_PASSWORD.toCharArray()));
                secretKey = entry.getSecretKey();
            }
            catch (Exception e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 KeyStore", e);
            }
        }
    }

    private static void ensureConfigDirectory() {
        try {
            Path configDir = Path.of("config/soupapi", new String[0]);
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e \u043a\u043e\u043d\u0444\u0438\u0433\u0430", e);
        }
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"frd").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(FriendCommandClient::suggestOnlinePlayers).executes(FriendCommandClient::addFriend)))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(FriendCommandClient::suggestFriends).executes(FriendCommandClient::removeFriend))));
    }

    private static void loadFriendsFromFile() {
        try {
            cachedFriends = Files.lines(Path.of(CONFIG_PATH, new String[0])).map(FriendCommandClient::decrypt).collect(Collectors.toList());
        }
        catch (IOException e) {
            cachedFriends = new ArrayList<String>();
        }
    }

    private static void addClientToFriends() {
        String clientName = class_310.method_1551().method_1548().method_1676();
        if (!cachedFriends.contains(clientName)) {
            try {
                String encrypted = FriendCommandClient.encrypt(clientName);
                Files.writeString(Path.of(CONFIG_PATH, new String[0]), (CharSequence)(encrypted + System.lineSeparator()), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                cachedFriends.add(clientName);
                System.out.println("Client username added to friends list: " + clientName);
            }
            catch (IOException e) {
                System.err.println("Error while adding client username to friends list: " + e.getMessage());
            }
        }
    }

    private static void startCacheUpdateThread() {
        Thread cacheUpdateThread = new Thread(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(60000L);
                    FriendCommandClient.loadFriendsFromFile();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }, "FriendList-Cache-Updater");
        cacheUpdateThread.setDaemon(true);
        cacheUpdateThread.start();
    }

    public static boolean isFriend(String playerName) {
        return cachedFriends.contains(playerName);
    }

    private static CompletableFuture<Suggestions> suggestOnlinePlayers(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        List playerNames = class_310.method_1551().method_1562().method_2880().stream().map(playerInfo -> playerInfo.method_2966().getName()).collect(Collectors.toList());
        return class_2172.method_9265(playerNames, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestFriends(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(cachedFriends, (SuggestionsBuilder)builder);
    }

    private static int addFriend(CommandContext<FabricClientCommandSource> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        try {
            String encrypted = FriendCommandClient.encrypt(playerName);
            Files.writeString(Path.of(CONFIG_PATH, new String[0]), (CharSequence)(encrypted + System.lineSeparator()), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            cachedFriends.add(playerName);
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("Added friend: " + playerName)));
        }
        catch (IOException e) {
            ((FabricClientCommandSource)context.getSource()).sendError(class_2561.method_30163((String)("Error while adding friend: " + e.getMessage())));
        }
        return 1;
    }

    private static int removeFriend(CommandContext<FabricClientCommandSource> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        try {
            File file = new File(CONFIG_PATH);
            if (!file.exists()) {
                ((FabricClientCommandSource)context.getSource()).sendError(class_2561.method_30163((String)"Friend list does not exist."));
                return 0;
            }
            File tempFile = new File(file.getAbsolutePath() + ".tmp");
            try (BufferedReader reader = new BufferedReader(new FileReader(file));
                 PrintWriter writer = new PrintWriter(new FileWriter(tempFile));){
                String line;
                boolean found = false;
                while ((line = reader.readLine()) != null) {
                    String decryptedName = FriendCommandClient.decrypt(line);
                    if (decryptedName.equals(playerName)) {
                        found = true;
                        continue;
                    }
                    writer.println(line);
                }
                if (found) {
                    cachedFriends.remove(playerName);
                    ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("Removed friend: " + playerName)));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendError(class_2561.method_30163((String)("Friend not found: " + playerName)));
                }
            }
            if (!file.delete()) {
                ((FabricClientCommandSource)context.getSource()).sendError(class_2561.method_30163((String)"Could not delete original file."));
            }
            if (!tempFile.renameTo(file)) {
                ((FabricClientCommandSource)context.getSource()).sendError(class_2561.method_30163((String)"Could not rename temp file."));
            }
        }
        catch (IOException e) {
            ((FabricClientCommandSource)context.getSource()).sendError(class_2561.method_30163((String)("Error while removing friend: " + e.getMessage())));
        }
        return 1;
    }

    private static String encrypt(String input) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] iv = new byte[12];
            new SecureRandom().nextBytes(iv);
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secretKey, parameterSpec);
            byte[] encryptedData = cipher.doFinal(input.getBytes());
            byte[] message = new byte[iv.length + encryptedData.length];
            System.arraycopy(iv, 0, message, 0, iv.length);
            System.arraycopy(encryptedData, 0, message, iv.length, encryptedData.length);
            return Base64.getEncoder().encodeToString(message);
        }
        catch (Exception e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0448\u0438\u0444\u0440\u043e\u0432\u0430\u043d\u0438\u044f", e);
        }
    }

    public static String decrypt(String encryptedString) {
        try {
            byte[] decoded = Base64.getDecoder().decode(encryptedString);
            byte[] iv = new byte[12];
            System.arraycopy(decoded, 0, iv, 0, iv.length);
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)secretKey, parameterSpec);
            byte[] encryptedData = new byte[decoded.length - 12];
            System.arraycopy(decoded, 12, encryptedData, 0, encryptedData.length);
            return new String(cipher.doFinal(encryptedData));
        }
        catch (Exception e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u043a\u0438", e);
        }
    }
}

