/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.rendersoptimization;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1684;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.ChSP.soupapi.SoupApi;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerConfig;
import org.ChSP.soupapi.rendersoptimization.CirclesRenderer;
import org.joml.Matrix4f;

public class TrajectoryPredict
implements ClientModInitializer {
    private final class_310 client = class_310.method_1551();
    private final Set<class_1684> snowballs = new HashSet<class_1684>();

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        WorldRenderEvents.AFTER_ENTITIES.register(this::onWorldRender);
    }

    private void onClientTick(class_310 client) {
        if (SoupApi.PANIC || !((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).render_line_optimization) {
            return;
        }
        if (client.field_1687 != null) {
            for (class_1297 entity : client.field_1687.method_18112()) {
                class_1684 snowball;
                if (!(entity instanceof class_1684) || this.snowballs.contains(snowball = (class_1684)entity)) continue;
                this.snowballs.add(snowball);
            }
        }
        this.snowballs.removeIf(class_1297::method_31481);
    }

    private void onWorldRender(WorldRenderContext context) {
        class_4587 matrices = context.matrixStack();
        class_243 cameraPos = context.camera().method_19326();
        float tickDelta = context.tickCounter().method_60637(true);
        for (class_1684 snowball : this.snowballs) {
            this.renderTrajectory(matrices, snowball, cameraPos, tickDelta);
        }
    }

    private void renderTrajectory(class_4587 matrices, class_1684 snowball, class_243 cameraPos, float tickDelta) {
        class_243 start = snowball.method_19538().method_1020(cameraPos);
        class_243 velocity = snowball.method_18798();
        double gravity = -0.035;
        ArrayList<class_243> trajectoryPoints = new ArrayList<class_243>();
        class_243 lastPos = start;
        for (double time = 0.0; time < 300.0; time += 0.2) {
            double x = start.field_1352 + velocity.field_1352 * time;
            double y = start.field_1351 + velocity.field_1351 * time + 0.5 * gravity * time * time;
            double z = start.field_1350 + velocity.field_1350 * time;
            class_243 currentPos = new class_243(x, y, z);
            class_3965 hitResult = this.client.field_1687.method_17742(new class_3959(lastPos.method_1019(cameraPos), currentPos.method_1019(cameraPos), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)snowball));
            if (hitResult.method_17783() == class_239.class_240.field_1332) {
                trajectoryPoints.add(hitResult.method_17784().method_1020(cameraPos));
                break;
            }
            trajectoryPoints.add(currentPos);
            lastPos = currentPos;
        }
        this.renderGlowLine(matrices, trajectoryPoints, tickDelta);
    }

    private void renderGlowLine(class_4587 matrices, List<class_243> points, float tickDelta) {
        if (points.size() < 2) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableCull();
        Matrix4f modelMatrix = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        int glowLayers = 7;
        float layerSpacing = 0.03f;
        float width = 0.065f;
        Color startColor = new Color(((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).start_color);
        Color endColor = new Color(((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).end_color);
        long gameTime = System.currentTimeMillis() % 1000L + (long)(tickDelta * 1000.0f);
        for (int layer = 0; layer < glowLayers; ++layer) {
            float layerAlpha = 0.5882353f * (1.0f - (float)layer / (float)glowLayers);
            class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
            for (int i = 0; i < points.size() - 1; ++i) {
                class_243 start = points.get(i);
                class_243 end = points.get(i + 1);
                class_243 direction = end.method_1020(start).method_1029();
                class_243 perpendicular = new class_243(-direction.field_1350, 0.0, direction.field_1352).method_1021((double)(width / 2.0f + (float)layer * layerSpacing));
                float waveOffset = (float)((gameTime + (long)(i * 200)) % 1000L) / 1000.0f;
                float colorInterpolation = class_3532.method_15363((float)(((float)i + waveOffset) / (float)(points.size() - 1)), (float)0.0f, (float)1.0f);
                Color currentColor = this.interpolateColor(startColor, endColor, colorInterpolation);
                int red = currentColor.getRed();
                int green = currentColor.getGreen();
                int blue = currentColor.getBlue();
                matrices.method_22903();
                matrices.method_22904(start.field_1352, start.field_1351, start.field_1350);
                buffer.method_22918(matrices.method_23760().method_23761(), (float)(start.field_1352 + perpendicular.field_1352), (float)start.field_1351, (float)(start.field_1350 + perpendicular.field_1350)).method_1336(red, green, blue, (int)(layerAlpha * 255.0f));
                buffer.method_22918(matrices.method_23760().method_23761(), (float)(start.field_1352 - perpendicular.field_1352), (float)start.field_1351, (float)(start.field_1350 - perpendicular.field_1350)).method_1336(red, green, blue, (int)(layerAlpha * 255.0f));
                matrices.method_22909();
            }
            class_286.method_43433((class_9801)buffer.method_60800());
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private Color interpolateColor(Color startColor, Color endColor, float fraction) {
        int red = class_3532.method_15340((int)((int)((float)startColor.getRed() + (float)(endColor.getRed() - startColor.getRed()) * fraction)), (int)0, (int)255);
        int green = class_3532.method_15340((int)((int)((float)startColor.getGreen() + (float)(endColor.getGreen() - startColor.getGreen()) * fraction)), (int)0, (int)255);
        int blue = class_3532.method_15340((int)((int)((float)startColor.getBlue() + (float)(endColor.getBlue() - startColor.getBlue()) * fraction)), (int)0, (int)255);
        return new Color(red, green, blue);
    }
}

