/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.rendersoptimization.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import net.minecraft.class_9801;
import org.ChSP.soupapi.SoupApi;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerConfig;
import org.ChSP.soupapi.listsoptimizer.FriendCommandClient;
import org.ChSP.soupapi.rendersoptimization.CirclesRenderer;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_922.class})
public abstract class CHatMixin<T extends class_1309> {
    @Inject(method={"render*"}, at={@At(value="HEAD")})
    private void renderChinaHatDown(T entity, float f, float g, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        class_1657 player;
        if (SoupApi.PANIC || !((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).head_optimization) {
            return;
        }
        if (entity instanceof class_1657 && FriendCommandClient.isFriend((player = (class_1657)entity).method_5477().getString())) {
            this.renderChinaHatCircle(matrices, player, g, true);
        }
    }

    @Inject(method={"render*"}, at={@At(value="TAIL")})
    private void renderChinaHatUp(T entity, float f, float g, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        class_1657 player;
        if (SoupApi.PANIC || !((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).head_optimization) {
            return;
        }
        if (entity instanceof class_1657 && FriendCommandClient.isFriend((player = (class_1657)entity).method_5477().getString())) {
            this.renderChinaHatCircle(matrices, player, g, false);
        }
    }

    @Unique
    private void renderChinaHatCircle(class_4587 matrices, class_1657 player, float tickDelta, boolean isDown) {
        matrices.method_22903();
        float eyeHeight = player.method_5751();
        matrices.method_22904(0.0, (double)eyeHeight + 0.132, 0.0);
        float yaw = player.field_5982 + (player.method_36454() - player.field_5982) * tickDelta;
        float pitch = player.field_6004 + (player.method_36455() - player.field_6004) * tickDelta;
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-yaw));
        matrices.method_22904(0.0, -Math.sin(Math.toRadians(pitch)) * 0.075, 0.0);
        float radius = 0.6f;
        float rotationSpeed = 5.7f;
        float rotationAngle = (tickDelta + (float)player.field_6012) * rotationSpeed % 360.0f;
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rotationAngle));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableDepthTest();
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        Matrix4f modelMatrix = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        Color baseColor1 = new Color(((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).start_color);
        Color baseColor2 = new Color(((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).end_color);
        Color color1 = isDown ? baseColor1.darker().darker() : baseColor1;
        Color color2 = isDown ? baseColor2.darker().darker() : baseColor2;
        buffer.method_22918(modelMatrix, 0.0f, 0.38f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 0.55f);
        int circleSegments = isDown ? 40 : -40;
        int i = 0;
        while (isDown ? i <= circleSegments : i >= circleSegments) {
            double angle = Math.toRadians(i * 9);
            float x = (float)(Math.sin(angle) * (double)radius);
            float z = (float)(-Math.cos(angle) * (double)radius);
            float gradientPosition = (float)i / (float)circleSegments;
            Color interpolatedColor = this.interpolateColor(color1, color2, gradientPosition);
            buffer.method_22918(modelMatrix, x, 0.0f, z).method_22915((float)interpolatedColor.getRed() / 255.0f, (float)interpolatedColor.getGreen() / 255.0f, (float)interpolatedColor.getBlue() / 255.0f, (float)((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).head_optimization_alpha / 100.0f);
            i += isDown ? 1 : -1;
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        matrices.method_22909();
    }

    @Unique
    private Color interpolateColor(Color color1, Color color2, float position) {
        float interpFactor = position <= 0.5f ? position * 2.0f : (position - 0.5f) * 2.0f;
        boolean isFirstHalf = position <= 0.5f;
        int red = class_3532.method_48781((float)interpFactor, (int)(isFirstHalf ? color1.getRed() : color2.getRed()), (int)(isFirstHalf ? color2.getRed() : color1.getRed()));
        int green = class_3532.method_48781((float)interpFactor, (int)(isFirstHalf ? color1.getGreen() : color2.getGreen()), (int)(isFirstHalf ? color2.getGreen() : color1.getGreen()));
        int blue = class_3532.method_48781((float)interpFactor, (int)(isFirstHalf ? color1.getBlue() : color2.getBlue()), (int)(isFirstHalf ? color2.getBlue() : color1.getBlue()));
        return new Color(red, green, blue);
    }
}

