/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.blockentityoptimizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.class_238;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerConfig;

public abstract class BlockEntityOptimizerGroup {
    private final ConfigHolder<BlockEntityOptimizerConfig> configHolder;
    private final ToIntFunction<BlockEntityOptimizerConfig> color;
    private final Predicate<BlockEntityOptimizerConfig> enabled;
    protected final ArrayList<class_238> boxes = new ArrayList();

    public BlockEntityOptimizerGroup(ConfigHolder<BlockEntityOptimizerConfig> configHolder, ToIntFunction<BlockEntityOptimizerConfig> color, Predicate<BlockEntityOptimizerConfig> enabled) {
        this.configHolder = Objects.requireNonNull(configHolder);
        this.color = Objects.requireNonNull(color);
        this.enabled = enabled;
    }

    public void clear() {
        this.boxes.clear();
    }

    public boolean isEnabled() {
        return this.enabled == null || this.enabled.test((BlockEntityOptimizerConfig)this.configHolder.get());
    }

    public float[] getColorF() {
        int colorI = this.color.applyAsInt((BlockEntityOptimizerConfig)this.configHolder.get());
        float red = (float)(colorI >> 16 & 0xFF) / 255.0f;
        float green = (float)(colorI >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colorI & 0xFF) / 255.0f;
        return new float[]{red, green, blue};
    }

    public List<class_238> getBoxes() {
        return Collections.unmodifiableList(this.boxes);
    }
}

