/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.rendersoptimization;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.ChSP.soupapi.SoupApi;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerConfig;
import org.ChSP.soupapi.listsoptimizer.FriendCommandClient;
import org.ChSP.soupapi.rendersoptimization.CirclesRenderer;
import org.joml.Matrix4f;

public class Rail
implements ModInitializer {
    private final Map<UUID, PlayerTrail> playerTrails = new HashMap<UUID, PlayerTrail>();
    private static final float SEGMENT_LIFETIME = 1.35f;
    private static final float FADE_IN_TIME = 0.2f;

    public void onInitialize() {
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register(this::onRender);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> this.onDimensionChange(client));
    }

    private void onDimensionChange(class_310 client) {
        this.playerTrails.clear();
    }

    private void onClientTick(class_310 client) {
        if (SoupApi.PANIC || !((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).rail_optimization) {
            return;
        }
        if (CirclesRenderer.mc.field_1724 == null) {
            return;
        }
        for (class_1657 player : client.field_1687.method_18456()) {
            UUID playerId = player.method_5667();
            class_243 playerPos = player.method_19538();
            PlayerTrail trail = this.playerTrails.computeIfAbsent(playerId, id -> new PlayerTrail());
            if (!FriendCommandClient.isFriend(player.method_5477().getString())) {
                trail.lastPosition = null;
                continue;
            }
            if (trail.lastPosition != null) {
                double delta = client.method_1488();
                class_243 interpolatedPos = trail.lastPosition.method_35590(playerPos, delta);
                trail.segments.add(new TrailSegment(interpolatedPos));
            }
            trail.lastPosition = playerPos;
            trail.segments.removeIf(segment -> segment.age >= 1.35f);
            for (TrailSegment segment2 : trail.segments) {
                segment2.age += client.method_1488();
            }
        }
    }

    private void onRender(WorldRenderContext context) {
        if (SoupApi.PANIC || !((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).rail_optimization) {
            return;
        }
        class_4587 matrices = context.matrixStack();
        class_243 cameraPos = context.camera().method_19326();
        class_310 client = class_310.method_1551();
        for (Map.Entry<UUID, PlayerTrail> entry : this.playerTrails.entrySet()) {
            class_1657 player;
            PlayerTrail trail = entry.getValue();
            if (trail.segments.isEmpty() || (player = client.field_1687.method_18470(entry.getKey())) == null || player == client.field_1724 && client.field_1690.method_31044().method_31034()) continue;
            this.renderTrail(matrices, cameraPos, trail.segments);
        }
    }

    private void renderTrail(class_4587 matrices, class_243 cameraPos, List<TrailSegment> segments) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableCull();
        Matrix4f modelMatrix = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        for (int i = 0; i < segments.size() - 1; ++i) {
            TrailSegment startSegment = segments.get(i);
            TrailSegment endSegment = segments.get(i + 1);
            class_243 start = startSegment.position.method_1020(cameraPos);
            class_243 end = endSegment.position.method_1020(cameraPos);
            int startAlpha = this.calculateAlpha(startSegment.age);
            int endAlpha = this.calculateAlpha(endSegment.age);
            int startColor = this.interpolateColor(((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).start_color, ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).end_color, startSegment.age / 1.35f);
            int endColor = this.interpolateColor(((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).start_color, ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).end_color, endSegment.age / 1.35f);
            buffer.method_22918(modelMatrix, (float)start.field_1352, (float)start.field_1351, (float)start.field_1350).method_1336(this.getRed(startColor), this.getGreen(startColor), this.getBlue(startColor), startAlpha).method_1344();
            buffer.method_22918(modelMatrix, (float)start.field_1352, (float)start.field_1351 + class_310.method_1551().field_1724.method_17682(), (float)start.field_1350).method_1336(this.getRed(startColor), this.getGreen(startColor), this.getBlue(startColor), startAlpha).method_1344();
            buffer.method_22918(modelMatrix, (float)end.field_1352, (float)end.field_1351 + class_310.method_1551().field_1724.method_17682(), (float)end.field_1350).method_1336(this.getRed(endColor), this.getGreen(endColor), this.getBlue(endColor), endAlpha).method_1344();
            buffer.method_22918(modelMatrix, (float)end.field_1352, (float)end.field_1351, (float)end.field_1350).method_1336(this.getRed(endColor), this.getGreen(endColor), this.getBlue(endColor), endAlpha).method_1344();
        }
        tessellator.method_1350();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private int calculateAlpha(float age) {
        if (age < 0.2f) {
            return (int)(255.0f * (age / 0.2f));
        }
        if (age < 1.35f) {
            return (int)(255.0f * (1.0f - (age - 0.2f) / 1.15f));
        }
        return 0;
    }

    private int interpolateColor(int startColor, int endColor, float factor) {
        int startRed = startColor >> 16 & 0xFF;
        int startGreen = startColor >> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endRed = endColor >> 16 & 0xFF;
        int endGreen = endColor >> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        int red = (int)((float)startRed + (float)(endRed - startRed) * factor);
        int green = (int)((float)startGreen + (float)(endGreen - startGreen) * factor);
        int blue = (int)((float)startBlue + (float)(endBlue - startBlue) * factor);
        return red << 16 | green << 8 | blue;
    }

    private int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    private int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    private int getBlue(int color) {
        return color & 0xFF;
    }

    private static class PlayerTrail {
        List<TrailSegment> segments = new ArrayList<TrailSegment>();
        class_243 lastPosition;

        private PlayerTrail() {
        }
    }

    private static class TrailSegment {
        class_243 position;
        float age;

        TrailSegment(class_243 position) {
            this.position = position;
            this.age = 0.0f;
        }
    }
}

