/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.listsoptimizer;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;

public class FriendCommandClient {
    private static final String CONFIG_PATH = "config/friends_sapi.txt";
    private static List<String> cachedFriends = new ArrayList<String>();
    private static long lastCacheUpdateTime = 0L;
    private static final long CACHE_UPDATE_INTERVAL = 60000L;

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register(FriendCommandClient::registerCommands);
        FriendCommandClient.loadFriendsFromFile();
        FriendCommandClient.addClientToFriends();
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"frd").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(FriendCommandClient::suggestOnlinePlayers).executes(FriendCommandClient::addFriend)))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(FriendCommandClient::suggestFriends).executes(FriendCommandClient::removeFriend))));
    }

    private static void loadFriendsFromFile() {
        try {
            cachedFriends = Files.lines(Path.of(CONFIG_PATH, new String[0])).map(FriendCommandClient::decodeTwice).collect(Collectors.toList());
            lastCacheUpdateTime = System.currentTimeMillis();
        }
        catch (IOException e) {
            cachedFriends = new ArrayList<String>();
        }
    }

    private static void addClientToFriends() {
        String clientName = class_310.method_1551().method_1548().method_1676();
        if (!cachedFriends.contains(clientName)) {
            try {
                String encoded = FriendCommandClient.encodeTwice(clientName);
                Files.writeString(Path.of(CONFIG_PATH, new String[0]), (CharSequence)(encoded + System.lineSeparator()), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                cachedFriends.add(clientName);
                System.out.println("Client username added to friends list: " + clientName);
            }
            catch (IOException e) {
                System.err.println("Error while adding client username to friends list: " + e.getMessage());
            }
        }
    }

    public static boolean isFriend(String playerName) {
        if (System.currentTimeMillis() - lastCacheUpdateTime > 60000L) {
            FriendCommandClient.loadFriendsFromFile();
        }
        return cachedFriends.contains(playerName);
    }

    private static CompletableFuture<Suggestions> suggestOnlinePlayers(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        List playerNames = class_310.method_1551().method_1562().method_2880().stream().map(playerInfo -> playerInfo.method_2966().getName()).collect(Collectors.toList());
        return class_2172.method_9265(playerNames, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestFriends(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(cachedFriends, (SuggestionsBuilder)builder);
    }

    private static int addFriend(CommandContext<FabricClientCommandSource> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        try {
            String encoded = FriendCommandClient.encodeTwice(playerName);
            Files.writeString(Path.of(CONFIG_PATH, new String[0]), (CharSequence)(encoded + System.lineSeparator()), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            cachedFriends.add(playerName);
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("Added friend: " + playerName)));
        }
        catch (IOException e) {
            ((FabricClientCommandSource)context.getSource()).sendError(class_2561.method_30163((String)("Error while adding friend: " + e.getMessage())));
        }
        return 1;
    }

    private static int removeFriend(CommandContext<FabricClientCommandSource> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        try {
            String encoded = FriendCommandClient.encodeTwice(playerName);
            File file = new File(CONFIG_PATH);
            if (!file.exists()) {
                ((FabricClientCommandSource)context.getSource()).sendError(class_2561.method_30163((String)"Friend list does not exist."));
                return 0;
            }
            File tempFile = new File(file.getAbsolutePath() + ".tmp");
            try (BufferedReader reader = new BufferedReader(new FileReader(file));
                 PrintWriter writer = new PrintWriter(new FileWriter(tempFile));){
                String line;
                boolean found = false;
                while ((line = reader.readLine()) != null) {
                    if (line.equals(encoded)) {
                        found = true;
                        continue;
                    }
                    writer.println(line);
                }
                if (found) {
                    cachedFriends.remove(playerName);
                    ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("Removed friend: " + playerName)));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendError(class_2561.method_30163((String)("Friend not found: " + playerName)));
                }
            }
            if (!file.delete()) {
                ((FabricClientCommandSource)context.getSource()).sendError(class_2561.method_30163((String)"Could not delete original file."));
            }
            if (!tempFile.renameTo(file)) {
                ((FabricClientCommandSource)context.getSource()).sendError(class_2561.method_30163((String)"Could not rename temp file."));
            }
        }
        catch (IOException e) {
            ((FabricClientCommandSource)context.getSource()).sendError(class_2561.method_30163((String)("Error while removing friend: " + e.getMessage())));
        }
        return 1;
    }

    private static String encodeTwice(String input) {
        byte[] firstEncoding = Base64.getEncoder().encode(input.getBytes());
        return Base64.getEncoder().encodeToString(firstEncoding);
    }

    public static String decodeTwice(String input) {
        byte[] firstDecoding = Base64.getDecoder().decode(input);
        return new String(Base64.getDecoder().decode(firstDecoding));
    }
}

