/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.rendersoptimization;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.ChSP.soupapi.SoupApi;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerConfig;
import org.ChSP.soupapi.rendersoptimization.CircleRenderStyle;
import org.joml.Matrix4f;

public class CirclesRenderer
implements ClientModInitializer {
    static final class_310 mc = class_310.method_1551();
    private final List<JumpCircle> circles = new ArrayList<JumpCircle>();
    public static ConfigHolder<BlockEntityOptimizerConfig> configHolder;
    private boolean wasJumping = false;

    public void onInitializeClient() {
        configHolder = AutoConfig.getConfigHolder(BlockEntityOptimizerConfig.class);
        WorldRenderEvents.AFTER_ENTITIES.register(this::onWorldRender);
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
    }

    private void onClientTick(class_310 client) {
        if (SoupApi.PANIC) {
            return;
        }
        if (CirclesRenderer.mc.field_1724 != null) {
            boolean isJumping;
            class_746 player = CirclesRenderer.mc.field_1724;
            boolean bl = isJumping = !player.method_24828();
            if (isJumping && !this.wasJumping && CirclesRenderer.mc.field_1690.field_1903.method_1434()) {
                this.circles.add(new JumpCircle(CirclesRenderer.mc.field_1724.method_19538(), ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).render_circle_style));
            }
            this.wasJumping = isJumping;
        }
    }

    private void onWorldRender(WorldRenderContext context) {
        if (!((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).render_circle_optimization || SoupApi.PANIC) {
            if (!this.circles.isEmpty()) {
                this.circles.clear();
            }
            return;
        }
        class_4587 matrices = context.matrixStack();
        double cameraX = context.camera().method_19326().field_1352;
        double cameraY = context.camera().method_19326().field_1351;
        double cameraZ = context.camera().method_19326().field_1350;
        this.renderJumpCircles(matrices, cameraX, cameraY, cameraZ);
    }

    private void renderJumpCircles(class_4587 matrices, double cameraX, double cameraY, double cameraZ) {
        Iterator<JumpCircle> iterator = this.circles.iterator();
        while (iterator.hasNext()) {
            JumpCircle circle = iterator.next();
            if (circle.isExpired()) {
                iterator.remove();
                continue;
            }
            circle.render(matrices, cameraX, cameraY, cameraZ);
        }
    }

    private static class JumpCircle {
        private final class_243 position;
        private int age;
        private final CircleRenderStyle style;

        public JumpCircle(class_243 position, CircleRenderStyle style) {
            this.position = position;
            this.style = style;
            this.age = 0;
        }

        public boolean isExpired() {
            return this.age > ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).render_circle_live_time;
        }

        public void render(class_4587 matrices, double cameraX, double cameraY, double cameraZ) {
            BlockEntityOptimizerConfig config = (BlockEntityOptimizerConfig)configHolder.getConfig();
            ++this.age;
            double x = this.position.field_1352 - cameraX;
            double y = this.position.field_1351 - cameraY - 0.25;
            double z = this.position.field_1350 - cameraZ;
            float ageFraction = (float)this.age / (float)config.render_circle_live_time;
            float radius = class_3532.method_16439((float)ageFraction, (float)0.0f, (float)((float)config.render_circle_max / 100.0f));
            float alpha = class_3532.method_16439((float)ageFraction, (float)1.0f, (float)0.0f);
            alpha = class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.disableCull();
            Matrix4f modelMatrix = matrices.method_23760().method_23761();
            if (this.style == CircleRenderStyle.FADE) {
                this.renderFadeCircle(modelMatrix, x, y, z, radius, alpha);
            } else if (this.style == CircleRenderStyle.GLOW) {
                this.renderGlowCircle(modelMatrix, x, y, z, radius, alpha);
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
        }

        private void renderFadeCircle(Matrix4f modelMatrix, double x, double y, double z, float radius, float alpha) {
            BlockEntityOptimizerConfig config = (BlockEntityOptimizerConfig)configHolder.getConfig();
            Color centerColor = new Color(config.start_color);
            Color ringColor = new Color(config.end_color);
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            buffer.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            buffer.method_22918(modelMatrix, (float)x, (float)y + 0.1f, (float)z).method_1336(centerColor.getRed(), centerColor.getGreen(), centerColor.getBlue(), (int)(alpha * (float)config.render_circle_center_alpha)).method_1344();
            int circleSegments = 60;
            for (int i = 0; i <= circleSegments; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)circleSegments;
                float dx = class_3532.method_15362((float)((float)angle)) * radius;
                float dz = class_3532.method_15374((float)((float)angle)) * radius;
                buffer.method_22918(modelMatrix, (float)x + dx, (float)y + 0.1f, (float)z + dz).method_1336(ringColor.getRed(), ringColor.getGreen(), ringColor.getBlue(), (int)(alpha * (float)config.render_circle_side_alpha)).method_1344();
            }
            tessellator.method_1350();
        }

        private void renderGlowCircle(Matrix4f modelMatrix, double x, double y, double z, float maxRadius, float alpha) {
            Color startColor = new Color(((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).start_color);
            Color endColor = new Color(((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).end_color);
            int glowAlpha = 150;
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            int circleSegments = 50;
            float baseThickness = 0.0125f;
            int glowLayers = 7;
            float layerSpacing = 0.03f;
            float ageFraction = (float)this.age / (float)((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).render_circle_live_time;
            ageFraction *= 3.0f;
            ageFraction = class_3532.method_15363((float)ageFraction, (float)0.0f, (float)1.0f);
            for (int layer = 0; layer < glowLayers; ++layer) {
                float interpolatedRadius = class_3532.method_16439((float)ageFraction, (float)0.0f, (float)maxRadius);
                float layerRadius = interpolatedRadius + (float)layer * layerSpacing;
                float layerAlpha = class_3532.method_15363((float)(ageFraction * (1.0f - (float)layer / (float)glowLayers)), (float)0.0f, (float)1.0f);
                layerAlpha *= alpha;
                float layerThickness = baseThickness * (float)(glowLayers - layer);
                buffer.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
                int rotation = 360 / ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).render_circle_spin_speed;
                float rotationOffset = (float)(this.age % rotation) / (float)rotation;
                for (int i = 0; i <= circleSegments; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)circleSegments;
                    float innerDx = class_3532.method_15362((float)((float)angle)) * layerRadius;
                    float innerDz = class_3532.method_15374((float)((float)angle)) * layerRadius;
                    float outerDx = class_3532.method_15362((float)((float)angle)) * (layerRadius + layerThickness);
                    float outerDz = class_3532.method_15374((float)((float)angle)) * (layerRadius + layerThickness);
                    float interpolatedAge = this.getWaveInterpolation(angle, rotationOffset);
                    Color currentColor = this.interpolateColor(startColor, endColor, interpolatedAge);
                    int red = currentColor.getRed();
                    int green = currentColor.getGreen();
                    int blue = currentColor.getBlue();
                    buffer.method_22918(modelMatrix, (float)x + innerDx, (float)y + 0.1f, (float)z + innerDz).method_1336(red, green, blue, (int)(layerAlpha * (float)glowAlpha)).method_1344();
                    buffer.method_22918(modelMatrix, (float)x + outerDx, (float)y + 0.1f, (float)z + outerDz).method_1336(red, green, blue, (int)(layerAlpha * (float)glowAlpha)).method_1344();
                }
                tessellator.method_1350();
            }
        }

        private float getWaveInterpolation(double angle, float rotationOffset) {
            float positionOnCircle = (float)(angle / (Math.PI * 2) + (double)rotationOffset) % 1.0f;
            float distanceToGradientPoint = Math.abs(positionOnCircle - 0.5f);
            return class_3532.method_15363((float)(1.0f - distanceToGradientPoint * 2.0f), (float)0.0f, (float)1.0f);
        }

        private Color interpolateColor(Color startColor, Color endColor, float fraction) {
            int red = class_3532.method_15340((int)((int)((float)startColor.getRed() + (float)(endColor.getRed() - startColor.getRed()) * fraction)), (int)0, (int)255);
            int green = class_3532.method_15340((int)((int)((float)startColor.getGreen() + (float)(endColor.getGreen() - startColor.getGreen()) * fraction)), (int)0, (int)255);
            int blue = class_3532.method_15340((int)((int)((float)startColor.getBlue() + (float)(endColor.getBlue() - startColor.getBlue()) * fraction)), (int)0, (int)255);
            return new Color(red, green, blue);
        }
    }
}

