/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.rendersoptimization;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class OutlineRenderer
implements ModInitializer {
    private final class_310 client = class_310.method_1551();

    public void onInitialize() {
    }

    private void onRenderOutline(WorldRenderContext context) {
        if (this.client.field_1724 == null) {
            return;
        }
        class_4587 matrices = context.matrixStack();
        class_243 cameraPos = context.camera().method_19326();
        class_746 player = this.client.field_1724;
        class_243 playerPos = player.method_19538().method_1020(cameraPos);
        this.renderOutline(matrices, playerPos);
    }

    private void renderOutline(class_4587 matrices, class_243 playerPos) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableCull();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        int glowLayers = 7;
        float layerSpacing = 0.03f;
        float outlineWidth = 0.1f;
        Color startColor = new Color(-16711936);
        Color endColor = new Color(-1);
        float angle = (float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f;
        for (int layer = 0; layer < glowLayers; ++layer) {
            float layerAlpha = 0.5882353f * (1.0f - (float)layer / (float)glowLayers);
            buffer.method_1328(class_293.class_5596.field_27378, class_290.field_1576);
            for (int i = 0; i <= 36; ++i) {
                float theta = (float)i / 36.0f * (float)Math.PI * 2.0f;
                double x = Math.cos(theta + angle) * (double)outlineWidth + playerPos.field_1352;
                double y = playerPos.field_1351 + 1.0;
                double z = Math.sin(theta + angle) * (double)outlineWidth + playerPos.field_1350;
                float colorInterpolation = (float)i / 36.0f;
                Color currentColor = this.interpolateColor(startColor, endColor, colorInterpolation);
                buffer.method_22918(matrices.method_23760().method_23761(), (float)x, (float)y, (float)z).method_1336(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), (int)(layerAlpha * 255.0f)).method_1344();
            }
            tessellator.method_1350();
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private Color interpolateColor(Color startColor, Color endColor, float fraction) {
        int red = class_3532.method_15340((int)((int)((float)startColor.getRed() + (float)(endColor.getRed() - startColor.getRed()) * fraction)), (int)0, (int)255);
        int green = class_3532.method_15340((int)((int)((float)startColor.getGreen() + (float)(endColor.getGreen() - startColor.getGreen()) * fraction)), (int)0, (int)255);
        int blue = class_3532.method_15340((int)((int)((float)startColor.getBlue() + (float)(endColor.getBlue() - startColor.getBlue()) * fraction)), (int)0, (int)255);
        return new Color(red, green, blue);
    }
}

