/*
 * Decompiled with CFR 0.152.
 */
package org.ChSP.soupapi.rendersoptimization.mixin;

import java.util.Base64;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.ChSP.soupapi.blockentityoptimizer.BlockEntityOptimizerConfig;
import org.ChSP.soupapi.listsoptimizer.FriendCommandClient;
import org.ChSP.soupapi.rendersoptimization.CirclesRenderer;
import org.ChSP.soupapi.rendersoptimization.mixin.EntityRendererAccessor;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_897.class})
public abstract class EntityRendererMixin<T extends class_1297> {
    @Unique
    private static final int WAVE_LENGTH = 2;
    @Unique
    private static final int COLOR_CYCLE_TICKS = 40;
    private static final String NAME = EntityRendererMixin.decodeName("UGFkZWpf");

    @Inject(method={"renderLabelIfPresent"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderLabelIfPresent(T entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        if (entity instanceof class_1657 && this.isFriend((class_1657)entity)) {
            class_5250 coloredNick = class_2561.method_43470((String)"");
            String entityName = entity.method_5477().getString();
            String prefix = "";
            String suffix = "";
            String mainNick = entityName;
            if (entityName.contains("[") && entityName.contains("]")) {
                prefix = entityName.substring(0, entityName.indexOf("]") + 1);
                mainNick = entityName.substring(entityName.indexOf("]") + 1);
            }
            if (mainNick.contains("<")) {
                suffix = mainNick.substring(mainNick.indexOf("<"));
                mainNick = mainNick.substring(0, mainNick.indexOf("<"));
            }
            coloredNick.method_10852((class_2561)class_2561.method_43470((String)prefix));
            for (int i = 0; i < mainNick.length(); ++i) {
                char c = mainNick.charAt(i);
                int waveOffset = (mainNick.length() - 1 - i) * 2 % 40;
                int tick = (int)(class_310.method_1551().field_1687.method_8510() % 40L);
                int colorIndex = (tick + waveOffset) % 40;
                float t = (float)colorIndex / 40.0f;
                t = (float)(0.5 * (1.0 + Math.sin((double)(t * 2.0f) * Math.PI)));
                int color = this.interpolateColor(((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).start_color, ((BlockEntityOptimizerConfig)CirclesRenderer.configHolder.get()).end_color, t);
                coloredNick.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(c)).method_27694(style -> style.method_27703(class_5251.method_27717((int)color))));
            }
            coloredNick.method_10852((class_2561)class_2561.method_43470((String)suffix));
            if (mainNick.equals(NAME)) {
                coloredNick = class_2561.method_43470((String)"\u00a76\u2605 ").method_10852((class_2561)coloredNick);
            }
            text = coloredNick;
        }
        ci.cancel();
        this.renderOriginalLabel(entity, text, matrices, vertexConsumers, light);
    }

    private boolean isFriend(class_1657 player) {
        String playerName = player.method_5477().getString();
        return FriendCommandClient.isFriend(playerName);
    }

    @Unique
    private int interpolateColor(int color1, int color2, float t) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }

    @Unique
    private void renderOriginalLabel(T entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_898 dispatcher = ((EntityRendererAccessor)((Object)this)).getDispatcher();
        double d = dispatcher.method_23168(entity);
        if (!(d > 4096.0)) {
            boolean bl = !entity.method_21751();
            float h = entity.method_51152();
            int i = "deadmau5".equals(text.getString()) ? -10 : 0;
            matrices.method_22903();
            matrices.method_46416(0.0f, h, 0.0f);
            matrices.method_22907(dispatcher.method_24197());
            matrices.method_22905(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            float f = class_310.method_1551().field_1690.method_19343(0.25f);
            int j = (int)(f * 255.0f) << 24;
            class_327 textRenderer = class_310.method_1551().field_1772;
            float g = -textRenderer.method_27525((class_5348)text) / 2;
            textRenderer.method_30882(text, g, (float)i, 0x20FFFFFF, false, matrix4f, vertexConsumers, bl ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, j, light);
            if (bl) {
                textRenderer.method_30882(text, g, (float)i, -1, false, matrix4f, vertexConsumers, class_327.class_6415.field_33993, 0, light);
            }
            matrices.method_22909();
        }
    }

    private static String decodeName(String input) {
        byte[] decodedBytes = Base64.getDecoder().decode(input);
        return new String(decodedBytes);
    }
}

