/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary;

import io.github.xienaoban.biologydictionary.common.server.ServerEventRegistry;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.DevUtils;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.config.ConfigsManager;
import io.github.xienaoban.biologydictionary.core.BiologyDictionaryItem;
import io.github.xienaoban.biologydictionary.core.EntityManager;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.skill.PlayerSkills;
import io.github.xienaoban.biologydictionary.net.ServerNetManager;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BiologyDictionary {
    public static final String MOD_ID = "biologydictionary";
    public static final String MODRINTH_PAGE = "https://modrinth.com/mod/bole";
    public static final Logger LOGGER = LogManager.getLogger(BiologyDictionary.class);
    public static final BiologyDictionary BD = new BiologyDictionary();
    private final Set<MinecraftServer> servers = ConcurrentHashMap.newKeySet();

    private BiologyDictionary() {
        ConfigsManager.load();
        EntityUtils.init();
        ServerNetManager.init();
        BiologyDictionaryItem.init();
        EntityProperties.init();
        PlayerSkills.init();
        ServerEventRegistry.registerStarted(this.servers::add);
        ServerEventRegistry.registerStopping(this.servers::remove);
        ServerEventRegistry.registerStarted(server -> EntityManager.init());
        ServerEventRegistry.registerStopping(server -> EntityManager.destroy());
        LOGGER.info("BiologyDictionary initialized.");
    }

    public void forceInitialize() {
    }

    public Set<MinecraftServer> getServers() {
        return this.servers;
    }

    public class_1937 justGiveMeALevel() {
        class_1937 level;
        if (DevUtils.isClient() && (level = ClientUtils.getClientLevel0()) != null) {
            return level;
        }
        for (MinecraftServer server : this.getServers()) {
            Iterator iterator = server.method_3738().iterator();
            if (!iterator.hasNext()) continue;
            class_1937 level2 = (class_1937)iterator.next();
            return level2;
        }
        return null;
    }

    public static void sendCenteredMessage(class_3222 player, class_2561 text) {
        ServerNetManager.sendCenteredMessage(player, text);
    }

    public static void sendCenteredInfo(class_3222 player, class_5250 text) {
        BiologyDictionary.sendCenteredMessage(player, (class_2561)text.method_27692(class_124.field_1068));
    }

    public static void sendCenteredWarning(class_3222 player, class_5250 text) {
        BiologyDictionary.sendCenteredMessage(player, (class_2561)text.method_27692(class_124.field_1054));
    }

    public static void sendCenteredError(class_3222 player, class_5250 text) {
        BiologyDictionary.sendCenteredMessage(player, (class_2561)text.method_27692(class_124.field_1061));
    }
}

