/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary;

import io.github.xienaoban.biologydictionary.BiologyDictionary;
import io.github.xienaoban.biologydictionary.client.FirstPersonShoulderEntityRenderer;
import io.github.xienaoban.biologydictionary.client.HighlightManager;
import io.github.xienaoban.biologydictionary.client.KeyMappingManager;
import io.github.xienaoban.biologydictionary.common.client.ClientEventRegistry;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.config.ConfigsManager;
import io.github.xienaoban.biologydictionary.core.EntityManager;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.widget.EntityPropertyWidgets;
import io.github.xienaoban.biologydictionary.gui.screen.AbstractBiologyDictionaryScreen;
import io.github.xienaoban.biologydictionary.net.ClientNetManager;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_310;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public final class BiologyDictionaryClient {
    public static final BiologyDictionaryClient BDC = new BiologyDictionaryClient();
    private int ticks;
    private class_1297 hitEntity = null;
    private class_2338 hitBlock = null;
    private EntityProperties<? extends class_1297> hitEntityProperties = null;

    private BiologyDictionaryClient() {
        ClientEventRegistry.registerWorldConnected(client -> {
            if (!client.method_1542()) {
                ClientNetManager.requestServerConfigs();
            }
            EntityManager.init();
        });
        ClientEventRegistry.registerWorldDisconnecting(client -> {
            FirstPersonShoulderEntityRenderer.clear();
            EntityManager.destroy();
            ConfigsManager.setLocalServerConfigs();
        });
        ClientEventRegistry.registerEndTick(this::tick);
        EntityPropertyWidgets.init();
        KeyMappingManager.init();
        ClientNetManager.init();
        HighlightManager.init();
        BiologyDictionary.LOGGER.info("BiologyDictionary (client) initialized.");
    }

    public void forceInitialize() {
    }

    public int getTicks() {
        return this.ticks;
    }

    public class_1297 getHitEntity() {
        return this.hitEntity;
    }

    public void setHitEntity(class_1297 hitEntity) {
        this.hitEntity = hitEntity;
    }

    public class_2338 getHitBlock() {
        return this.hitBlock;
    }

    public void setHitBlock(class_2338 hitBlock) {
        this.hitBlock = hitBlock;
    }

    public EntityProperties<? extends class_1297> getHitEntityProperties() {
        return this.hitEntityProperties;
    }

    public void setHitEntityProperties(EntityProperties<? extends class_1297> hitEntityProperties) {
        this.hitEntityProperties = hitEntityProperties;
    }

    private void tick(class_310 client) {
        if (!client.method_1493()) {
            ++this.ticks;
        }
    }

    public static void sendCenteredMessage(class_2561 text) {
        Object s = ClientUtils.getCurrentScreen();
        if (s instanceof AbstractBiologyDictionaryScreen) {
            AbstractBiologyDictionaryScreen screen = (AbstractBiologyDictionaryScreen)((Object)s);
            screen.sendScreenMessage(text);
        } else {
            ClientUtils.sendCenteredMessage(text);
        }
    }

    public static void sendCenteredInfo(class_5250 text) {
        BiologyDictionaryClient.sendCenteredMessage((class_2561)text.method_27692(class_124.field_1068));
    }

    public static void sendCenteredWarning(class_5250 text) {
        BiologyDictionaryClient.sendCenteredMessage((class_2561)text.method_27692(class_124.field_1054));
    }

    public static void sendCenteredError(class_5250 text) {
        BiologyDictionaryClient.sendCenteredMessage((class_2561)text.method_27692(class_124.field_1061));
    }

    public static void printThrowableToLoggerAndGame(Throwable throwable) {
        String errStack = Misc.getStackToString(throwable);
        BiologyDictionary.LOGGER.error(errStack);
        ClientUtils.sendTextBoxMessage(class_2564.method_37112(Arrays.asList(class_2561.method_43471((String)"text.biologydictionary.info_from_this_mod").method_27692(class_124.field_1077), class_2561.method_43470((String)throwable.toString()).method_27692(class_124.field_1061)), (class_2561)class_2561.method_43473()));
    }
}

