/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.client;

import io.github.xienaoban.biologydictionary.BiologyDictionary;
import io.github.xienaoban.biologydictionary.BiologyDictionaryClient;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.common.util.InventoryUtils;
import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.common.util.PlayerUtils;
import io.github.xienaoban.biologydictionary.config.ConfigsManager;
import io.github.xienaoban.biologydictionary.core.BiologyDictionaryItem;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.gui.screen.BdEntityDetailScreen;
import io.github.xienaoban.biologydictionary.gui.screen.BdHomeScreen;
import io.github.xienaoban.biologydictionary.gui.screen.misc.BeehiveScreen;
import io.github.xienaoban.biologydictionary.net.ClientNetManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4481;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public final class BiologyDictionaryEvent {
    public static void openBookScreen(class_310 client) {
        class_746 player = ClientUtils.getClientPlayer(client);
        try {
            BiologyDictionaryEvent.resetHit();
            if (BiologyDictionaryEvent.hasPermissionToOpenBook(player)) {
                BiologyDictionaryEvent.openBookScreen0(client, player);
            } else {
                ClientUtils.sendCenteredMessage((class_2561)class_2561.method_43471((String)"text.biologydictionary.no_biology_dictionary_book").method_27692(class_124.field_1054));
            }
        }
        catch (Throwable e) {
            BiologyDictionaryEvent.resetHit();
            BiologyDictionary.LOGGER.error("Failed to open Biology Dictionary screen: {}", (Object)Misc.getStackToString(e));
        }
    }

    private static void openBookScreen0(class_310 client, class_746 player) {
        class_746 target;
        if (player == null) {
            BiologyDictionary.LOGGER.error("Client player is null. Fail to open the Bole Screen.");
            return;
        }
        float y = player.method_36455();
        class_239 hit = client.field_1765;
        if (y < -89.64f) {
            target = null;
        } else if (y > 89.64f) {
            target = player;
        } else if (y > 73.98f && player.method_5765()) {
            target = player.method_5854();
        } else if (y > 59.940002f && player.method_5765() && (hit == null || hit.method_17783() != class_239.class_240.field_1331)) {
            target = player.method_5854();
        } else if (hit == null || hit.method_17783() == class_239.class_240.field_1333) {
            target = null;
        } else if (hit.method_17783() == class_239.class_240.field_1331) {
            target = ((class_3966)hit).method_17782();
        } else if (hit.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)hit).method_17777();
            BiologyDictionaryClient.BDC.setHitBlock(pos);
            class_2680 blockState = EntityUtils.getLevel((class_1297)player).method_8320(pos);
            if (blockState.method_26204() instanceof class_4481) {
                ClientNetManager.requestBeehiveInfo(pos);
                ClientUtils.setScreen(client, new BeehiveScreen(pos));
                ClientUtils.playScreenSound(client, class_3417.field_29543, 1.0f, 0.8f);
                return;
            }
            target = null;
        } else {
            target = null;
        }
        if (target == null) {
            ClientUtils.setScreen(client, new BdHomeScreen());
        } else {
            EntityProperties<class_746> properties = new EntityProperties<class_746>(target);
            BiologyDictionaryClient.BDC.setHitEntity((class_1297)target);
            BiologyDictionaryClient.BDC.setHitEntityProperties(properties);
            ClientNetManager.requestEntityData((class_1297)target);
            try {
                ClientUtils.setScreen(client, new BdEntityDetailScreen(properties));
            }
            catch (RuntimeException e) {
                BiologyDictionaryClient.printThrowableToLoggerAndGame(e);
                return;
            }
        }
        ClientUtils.playScreenSound(client, class_3417.field_17481, 1.0f, 0.8f);
    }

    private static void resetHit() {
        BiologyDictionaryClient.BDC.setHitEntity(null);
        BiologyDictionaryClient.BDC.setHitBlock(null);
        BiologyDictionaryClient.BDC.setHitEntityProperties(null);
    }

    private static boolean hasBook(class_746 player) {
        return InventoryUtils.hasEnoughItems(PlayerUtils.getInventory((class_1657)player), BiologyDictionaryItem.createBook(), (is1, is2) -> BiologyDictionaryItem.isBook(is2));
    }

    private static boolean hasPermissionToOpenBook(class_746 player) {
        return PlayerUtils.isCreative((class_1657)player) || !ConfigsManager.getServer().isBookItemRequired() || BiologyDictionaryEvent.hasBook(player);
    }
}

