/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.client;

import io.github.xienaoban.biologydictionary.BiologyDictionary;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.common.util.RenderUtils;
import io.github.xienaoban.biologydictionary.config.ConfigsManager;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1453;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public final class FirstPersonShoulderEntityRenderer {
    private static final int NULL_VARIANT = -2333333;
    private static final float HEAD_ROT_SPEED = 0.02f;
    private static final int[] lrData = new int[]{-2333333, -2333333};
    private static final class_1309[] entities = new class_1309[2];
    private static final class_897<class_1297, class_10017>[] entityRenderers = (class_897[])Misc.cast(new class_897[2]);
    private static final class_10017[] entityRenderStates = new class_10017[2];
    private static final float[] nextYHeadRot = new float[2];
    private static final float[] nextXHeadRot = new float[2];
    private static final long[] lastHeadYawTime = new long[2];
    private static final long[] nextHeadYawTime = new long[2];
    private static long lastTime;
    private static boolean banned;

    public static void clear() {
        FirstPersonShoulderEntityRenderer.lrData[1] = -2333333;
        FirstPersonShoulderEntityRenderer.lrData[0] = -2333333;
        FirstPersonShoulderEntityRenderer.entities[1] = null;
        FirstPersonShoulderEntityRenderer.entities[0] = null;
        FirstPersonShoulderEntityRenderer.entityRenderers[1] = null;
        FirstPersonShoulderEntityRenderer.entityRenderers[0] = null;
        FirstPersonShoulderEntityRenderer.entityRenderStates[1] = null;
        FirstPersonShoulderEntityRenderer.entityRenderStates[0] = null;
    }

    public static void run(class_310 client, class_898 entityRenderDispatcher, float tickDelta, class_4587 poseStack, class_11659 submitNodeCollector, class_746 player, int light) {
        if (banned) {
            return;
        }
        try {
            FirstPersonShoulderEntityRenderer.run0(client, entityRenderDispatcher, tickDelta, poseStack, submitNodeCollector, player, light);
        }
        catch (Exception e) {
            banned = true;
            BiologyDictionary.LOGGER.error("Failed to render parrots on shoulders: {}", (Object)Misc.getStackToString(e));
        }
    }

    private static void run0(class_310 client, class_898 entityRenderDispatcher, float tickDelta, class_4587 poseStack, class_11659 submitNodeCollector, class_746 player, int light) {
        HudPosition hudPos;
        switch (ConfigsManager.getClient().getFirstPersonShoulderEntityPosition()) {
            default: {
                throw new MatchException(null, null);
            }
            case NONE: {
                HudPosition hudPosition = null;
                break;
            }
            case TOP: {
                HudPosition hudPosition = HudPosition.TOP;
                break;
            }
            case BOTTOM: {
                HudPosition hudPosition = HudPosition.BOTTOM;
                break;
            }
            case SIDES: {
                HudPosition hudPosition = hudPos = HudPosition.SIDES;
            }
        }
        if (hudPos == null) {
            return;
        }
        if (player.method_74136().isEmpty() && player.method_74137().isEmpty()) {
            return;
        }
        long curTime = ClientUtils.getGameTimeMillis(tickDelta);
        long diffTime = Math.min(50L, curTime - lastTime);
        lastTime = curTime;
        class_4587 ps = new class_4587();
        float xp = class_3532.method_16439((float)tickDelta, (float)player.field_3914, (float)player.field_3916);
        float yp = class_3532.method_16439((float)tickDelta, (float)player.field_3931, (float)player.field_3932);
        ps.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees((player.method_5695(tickDelta) - xp) * 0.1f));
        ps.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((player.method_5705(tickDelta) - yp) * 0.1f));
        class_12075 camera = client.field_1773.method_72912().field_63082;
        for (int i = 0; i < 2; ++i) {
            Optional optionalVariant = i == 0 ? player.method_74136() : player.method_74137();
            FirstPersonShoulderEntityRenderer.update(entityRenderDispatcher, player, optionalVariant.orElse(null), i);
            class_1309 entity = entities[i];
            if (entity == null) continue;
            if (curTime > nextHeadYawTime[i]) {
                FirstPersonShoulderEntityRenderer.lastHeadYawTime[i] = nextHeadYawTime[i];
                FirstPersonShoulderEntityRenderer.nextHeadYawTime[i] = curTime + 2000L + (long)(Math.random() * 6000.0);
                FirstPersonShoulderEntityRenderer.nextYHeadRot[i] = (float)(Math.random() - 0.5) * 60.0f;
                FirstPersonShoulderEntityRenderer.nextXHeadRot[i] = (float)(Math.random() - 0.5) * 20.0f;
            }
            if (curTime - lastHeadYawTime[i] < 1000L) {
                float yHeadRotDiff = 0.02f * (float)diffTime * (nextYHeadRot[i] - entity.method_5791());
                float xRotDiff = 0.02f * (float)diffTime * (nextXHeadRot[i] - entity.method_36455());
                entity.method_5847(entity.method_5791() + yHeadRotDiff);
                entity.method_36457(entity.method_36455() + xRotDiff);
            }
            FirstPersonShoulderEntityRenderer.extract(i);
            class_10017 entityRenderState = entityRenderStates[i];
            entityRenderState.field_61820 = light;
            int pos = i * -2 + 1;
            ps.method_22903();
            ps.method_22907((Quaternionfc)class_7833.field_40714.rotation(hudPos.xRot()));
            ps.method_22907((Quaternionfc)class_7833.field_40716.rotation(hudPos.yRot()));
            ps.method_22907((Quaternionfc)class_7833.field_40718.rotation(hudPos.zRot()));
            ps.method_22904((double)pos * hudPos.xPos(), hudPos.yPos() + (double)(player.method_36455() * hudPos.yOffset()), hudPos.zPos());
            entityRenderDispatcher.method_72976(entityRenderState, camera, 0.0, 0.0, 0.0, ps, submitNodeCollector);
            ps.method_22909();
        }
    }

    private static void update(class_898 entityRenderDispatcher, class_746 player, class_1453.class_7989 variant, int index) {
        class_10017 entityRenderState;
        class_897 entityRenderer;
        class_1453 entity;
        int variantId;
        int n = variantId = variant == null ? -2333333 : variant.method_47849();
        if (lrData[index] == variantId) {
            return;
        }
        FirstPersonShoulderEntityRenderer.lrData[index] = variantId;
        if (variantId == -2333333) {
            entity = null;
            entityRenderer = null;
            entityRenderState = null;
        } else {
            class_1453 parrot = (class_1453)EntityUtils.create(class_1299.field_6104, EntityUtils.getLevel((class_1297)player));
            VanillaEntityProperties.OfParrot.createVariantProperty().withVal(variant).setTo(parrot);
            entity = parrot;
            entity.method_36456(0.0f);
            entity.method_5847(0.0f);
            entity.method_5636(0.0f);
            entity.field_5982 = 0.0f;
            entity.field_6259 = 0.0f;
            entity.field_6220 = 0.0f;
            entity.method_6125(0.0f);
            entityRenderer = RenderUtils.getRenderer(entityRenderDispatcher, entity);
            entityRenderState = RenderUtils.createRenderState(entityRenderer);
        }
        FirstPersonShoulderEntityRenderer.entities[index] = entity;
        FirstPersonShoulderEntityRenderer.entityRenderers[index] = entityRenderer;
        FirstPersonShoulderEntityRenderer.entityRenderStates[index] = entityRenderState;
    }

    private static void extract(int index) {
        class_10017 entityRenderState = entityRenderStates[index];
        RenderUtils.extractRenderState(entityRenderers[index], entities[index], entityRenderState);
        RenderUtils.renderBodyOnly(entityRenderState);
    }

    static {
        banned = false;
    }

    private record HudPosition(float xRot, float yRot, float zRot, double xPos, double yPos, double zPos, float yOffset) {
        private static final float PI_DIV_180 = (float)Math.PI / 180;
        public static final HudPosition TOP = new HudPosition(60.0f, 0.0f, 180.0f, 0.5, 0.2, -1.8, -0.003f);
        public static final HudPosition BOTTOM = new HudPosition(0.0f, 180.0f, 0.0f, 0.5, -1.4, 1.3, 0.002f);
        public static final HudPosition SIDES = new HudPosition(-10.0f, 180.0f, 0.0f, 1.6, -0.4, 1.0, 0.004f);

        private HudPosition(float xRot, float yRot, float zRot, double xPos, double yPos, double zPos, float yOffset) {
            this.xRot = xRot * ((float)Math.PI / 180);
            this.yRot = yRot * ((float)Math.PI / 180);
            this.zRot = zRot * ((float)Math.PI / 180);
            this.xPos = xPos;
            this.yPos = yPos;
            this.zPos = zPos;
            this.yOffset = yOffset;
        }
    }
}

