/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.client;

import io.github.xienaoban.biologydictionary.BiologyDictionaryClient;
import io.github.xienaoban.biologydictionary.common.client.ClientEventRegistry;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public final class HighlightManager {
    private static volatile boolean hasHighlighted = false;
    private static final List<HighlightedEntity> highlightedEntities = new CopyOnWriteArrayList<HighlightedEntity>();
    private static final List<HighlightedBlock> highlightedBlocks = new CopyOnWriteArrayList<HighlightedBlock>();

    public static void init() {
        ClientEventRegistry.registerEndTick(HighlightManager::tick);
        ClientEventRegistry.registerWorldDisconnecting(client -> HighlightManager.clear());
    }

    private static void tick(class_310 client) {
        if (!hasHighlighted) {
            return;
        }
        int ticks = BiologyDictionaryClient.BDC.getTicks();
        class_638 level = client.field_1687;
        if (level == null) {
            HighlightManager.clear();
            return;
        }
        Context ctx = new Context(level);
        highlightedEntities.removeIf(h -> h.checkEnd(ticks, ctx));
        highlightedBlocks.removeIf(h -> h.checkEnd(ticks, ctx));
        if (highlightedEntities.isEmpty() && highlightedBlocks.isEmpty()) {
            hasHighlighted = false;
        }
    }

    public static void clear() {
        highlightedEntities.clear();
        highlightedBlocks.clear();
        hasHighlighted = false;
    }

    public static boolean hasAnyHighlighted() {
        return hasHighlighted;
    }

    public static List<HighlightedEntity> getHighlightedEntities() {
        return highlightedEntities;
    }

    public static List<HighlightedBlock> getHighlightedBlocks() {
        return highlightedBlocks;
    }

    public static void highlightEntity(class_1297 entity, int durationTicks) {
        if (!hasHighlighted) {
            hasHighlighted = true;
        }
        highlightedEntities.add(new HighlightedEntity(BiologyDictionaryClient.BDC.getTicks() + durationTicks, entity));
    }

    public static void highlightBlock(class_2338 blockPos, int durationTicks) {
        HighlightManager.highlightBlock(ClientUtils.getClientLevel(), blockPos, durationTicks);
    }

    public static void highlightBlock(class_638 level, class_2338 blockPos, int durationTicks) {
        if (!hasHighlighted) {
            hasHighlighted = true;
        }
        class_2680 blockState = level.method_8320(blockPos);
        highlightedBlocks.add(new HighlightedBlock(BiologyDictionaryClient.BDC.getTicks() + durationTicks, blockState, blockPos, (class_5321<class_1937>)level.method_27983()));
    }

    public record Context(class_638 level) {
    }

    public static final class HighlightedEntity
    extends HighlightedInstance {
        private final class_1297 entity;

        public HighlightedEntity(int endTick, class_1297 entity) {
            super(endTick);
            this.entity = entity;
        }

        public class_1297 getEntity() {
            return this.entity;
        }

        @Override
        protected boolean onCheckEnd(Context ctx) {
            return EntityUtils.getLevel(this.entity) != ctx.level || !this.entity.method_5805();
        }
    }

    public static final class HighlightedBlock
    extends HighlightedInstance {
        private final class_2680 blockState;
        private final class_2338 blockPos;
        private final class_5321<class_1937> dimension;

        public HighlightedBlock(int endTick, class_2680 blockState, class_2338 blockPos, class_5321<class_1937> dimension) {
            super(endTick);
            this.blockState = blockState;
            this.blockPos = blockPos;
            this.dimension = dimension;
        }

        public class_2680 getBlockState() {
            return this.blockState;
        }

        public class_2338 getBlockPos() {
            return this.blockPos;
        }

        @Override
        protected boolean onCheckEnd(Context ctx) {
            return this.dimension != ctx.level.method_27983() || this.blockState.method_26204() != ctx.level.method_8320(this.blockPos).method_26204();
        }
    }

    public static abstract class HighlightedInstance {
        protected final int endTicks;
        protected boolean ended;

        public HighlightedInstance(int endTicks) {
            this.endTicks = endTicks;
            this.ended = false;
        }

        public final boolean checkEnd(int ticks, Context ctx) {
            if (this.endTicks < ticks || this.onCheckEnd(ctx)) {
                this.ended = true;
            }
            return this.ended;
        }

        public final void setEnded() {
            this.ended = true;
        }

        protected abstract boolean onCheckEnd(Context var1);
    }
}

