/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.common.gui.screen;

import io.github.xienaoban.biologydictionary.BiologyDictionaryClient;
import io.github.xienaoban.biologydictionary.common.gui.screen.CommonScreen;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenElement;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public abstract class ElementScreen
extends CommonScreen {
    private final RootScreenElement rootScreenElement = new RootScreenElement();
    private ScreenElement hoveredElement = null;
    private ScreenElement selectedElement;
    private int ticks = 0;

    protected ElementScreen(class_2561 component) {
        super(component);
    }

    protected void method_25426() {
        super.method_25426();
        this.updateBoxSizes();
    }

    public void method_25393() {
        try {
            super.method_25393();
            ++this.ticks;
            this.rootScreenElement.tick(this.ticks);
        }
        catch (Throwable e) {
            this.showExceptionMessageAndCloseScreen(e);
        }
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
        try {
            this.updateSelectedElement();
            if (this.getSelectedElement() != null) {
                return this.getSelectedElement().mouseDown((float)mouseButtonEvent.comp_4798(), (float)mouseButtonEvent.comp_4799(), mouseButtonEvent.method_74245());
            }
            return super.method_25402(mouseButtonEvent, bl);
        }
        catch (Throwable e) {
            this.showExceptionMessageAndCloseScreen(e);
            return true;
        }
    }

    @Override
    protected void beforeRender(ScreenRenderingContext ctx) {
        super.beforeRender(ctx);
        this.updateHoveredElement(ctx.getMouseX(), ctx.getMouseY());
    }

    @Override
    protected void render(ScreenRenderingContext ctx) {
        try {
            super.render(ctx);
            this.rootScreenElement.render(ctx);
            ctx.getGuiGraphics().method_71048();
            ScreenElement hovered = this.getHoveredElement();
            if (hovered != null) {
                hovered.renderHovered(ctx);
            }
        }
        catch (Throwable e) {
            this.showExceptionMessageAndCloseScreen(e);
        }
    }

    public final ScreenElement getHoveredElement() {
        return this.hoveredElement;
    }

    private void updateHoveredElement(float x, float y) {
        this.hoveredElement = this.hoveredElement != null && this.hoveredElement.isHovered(x, y) ? this.hoveredElement.hover(x, y) : this.rootScreenElement.hover(x, y);
    }

    public final void clearHoveredElement() {
        this.hoveredElement = null;
    }

    public final ScreenElement getSelectedElement() {
        return this.selectedElement;
    }

    private void updateSelectedElement() {
        ScreenElement element;
        for (element = this.getHoveredElement(); element != null && !element.isSelectable(); element = element.getParent()) {
        }
        this.selectedElement = element;
    }

    public final ScreenElement getRootScreenElement() {
        return this.rootScreenElement;
    }

    public final void updateBoxSizes() {
        this.rootScreenElement.resize(this.field_22789, this.field_22790);
    }

    public final int getTicks() {
        return this.ticks;
    }

    protected abstract void resizeBox(int var1, int var2);

    private void showExceptionMessageAndCloseScreen(Throwable throwable) {
        BiologyDictionaryClient.printThrowableToLoggerAndGame(throwable);
        this.method_25419();
    }

    private final class RootScreenElement
    extends ScreenElement {
        public RootScreenElement() {
            super(false);
        }

        @Override
        public void onResize(int width, int height) {
            this.getBox().set(0.0f, 0.0f, width, height);
            ElementScreen.this.resizeBox(width, height);
        }
    }
}

