/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.common.gui.screen.util;

import io.github.xienaoban.biologydictionary.common.gui.screen.ElementScreen;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenElementBox;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class ScreenElement {
    @Nullable
    protected ScreenElement parent = null;
    private final ScreenElementBox box = new ScreenElementBox();
    private final ArrayList<ScreenElement> subScreenElements = new ArrayList();
    private boolean hoverable;
    private boolean selectable;
    private float priority = 0.0f;

    public ScreenElement() {
        this(true, true);
    }

    public ScreenElement(boolean selectable) {
        this(true, selectable);
    }

    public ScreenElement(boolean hoverable, boolean selectable) {
        this.hoverable = hoverable;
        this.selectable = selectable;
    }

    protected void onTick(int ticks) {
    }

    protected void onResize(int width, int height) {
    }

    protected boolean onMouseDown(float x, float y, int code) {
        return false;
    }

    protected void onRender(ScreenRenderingContext ctx) {
    }

    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        return false;
    }

    @Nullable
    public final ScreenElement getParent() {
        return this.parent;
    }

    public final void setParent(ScreenElement newParent) {
        if (this.parent != null) {
            this.parent.unregisterSubScreenElement(this);
        }
        this.parent = newParent;
        if (this.parent != null) {
            this.parent.registerSubScreenElement(this);
        }
    }

    public final void tick(int ticks) {
        this.onTick(ticks);
        for (ScreenElement subEle : this.subScreenElements) {
            subEle.tick(ticks);
        }
    }

    public final void resize(int width, int height) {
        this.onResize(width, height);
        for (ScreenElement subEle : this.subScreenElements) {
            subEle.resize(width, height);
        }
    }

    public final void render(ScreenRenderingContext ctx) {
        this.onRender(ctx);
        if (ctx.isDebug() && this.box.getWidth() > 0.0f && this.box.getHeight() > 0.0f) {
            ElementScreen screen = ctx.getElementScreen();
            int alpha = -16777216;
            int color = this == screen.getSelectedElement() ? 0x44CC00 : (this == screen.getHoveredElement() ? 0xFFAA00 : (this.isInBox(screen.getHoveredElement()) ? 22015 : 0xCC0000));
            ctx.renderRectangle(color | 0xFF000000, 0.6f, screen.getZ(), this.box.getLeft(), this.box.getTop(), this.box.getRight(), this.box.getBottom());
            if (this == screen.getHoveredElement()) {
                ctx.renderText((class_2561)class_2561.method_43470((String)this.getClass().getSimpleName()), -8971862, 0.5f, ctx.getZ(), this.box.getLeft() + 1.0f, this.box.getTop() - 4.5f);
            }
        }
        for (ScreenElement subEle : this.subScreenElements) {
            subEle.render(ctx);
        }
    }

    public final void renderHovered(ScreenRenderingContext ctx) {
        assert (this.isHovered(ctx.getMouseX(), ctx.getMouseY()));
        ScreenElement hovered = this;
        while (!hovered.onRenderHovered(ctx)) {
            if ((hovered = hovered.getParent()) != null) continue;
            return;
        }
    }

    public final ScreenElement hover(float x, float y) {
        if (!this.isHovered(x, y)) {
            return null;
        }
        for (ScreenElement sub : this.subScreenElements) {
            ScreenElement res = sub.hover(x, y);
            if (res == null) continue;
            return res;
        }
        return this;
    }

    public final boolean isHovered(float x, float y) {
        return this.isHoverable() && x >= this.box.getLeft() && x < this.box.getRight() && y >= this.box.getTop() && y < this.box.getBottom();
    }

    public final boolean mouseDown(float x, float y, int code) {
        if (this.isSelectable() && this.onMouseDown(x, y, code)) {
            return true;
        }
        return this.getParent() != null && this.getParent().mouseDown(x, y, code);
    }

    public final ScreenElementBox getBox() {
        return this.box;
    }

    public final boolean isHoverable() {
        return this.hoverable;
    }

    public final void setHoverable(boolean hoverable) {
        this.hoverable = hoverable;
    }

    public final boolean isSelectable() {
        return this.selectable;
    }

    public final void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public final float getPriority() {
        return this.priority;
    }

    public final void setPriority(float priority) {
        this.priority = priority;
        if (this.parent != null) {
            this.parent.unregisterSubScreenElement(this);
            this.parent.registerSubScreenElement(this);
        }
    }

    public final boolean isInStack(ScreenElement element) {
        while (element != null) {
            if (this == element) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    public final boolean isInBox(ScreenElement element) {
        if (element == null) {
            return false;
        }
        ScreenElementBox bi = element.getBox();
        ScreenElementBox bo = this.getBox();
        return bi.getLeft() >= bo.getLeft() && bi.getTop() >= bo.getTop() && bi.getRight() <= bo.getRight() && bi.getBottom() <= bo.getBottom();
    }

    protected void updateSubScreenElement(ScreenElement prev, ScreenElement next) {
        if (prev != null) {
            prev.setParent(null);
        }
        if (next != null) {
            next.setParent(this);
        }
    }

    private void registerSubScreenElement(ScreenElement sub) {
        int i;
        for (i = this.subScreenElements.size() - 1; i >= 0 && !(this.subScreenElements.get(i).getPriority() <= sub.getPriority()); --i) {
        }
        this.subScreenElements.add(i + 1, sub);
    }

    private void unregisterSubScreenElement(ScreenElement sub) {
        this.subScreenElements.remove(sub);
    }

    public static boolean isMouseLeft(int code) {
        return code == 0;
    }

    public static boolean isMouseRight(int code) {
        return code == 1;
    }

    public static class_2561 tooltipEmpty() {
        return class_2561.method_43473();
    }

    public static class_2561 tooltipTitle(String trans) {
        return class_2561.method_43471((String)trans).method_27695(new class_124[]{class_124.field_1068, class_124.field_1067});
    }

    public static class_2561 tooltipDescription(String trans) {
        return class_2561.method_43471((String)trans).method_27692(class_124.field_1080);
    }

    public static class_2561 tooltipBody(String trans) {
        return class_2561.method_43471((String)trans).method_27692(class_124.field_1068);
    }

    public static class_2561 tooltipBody(String trans, Object ... args) {
        return class_2561.method_43469((String)trans, (Object[])args).method_27692(class_124.field_1068);
    }
}

