/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.common.gui.screen.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class ScreenElementBox {
    private float left;
    private float top;
    private float right;
    private float bottom;
    private float width;
    private float height;

    public ScreenElementBox() {
        this.left = 0.0f;
        this.top = 0.0f;
        this.right = 0.0f;
        this.bottom = 0.0f;
        this.width = 0.0f;
        this.height = 0.0f;
    }

    public ScreenElementBox(float width, float height) {
        this.left = 0.0f;
        this.top = 0.0f;
        this.right = width;
        this.bottom = height;
        this.width = width;
        this.height = height;
    }

    public ScreenElementBox(float left, float top, float right, float bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.width = right - left;
        this.height = bottom - top;
    }

    public float getLeft() {
        return this.left;
    }

    public float getTop() {
        return this.top;
    }

    public float getRight() {
        return this.right;
    }

    public float getBottom() {
        return this.bottom;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void set(float left, float top, float right, float bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.width = right - left;
        this.height = bottom - top;
    }

    public void setPosition(float left, float top) {
        this.left = left;
        this.top = top;
        this.right = left + this.width;
        this.bottom = top + this.height;
    }

    public void setSize(float width, float height) {
        this.width = width;
        this.height = height;
        this.right = this.left + width;
        this.bottom = this.top + height;
    }

    public boolean isInBox(float left, float top) {
        return left >= this.getLeft() && left <= this.getRight() && top >= this.getTop() && top <= this.getBottom();
    }
}

