/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.common.gui.screen.util;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import io.github.xienaoban.biologydictionary.common.gui.TextureInfo;
import io.github.xienaoban.biologydictionary.common.gui.screen.CommonScreen;
import io.github.xienaoban.biologydictionary.common.gui.screen.ElementScreen;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScaleRAII;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.RenderUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_1007;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_11246;
import net.minecraft.class_12137;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_6880;
import net.minecraft.class_742;
import net.minecraft.class_7532;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_8002;
import net.minecraft.class_8030;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2ic;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public final class ScreenRenderingContext {
    private final class_437 screen;
    private final class_310 client = Objects.requireNonNull(ClientUtils.getClient());
    private class_332 guiGraphics;
    private float mouseX;
    private float mouseY;
    private float tickDelta;
    private boolean debug;

    public ScreenRenderingContext(class_437 screen) {
        this.screen = screen;
        this.debug = false;
    }

    public void update(class_332 guiGraphics, int mouseX, int mouseY, float tickDelta) {
        this.guiGraphics = guiGraphics;
        this.tickDelta = tickDelta;
        this.mouseX = (float)this.client.field_1729.method_1603() * (float)this.client.method_22683().method_4486() / (float)this.client.method_22683().method_4480();
        this.mouseY = (float)this.client.field_1729.method_1604() * (float)this.client.method_22683().method_4502() / (float)this.client.method_22683().method_4507();
        assert (mouseX == (int)this.mouseX && mouseY == (int)this.mouseY);
    }

    public class_310 getClient() {
        return this.client;
    }

    public class_437 getScreen() {
        return this.screen;
    }

    public class_332 getGuiGraphics() {
        return this.guiGraphics;
    }

    public float getMouseX() {
        return this.mouseX;
    }

    public float getMouseY() {
        return this.mouseY;
    }

    public float getTickDelta() {
        return this.tickDelta;
    }

    public class_327 getFont() {
        return this.screen.method_64506();
    }

    public float getZ() {
        return this.getCommonScreen().getZ();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public CommonScreen getCommonScreen() {
        return (CommonScreen)this.screen;
    }

    public ElementScreen getElementScreen() {
        return (ElementScreen)this.screen;
    }

    public Matrix3x2fStack getPose() {
        return this.getGuiGraphics().method_51448();
    }

    public class_332.class_8214 getScissorStack() {
        return this.getGuiGraphics().field_44659;
    }

    public class_11246 getGuiRenderState() {
        return this.getGuiGraphics().field_59826;
    }

    public ScaleRAII scaleOnce(float size) {
        return new ScaleRAII(this, size);
    }

    public ScaleRAII scaleOnce(float size, float z) {
        return new ScaleRAII(this, size, z);
    }

    public int calcTextWidth(class_2561 component) {
        return this.getFont().method_27525((class_5348)component);
    }

    public void renderText(class_2561 component, int color, float z, float x, float y) {
        this.getGuiGraphics().method_51439(this.getFont(), component, (int)x, (int)y, color, false);
    }

    public void renderText(class_2561 component, int color, float size, float z, float x, float y) {
        try (ScaleRAII ignored = this.scaleOnce(size);){
            this.renderText(component, color, z, x / size, y / size);
        }
    }

    public void renderCenteredText(class_2561 component, int color, float z, float x, float y) {
        this.renderText(component, color, z, x - (float)this.calcTextWidth(component) / 2.0f, y);
    }

    public void renderCenteredText(class_2561 component, int color, float size, float z, float x, float y) {
        try (ScaleRAII ignored = this.scaleOnce(size);){
            this.renderCenteredText(component, color, z, x / size, y / size);
        }
    }

    public void renderRightAlignedText(class_2561 component, int color, float z, float x, float y) {
        this.renderText(component, color, z, x - (float)this.calcTextWidth(component), y);
    }

    public void renderRightAlignedText(class_2561 component, int color, float size, float z, float x, float y) {
        try (ScaleRAII ignored = this.scaleOnce(size);){
            this.renderRightAlignedText(component, color, z, x / size, y / size);
        }
    }

    public void renderHorizontalLine(int color, float width, float z, float y, float left, float right) {
        this.renderRectangle(color, z, left, y - width / 2.0f, right, y + width / 2.0f);
    }

    public void renderVerticalLine(int color, float width, float z, float x, float top, float bottom) {
        this.renderRectangle(color, z, x - width / 2.0f, top, x + width / 2.0f, bottom);
    }

    public void renderRectangle(int color, float width, float z, float left, float top, float right, float bottom) {
        this.renderRectangle(color, z, left, top, right, top + width);
        this.renderRectangle(color, z, left, bottom - width, right, bottom);
        this.renderRectangle(color, z, left, top, left + width, bottom);
        this.renderRectangle(color, z, right - width, top, right, bottom);
    }

    public void renderRectangle(int color, float z, float left, float top, float right, float bottom) {
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)this.getPose());
        class_8030 scissorArea = this.getScissorStack().method_70863();
        class_8030 bounds = ScreenRenderingContext.getBounds(left, top, right, bottom, pose, scissorArea);
        final class RectangleState
        extends Record
        implements class_11244 {
            private final RenderPipeline pipeline;
            private final class_11231 textureSetup;
            private final Matrix3x2f pose;
            private final class_8030 scissorArea;
            private final class_8030 bounds;
            private final int color;
            private final float z;
            private final float x0;
            private final float y0;
            private final float x1;
            private final float y1;

            RectangleState(RenderPipeline pipeline, class_11231 textureSetup, Matrix3x2f pose, class_8030 scissorArea, class_8030 bounds, int color, float z, float x0, float y0, float x1, float y1) {
                this.pipeline = pipeline;
                this.textureSetup = textureSetup;
                this.pose = pose;
                this.scissorArea = scissorArea;
                this.bounds = bounds;
                this.color = color;
                this.z = z;
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            }

            public void method_70917(class_4588 vertexConsumer) {
                vertexConsumer.method_70815((Matrix3x2fc)this.pose, this.x0, this.y0).method_39415(this.color);
                vertexConsumer.method_70815((Matrix3x2fc)this.pose, this.x0, this.y1).method_39415(this.color);
                vertexConsumer.method_70815((Matrix3x2fc)this.pose, this.x1, this.y1).method_39415(this.color);
                vertexConsumer.method_70815((Matrix3x2fc)this.pose, this.x1, this.y0).method_39415(this.color);
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{RectangleState.class, "pipeline;textureSetup;pose;scissorArea;bounds;color;z;x0;y0;x1;y1", "pipeline", "textureSetup", "pose", "scissorArea", "bounds", "color", "z", "x0", "y0", "x1", "y1"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RectangleState.class, "pipeline;textureSetup;pose;scissorArea;bounds;color;z;x0;y0;x1;y1", "pipeline", "textureSetup", "pose", "scissorArea", "bounds", "color", "z", "x0", "y0", "x1", "y1"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RectangleState.class, "pipeline;textureSetup;pose;scissorArea;bounds;color;z;x0;y0;x1;y1", "pipeline", "textureSetup", "pose", "scissorArea", "bounds", "color", "z", "x0", "y0", "x1", "y1"}, this, o);
            }

            public RenderPipeline comp_4055() {
                return this.pipeline;
            }

            public class_11231 comp_4056() {
                return this.textureSetup;
            }

            public Matrix3x2f pose() {
                return this.pose;
            }

            public class_8030 comp_4069() {
                return this.scissorArea;
            }

            public class_8030 comp_4274() {
                return this.bounds;
            }

            public int color() {
                return this.color;
            }

            public float z() {
                return this.z;
            }

            public float x0() {
                return this.x0;
            }

            public float y0() {
                return this.y0;
            }

            public float x1() {
                return this.x1;
            }

            public float y1() {
                return this.y1;
            }
        }
        this.getGuiRenderState().method_70919((class_11244)new RectangleState(class_10799.field_56879, class_11231.method_70899(), pose, scissorArea, bounds, color, z, left, top, right, bottom));
    }

    public void renderTexture(TextureInfo texture, float textureLeft, float textureTop, float z, float left, float top, float width, float height) {
        this.renderTexture(texture, textureLeft, textureTop, textureLeft + width, textureTop + height, z, left, top, left + width, top + height);
    }

    public void renderTexture(TextureInfo texture, float textureLeft, float textureTop, float textureRight, float textureBottom, float z, float left, float top, float right, float bottom) {
        class_1044 abstractTexture = this.getClient().method_1531().method_4619(texture.location());
        class_11231 gpuTextureView = class_11231.method_70900((GpuTextureView)abstractTexture.method_71659(), (class_12137)abstractTexture.method_75484());
        float uvLeft = textureLeft / texture.width();
        float uvTop = textureTop / texture.height();
        float uvRight = textureRight / texture.width();
        float uvBottom = textureBottom / texture.height();
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)this.getPose());
        class_8030 scissorArea = this.getScissorStack().method_70863();
        class_8030 bounds = ScreenRenderingContext.getBounds(left, top, right, bottom, pose, scissorArea);
        final class TextureState
        extends Record
        implements class_11244 {
            private final RenderPipeline pipeline;
            private final class_11231 textureSetup;
            private final Matrix3x2f pose;
            private final class_8030 scissorArea;
            private final class_8030 bounds;
            private final float u0;
            private final float v0;
            private final float u1;
            private final float v1;
            private final float z;
            private final float x0;
            private final float y0;
            private final float x1;
            private final float y1;

            TextureState(RenderPipeline pipeline, class_11231 textureSetup, Matrix3x2f pose, class_8030 scissorArea, class_8030 bounds, float u0, float v0, float u1, float v1, float z, float x0, float y0, float x1, float y1) {
                this.pipeline = pipeline;
                this.textureSetup = textureSetup;
                this.pose = pose;
                this.scissorArea = scissorArea;
                this.bounds = bounds;
                this.u0 = u0;
                this.v0 = v0;
                this.u1 = u1;
                this.v1 = v1;
                this.z = z;
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            }

            public void method_70917(class_4588 vertexConsumer) {
                vertexConsumer.method_70815((Matrix3x2fc)this.pose, this.x0, this.y0).method_22913(this.u0, this.v0).method_39415(-1);
                vertexConsumer.method_70815((Matrix3x2fc)this.pose, this.x0, this.y1).method_22913(this.u0, this.v1).method_39415(-1);
                vertexConsumer.method_70815((Matrix3x2fc)this.pose, this.x1, this.y1).method_22913(this.u1, this.v1).method_39415(-1);
                vertexConsumer.method_70815((Matrix3x2fc)this.pose, this.x1, this.y0).method_22913(this.u1, this.v0).method_39415(-1);
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{TextureState.class, "pipeline;textureSetup;pose;scissorArea;bounds;u0;v0;u1;v1;z;x0;y0;x1;y1", "pipeline", "textureSetup", "pose", "scissorArea", "bounds", "u0", "v0", "u1", "v1", "z", "x0", "y0", "x1", "y1"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TextureState.class, "pipeline;textureSetup;pose;scissorArea;bounds;u0;v0;u1;v1;z;x0;y0;x1;y1", "pipeline", "textureSetup", "pose", "scissorArea", "bounds", "u0", "v0", "u1", "v1", "z", "x0", "y0", "x1", "y1"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TextureState.class, "pipeline;textureSetup;pose;scissorArea;bounds;u0;v0;u1;v1;z;x0;y0;x1;y1", "pipeline", "textureSetup", "pose", "scissorArea", "bounds", "u0", "v0", "u1", "v1", "z", "x0", "y0", "x1", "y1"}, this, o);
            }

            public RenderPipeline comp_4055() {
                return this.pipeline;
            }

            public class_11231 comp_4056() {
                return this.textureSetup;
            }

            public Matrix3x2f pose() {
                return this.pose;
            }

            public class_8030 comp_4069() {
                return this.scissorArea;
            }

            public class_8030 comp_4274() {
                return this.bounds;
            }

            public float u0() {
                return this.u0;
            }

            public float v0() {
                return this.v0;
            }

            public float u1() {
                return this.u1;
            }

            public float v1() {
                return this.v1;
            }

            public float z() {
                return this.z;
            }

            public float x0() {
                return this.x0;
            }

            public float y0() {
                return this.y0;
            }

            public float x1() {
                return this.x1;
            }

            public float y1() {
                return this.y1;
            }
        }
        this.getGuiRenderState().method_70919((class_11244)new TextureState(class_10799.field_56883, gpuTextureView, pose, scissorArea, bounds, uvLeft, uvTop, uvRight, uvBottom, z, left, top, right, bottom));
    }

    public void renderItem(class_1799 itemStack, float left, float top) {
        this.getGuiGraphics().method_51445(itemStack, (int)left, (int)top);
    }

    public void renderItem(class_1799 itemStack, float size, float left, float top) {
        try (ScaleRAII ignored = this.scaleOnce(size);){
            this.renderItem(itemStack, left / size, top / size);
        }
    }

    public void renderEffect(class_6880<class_1291> effect, float left, float top) {
        class_2960 id = class_329.method_71644(effect);
        RenderPipeline renderPipeline = class_10799.field_56883;
        this.getGuiGraphics().method_52706(renderPipeline, id, (int)left, (int)top, 18, 18);
    }

    public void renderEffect(class_6880<class_1291> effect, float size, float left, float top) {
        try (ScaleRAII ignored = this.scaleOnce(size);){
            this.renderEffect(effect, left / size, top / size);
        }
    }

    public void renderComponentTooltipForNextFrameVanilla(List<class_2561> texts, float leftX, float topY) {
        this.getGuiGraphics().method_51434(this.getFont(), texts, (int)leftX, (int)topY);
    }

    public void renderComponentTooltipCenteredForNextFrameVanilla(List<class_2561> texts, float midX, float topY) {
        int maxLength = texts.stream().mapToInt(this::calcTextWidth).max().orElse(20);
        this.getGuiGraphics().method_51434(this.getFont(), texts, (int)(midX - (float)(maxLength + 20) / 2.0f), (int)topY);
    }

    public void renderComponentTooltip(List<class_2561> texts, float leftX, float topY) {
        this.renderTooltip(texts, leftX, topY, 1.0f);
    }

    public void renderComponentTooltip(List<class_2561> texts, float size, float leftX, float topY) {
        try (ScaleRAII ignored = this.scaleOnce(size);){
            this.renderTooltip(texts, leftX, topY, size);
        }
    }

    public void renderComponentTooltipCentered(List<class_2561> texts, float midX, float topY) {
        int maxLength = texts.stream().mapToInt(this::calcTextWidth).max().orElse(20);
        this.renderComponentTooltip(texts, midX - (float)(maxLength + 6) / 2.0f, topY);
    }

    public void renderComponentTooltipCentered(List<class_2561> texts, float size, float midX, float topY) {
        try (ScaleRAII ignored = this.scaleOnce(size);){
            int maxLength = texts.stream().mapToInt(this::calcTextWidth).max().orElse(20);
            this.renderTooltip(texts, midX - (float)(maxLength + 6) * size / 2.0f, topY, size);
        }
    }

    private void renderTooltip(List<class_2561> texts, float x, float y, float size) {
        class_5684 clientTooltipComponent2;
        int s;
        class_327 font = this.getFont();
        List<class_5684> list = texts.stream().map(class_2561::method_30937).map(class_5684::method_32662).toList();
        class_8000 clientTooltipPositioner = class_8001.field_41687;
        int width = 0;
        int height = list.size() == 1 ? -2 : 0;
        for (class_5684 clientTooltipComponent : list) {
            int m = clientTooltipComponent.method_32664(font);
            if (m > width) {
                width = m;
            }
            height += clientTooltipComponent.method_32661(font);
        }
        Vector2ic vector2ic = clientTooltipPositioner.method_47944((int)((float)this.getGuiGraphics().method_51421() / size), (int)((float)this.getGuiGraphics().method_51443() / size), (int)(x / size - 8.0f), (int)(y / size + 16.0f), width, height);
        int p = vector2ic.x();
        int q = vector2ic.y();
        this.getPose().pushMatrix();
        class_8002.method_47946((class_332)this.getGuiGraphics(), (int)p, (int)q, (int)width, (int)height, null);
        int r = q;
        for (s = 0; s < list.size(); ++s) {
            clientTooltipComponent2 = list.get(s);
            clientTooltipComponent2.method_32665(this.getGuiGraphics(), font, p, r);
            r += clientTooltipComponent2.method_32661(font) + (s == 0 ? 2 : 0);
        }
        r = q;
        for (s = 0; s < list.size(); ++s) {
            clientTooltipComponent2 = list.get(s);
            clientTooltipComponent2.method_32666(font, p, r, width, height, this.getGuiGraphics());
            r += clientTooltipComponent2.method_32661(font) + (s == 0 ? 2 : 0);
        }
        this.getPose().popMatrix();
    }

    public void renderEntityBottomed(class_1297 entity, @Nullable EntityRenderingCache cache, float left, float top, float right, float bottom, float rotateX, float rotateY, float forceScale) {
        this.renderEntity(entity, cache, left, top, right, bottom, rotateX, rotateY, forceScale, 1.0f);
    }

    public void renderEntityCentered(class_1297 entity, @Nullable EntityRenderingCache cache, float left, float top, float right, float bottom, float rotateX, float rotateY) {
        this.renderEntity(entity, cache, left, top, right, bottom, rotateX, rotateY, -1.0f, 1.9f);
    }

    public void renderEntityCentered(class_1297 entity, @Nullable EntityRenderingCache cache, float left, float top, float right, float bottom, float rotateX, float rotateY, float forceScale) {
        this.renderEntity(entity, cache, left, top, right, bottom, rotateX, rotateY, forceScale, 1.9f);
    }

    private void renderEntity(class_1297 entity, @Nullable EntityRenderingCache cache, float left, float top, float right, float bottom, float rotateX, float rotateY, float forceScale, float internalOffset) {
        float f;
        float scale;
        boolean cached;
        float width = right - left;
        float height = bottom - top;
        float entityWidth = entity.method_17681();
        float entityHeight = entity.method_17682();
        boolean bl = cached = cache != null && cache.cached && cache.width == width && cache.height == height && cache.entityWidth == entityWidth && cache.entityHeight == entityHeight;
        if (cached) {
            scale = cache.scale;
        } else if (forceScale < 0.0f) {
            float vw = entityWidth > 1.8f ? entityWidth / 1.4f : (float)Math.log(1.1f + entityWidth);
            float vh = entityHeight > 2.2f ? entityHeight / 1.8f : (float)Math.log(1.1f + entityHeight);
            scale = Math.min(width / vw, height / vh) / 2.2f;
        } else {
            scale = Math.min(width / entityWidth, height / entityHeight) / 1.5f * forceScale;
        }
        int x0 = class_3532.method_15386((float)left);
        int y0 = class_3532.method_15386((float)top);
        int x1 = class_3532.method_15375((float)right);
        int y1 = class_3532.method_15375((float)bottom);
        Quaternionf quaternionf = new Quaternionf().rotateX(rotateY * 20.0f * ((float)Math.PI / 180));
        Quaternionf quaternionf2 = new Quaternionf().rotateY((float)Math.PI - rotateX * 20.0f * ((float)Math.PI / 180));
        Quaternionf quaternionf3 = new Quaternionf().rotateZ((float)Math.PI);
        quaternionf.mul((Quaternionfc)quaternionf2).mul((Quaternionfc)quaternionf3);
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            f = living.method_55693();
        } else {
            f = 1.0f;
        }
        float sc = f;
        Vector3f vector3f = new Vector3f(0.0f, entity.method_17682() / internalOffset + 0.0625f * sc, 0.0f);
        class_898 entityRenderDispatcher = this.getClient().method_1561();
        class_897 entityRenderer = RenderUtils.getRenderer(entityRenderDispatcher, entity);
        class_10017 entityRenderState = cache != null && cache.entityRenderState != null ? cache.entityRenderState : RenderUtils.createRenderState(entityRenderer);
        entityRenderer.method_62354(entity, entityRenderState, 1.0f);
        entityRenderState.field_61820 = 0xF000F0;
        entityRenderState.field_61823.clear();
        entityRenderState.field_61821 = 0;
        this.getGuiGraphics().method_70856(entityRenderState, scale / sc, vector3f, quaternionf, null, x0, y0, x1, y1);
        if (this.isDebug() && width > 0.0f && height > 0.0f) {
            int color = -5592406;
            this.renderRectangle(-5592406, 0.6f, this.getZ(), left, top, right, bottom);
        }
        if (cache != null && !cached) {
            cache.cached = true;
            cache.width = width;
            cache.height = height;
            cache.entityWidth = entityWidth;
            cache.entityHeight = entityHeight;
            cache.entityRenderState = entityRenderState;
            cache.scale = scale;
        }
    }

    public void renderPlayerFace(class_742 player, float left, float top) {
        this.renderPlayerFace(player, left, top, 8.0f);
    }

    public void renderPlayerFace(class_742 player, float left, float top, float size) {
        boolean ud = class_1007.method_74936((class_1657)player);
        class_7532.method_44445((class_332)this.getGuiGraphics(), (class_2960)player.method_52814().comp_1626().comp_3627(), (int)((int)left), (int)((int)top), (int)((int)size), (boolean)true, (boolean)ud, (int)-1);
    }

    private static class_8030 getBounds(float x0, float y0, float x1, float y1, Matrix3x2f matrix3x2f, @Nullable class_8030 screenRectangle) {
        int x0i = class_3532.method_15375((float)x0);
        int x1i = class_3532.method_15386((float)x1);
        int y0i = class_3532.method_15375((float)y0);
        int y1i = class_3532.method_15386((float)y1);
        class_8030 screenRectangle2 = new class_8030(x0i, y0i, x1i - x0i, y1i - y0i).method_71523((Matrix3x2fc)matrix3x2f);
        return screenRectangle != null ? screenRectangle.method_49701(screenRectangle2) : screenRectangle2;
    }

    public static final class EntityRenderingCache {
        private boolean cached;
        private float width;
        private float height;
        private float entityWidth;
        private float entityHeight;
        private class_10017 entityRenderState;
        private float scale;
    }
}

