/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.common.net;

import io.github.xienaoban.biologydictionary.common.net.Packet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public final class PacketUtil {
    private static final Map<Class<? extends Packet>, class_8710.class_9154<?>> TYPE_CACHE = new HashMap();

    private PacketUtil() {
    }

    public static <T extends Packet> void registerType(Class<T> clazz) {
        if (TYPE_CACHE.containsKey(clazz)) {
            throw new IllegalStateException("Packet class " + clazz.getName() + " has already been registered");
        }
        TYPE_CACHE.put(clazz, new class_8710.class_9154(PacketUtil.generateId(clazz)));
    }

    public static <T extends Packet> class_8710.class_9154<T> getType(Class<T> clazz) {
        class_8710.class_9154<?> type = TYPE_CACHE.get(clazz);
        if (type == null) {
            throw new IllegalArgumentException("Packet type not registered: " + clazz.getName());
        }
        return type;
    }

    public static <T extends Packet> class_9139<class_2540, T> generateCodec(Packet.Factory<T> factory) {
        return class_9139.method_56437((buf, packet) -> packet.write((class_2540)buf), factory::create);
    }

    public static boolean hasClientReceiver(Class<? extends Packet> clazz) {
        return Arrays.stream(clazz.getDeclaredMethods()).anyMatch(m -> "clientReceive".equals(m.getName()) && m.getParameterCount() == 1);
    }

    public static boolean hasServerReceiver(Class<? extends Packet> clazz) {
        return Arrays.stream(clazz.getDeclaredMethods()).anyMatch(m -> "serverReceive".equals(m.getName()) && m.getParameterCount() == 1);
    }

    private static class_2960 generateId(Class<?> clazz) {
        String classEnd = "Packet";
        String className = clazz.getSimpleName();
        if (!className.endsWith("Packet")) {
            throw new RuntimeException("Class doesn't ends with \"Packet\": " + clazz.getName());
        }
        String path = className.substring(0, className.length() - "Packet".length()).replaceAll("([A-Z]+)", "_$1").substring(1).toLowerCase();
        return class_2960.method_60655((String)"biologydictionary", (String)path);
    }
}

