/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.common.util;

import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;

public final class DevUtils {
    public static final String MINECRAFT_PACKAGE = "net.minecraft";
    private static String modVersion = null;

    public static String getModVersion(String modId) {
        if (modVersion != null) {
            return modVersion;
        }
        String version = "<unknown>";
        Optional modContainer = FabricLoader.getInstance().getModContainer(modId);
        if (modContainer.isPresent()) {
            version = ((ModContainer)modContainer.get()).getMetadata().getVersion().toString();
        }
        modVersion = version;
        return modVersion;
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static <T> T clientOnly(Supplier<T> supplier) {
        return DevUtils.isClient() ? (T)supplier.get() : null;
    }

    public static Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static boolean isVanillaClass(Class<?> clazz) {
        return DevUtils.isVanillaClass(clazz.getPackageName());
    }

    public static boolean isVanillaClass(String clazzName) {
        return clazzName.startsWith(MINECRAFT_PACKAGE);
    }

    public static boolean isVanilaResourceLocation(class_2960 id) {
        return "minecraft".equals(id.method_12836());
    }

    public static <T> Comparator<T> getClassNameComparator(Function<T, String> getter) {
        return (t1, t2) -> {
            boolean isVanilla2;
            String s1 = (String)getter.apply(t1);
            String s2 = (String)getter.apply(t2);
            boolean isVanilla1 = DevUtils.isVanillaClass(s1);
            if (isVanilla1 == (isVanilla2 = DevUtils.isVanillaClass(s2))) {
                return s1.compareTo(s2);
            }
            return isVanilla1 ? -1 : 1;
        };
    }

    public static <T> Comparator<T> getResourceLocationComparator(Function<T, class_2960> getter) {
        return (t1, t2) -> {
            boolean isVanilla2;
            class_2960 id1 = (class_2960)getter.apply(t1);
            class_2960 id2 = (class_2960)getter.apply(t2);
            boolean isVanilla1 = DevUtils.isVanilaResourceLocation(id1);
            if (isVanilla1 == (isVanilla2 = DevUtils.isVanilaResourceLocation(id2))) {
                return id1.method_12832().compareTo(id2.method_12832());
            }
            return isVanilla1 ? -1 : 1;
        };
    }
}

