/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.common.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public class ListenerList<T> {
    private volatile T[] listeners;

    public ListenerList(Class<?> listenerClass) {
        this.listeners = (Object[])Array.newInstance(listenerClass, 0);
    }

    public synchronized void addListener(T listener) {
        int oldLength = this.listeners.length;
        T[] newListeners = Arrays.copyOf(this.listeners, oldLength + 1);
        newListeners[oldLength] = listener;
        this.listeners = newListeners;
    }

    public T[] getListeners() {
        return this.listeners;
    }
}

